/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.system.OS;
import com.intellij.util.ui.JBUI;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/wm/impl/IdeRootPaneBorderHelper;", "", "<init>", "()V", "install", "", "app", "Lcom/intellij/openapi/application/Application;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "frame", "Ljavax/swing/JFrame;", "frameDecorator", "Lcom/intellij/openapi/wm/impl/IdeFrameDecorator;", "rootPane", "Ljavax/swing/JRootPane;", "installLinuxBorder", "application", "cs", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "isFullScreen", "", "frameState", "", "intellij.platform.ide.impl"})
public final class IdeRootPaneBorderHelper {
    @NotNull
    public static final IdeRootPaneBorderHelper INSTANCE = new IdeRootPaneBorderHelper();

    private IdeRootPaneBorderHelper() {
    }

    public final void install(@NotNull Application app, @NotNull CoroutineScope coroutineScope, @NotNull JFrame frame, @Nullable IdeFrameDecorator frameDecorator, @NotNull JRootPane rootPane) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)rootPane, (String)"rootPane");
        if (OS.isGenericUnix()) {
            this.installLinuxBorder(app, coroutineScope, frame, frameDecorator, rootPane);
        } else {
            rootPane.setBorder(UIManager.getBorder("Window.border"));
        }
    }

    private final void installLinuxBorder(Application application, CoroutineScope cs, JFrame frame, IdeFrameDecorator frameDecorator, JRootPane rootPane) {
        IdeFrameDecorator ideFrameDecorator = frameDecorator;
        AtomicReference<Boolean> fullScreen = new AtomicReference<Boolean>(ideFrameDecorator != null ? ideFrameDecorator.isInFullScreen() : false);
        SimpleMessageBusConnection simpleMessageBusConnection = application.getMessageBus().connect(cs);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, arg_0 -> IdeRootPaneBorderHelper.installLinuxBorder$lambda$0(rootPane, fullScreen, frame, arg_0));
        SimpleMessageBusConnection simpleMessageBusConnection2 = application.getMessageBus().connect(cs);
        Topic topic2 = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        simpleMessageBusConnection2.subscribe(topic2, arg_0 -> IdeRootPaneBorderHelper.installLinuxBorder$lambda$1(rootPane, fullScreen, frame, arg_0));
        WindowStateListener windowStateListener = arg_0 -> IdeRootPaneBorderHelper.installLinuxBorder$lambda$2(rootPane, fullScreen, arg_0);
        frame.addWindowStateListener(windowStateListener);
        JobKt.getJob((CoroutineContext)cs.getCoroutineContext()).invokeOnCompletion(arg_0 -> IdeRootPaneBorderHelper.installLinuxBorder$lambda$3(frame, windowStateListener, arg_0));
        if (frameDecorator != null) {
            rootPane.addPropertyChangeListener("ide.frame.full.screen", arg_0 -> IdeRootPaneBorderHelper.installLinuxBorder$lambda$4(fullScreen, frameDecorator, rootPane, frame, arg_0));
        }
        UISettings uISettings = UISettings.Companion.getInstance();
        Boolean bl = fullScreen.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        this.installLinuxBorder(rootPane, uISettings, bl, frame.getExtendedState());
    }

    private final void installLinuxBorder(JRootPane rootPane, UISettings uiSettings, boolean isFullScreen, int frameState) {
        boolean maximized = (frameState & 6) == 6;
        boolean undecorated = !isFullScreen && !maximized && CustomWindowHeaderUtil.INSTANCE.hideNativeLinuxTitle$intellij_platform_ide_impl(uiSettings);
        rootPane.setBorder(JBUI.CurrentTheme.Window.getBorder((boolean)undecorated));
    }

    private static final void installLinuxBorder$lambda$0(JRootPane $rootPane, AtomicReference $fullScreen, JFrame $frame, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($rootPane.getWindowDecorationStyle() == 0) {
            UISettings uISettings = UISettings.Companion.getInstance();
            Object v = $fullScreen.get();
            Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
            INSTANCE.installLinuxBorder($rootPane, uISettings, (Boolean)v, $frame.getExtendedState());
        }
    }

    private static final void installLinuxBorder$lambda$1(JRootPane $rootPane, AtomicReference $fullScreen, JFrame $frame, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = $fullScreen.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        INSTANCE.installLinuxBorder($rootPane, it, (Boolean)v, $frame.getExtendedState());
    }

    private static final void installLinuxBorder$lambda$2(JRootPane $rootPane, AtomicReference $fullScreen, WindowEvent it) {
        UISettings uISettings = UISettings.Companion.getInstance();
        Object v = $fullScreen.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        INSTANCE.installLinuxBorder($rootPane, uISettings, (Boolean)v, it.getNewState());
    }

    private static final Unit installLinuxBorder$lambda$3(JFrame $frame, WindowStateListener $windowStateListener, Throwable it) {
        $frame.removeWindowStateListener($windowStateListener);
        return Unit.INSTANCE;
    }

    private static final void installLinuxBorder$lambda$4(AtomicReference $fullScreen, IdeFrameDecorator $frameDecorator, JRootPane $rootPane, JFrame $frame, PropertyChangeEvent it) {
        $fullScreen.set($frameDecorator.isInFullScreen());
        UISettings uISettings = UISettings.Companion.getInstance();
        Object v = $fullScreen.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        INSTANCE.installLinuxBorder($rootPane, uISettings, (Boolean)v, $frame.getExtendedState());
    }
}

