/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.util.BitUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.nio.file.Path;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B(\u0012\r\b\u0001\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001aH\u0016J\r\u0010!\u001a\u00070\u0004\u00a2\u0006\u0002\b\"H\u0017R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/wm/impl/ProjectWindowAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "projectName", "", "Lcom/intellij/openapi/util/NlsSafe;", "projectLocation", "Ljava/nio/file/Path;", "previous", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Lcom/intellij/openapi/wm/impl/ProjectWindowAction;)V", "getProjectName", "()Ljava/lang/String;", "getProjectLocation", "()Ljava/nio/file/Path;", "myPrevious", "myNext", "dispose", "", "getPrevious", "()Lcom/intellij/openapi/wm/impl/ProjectWindowAction;", "next", "getNext", "findProject", "Lcom/intellij/openapi/project/Project;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "setSelected", "selected", "toString", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ProjectWindowAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final String projectName;
    @NotNull
    private final Path projectLocation;
    @Nullable
    private ProjectWindowAction myPrevious;
    @Nullable
    private ProjectWindowAction myNext;

    public ProjectWindowAction(@NlsSafe @NotNull String projectName, @NotNull Path projectLocation, @Nullable ProjectWindowAction previous) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)projectLocation, (String)"projectLocation");
        super(IdeBundle.message((String)"action.switch.project.text", (Object[])new Object[0]));
        this.projectName = projectName;
        this.projectLocation = projectLocation;
        if (previous == null) {
            this.myPrevious = this;
            this.myNext = this;
        } else {
            this.myPrevious = previous;
            this.myNext = previous.myNext;
            Intrinsics.checkNotNull((Object)((Object)this.myNext));
            this.myNext.myPrevious = this;
            Intrinsics.checkNotNull((Object)((Object)this.myPrevious));
            this.myPrevious.myNext = this;
        }
        this.getTemplatePresentation().setText(this.projectName, false);
        this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Never);
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final Path getProjectLocation() {
        return this.projectLocation;
    }

    public final void dispose() {
        block5: {
            if (Intrinsics.areEqual((Object)((Object)this.myPrevious), (Object)((Object)this))) {
                boolean bl = Intrinsics.areEqual((Object)((Object)this.myNext), (Object)((Object)this));
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                return;
            }
            if (Intrinsics.areEqual((Object)((Object)this.myNext), (Object)((Object)this))) {
                if (_Assertions.ENABLED) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                return;
            }
            if (this.myPrevious != null) {
                this.myPrevious.myNext = this.myNext;
            }
            if (this.myNext == null) break block5;
            this.myNext.myPrevious = this.myPrevious;
        }
    }

    @Nullable
    public final ProjectWindowAction getPrevious() {
        return this.myPrevious;
    }

    @Nullable
    public final ProjectWindowAction getNext() {
        return this.myNext;
    }

    private final Project findProject() {
        if (Intrinsics.areEqual((Object)LightEditService.Companion.getWindowName(), (Object)this.projectName)) {
            return LightEditService.Companion.getInstance().getProject();
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project2 : projectArray) {
            Intrinsics.checkNotNull((Object)project2, (String)"null cannot be cast to non-null type com.intellij.project.ProjectStoreOwner");
            if (!Intrinsics.areEqual((Object)this.projectLocation, (Object)((ProjectStoreOwner)project2).getComponentStore().getStoreDescriptor().getPresentableUrl())) continue;
            return project2;
        }
        return null;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.PROJECT);
        ProjectStoreOwner projectStoreOwner = object instanceof ProjectStoreOwner ? (ProjectStoreOwner)object : null;
        if (projectStoreOwner == null) {
            return false;
        }
        ProjectStoreOwner project2 = projectStoreOwner;
        return Intrinsics.areEqual((Object)this.projectLocation, (Object)project2.getComponentStore().getStoreDescriptor().getPresentableUrl());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = this.findProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        JFrame jFrame = WindowManager.getInstance().getFrame(project3);
        if (jFrame == null) {
            return;
        }
        JFrame projectFrame = jFrame;
        int frameState = projectFrame.getExtendedState();
        if (SystemInfoRt.isMac && BitUtil.isSet((int)projectFrame.getExtendedState(), (int)1) && e.getInputEvent() instanceof KeyEvent) {
            return;
        }
        if (BitUtil.isSet((int)frameState, (int)1)) {
            projectFrame.setExtendedState(BitUtil.set((int)frameState, (int)1, (boolean)false));
        }
        projectFrame.toFront();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> ProjectWindowAction.setSelected$lambda$0(projectFrame));
    }

    @NonNls
    @NotNull
    public String toString() {
        String string = this.getTemplatePresentation().getText();
        ProjectWindowAction projectWindowAction = this.myPrevious;
        Intrinsics.checkNotNull((Object)((Object)projectWindowAction));
        String string2 = projectWindowAction.getTemplatePresentation().getText();
        ProjectWindowAction projectWindowAction2 = this.myNext;
        Intrinsics.checkNotNull((Object)((Object)projectWindowAction2));
        return string + " previous: " + string2 + " next: " + projectWindowAction2.getTemplatePresentation().getText();
    }

    private static final void setSelected$lambda$0(JFrame $projectFrame) {
        Component mostRecentFocusOwner = $projectFrame.getMostRecentFocusOwner();
        if (mostRecentFocusOwner != null) {
            IdeFocusManager.getGlobalInstance().requestFocus(mostRecentFocusOwner, true);
        }
    }
}

