/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.RegisterToolWindowTaskData;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ClientProperty;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\b\u0010\u000e\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010*$\b\u0002\u0010\u0004\"\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a8\u0006\u001c"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "performShowInSeparateTask", "", "Mutation", "Lkotlin/Function1;", "Lcom/intellij/openapi/wm/impl/WindowInfoImpl;", "", "areAllModifiersPressed", "modifiers", "", "mask", "keyCodeToInputMask", "code", "getActivateToolWindowVKsMask", "isStackEnabled", "()Z", "getToolWindowIdForComponent", "", "component", "Ljava/awt/Component;", "windowInfoChanges", "oldInfo", "Lcom/intellij/openapi/wm/WindowInfo;", "newInfo", "isToolwindowOfBundledPlugin", "task", "Lcom/intellij/openapi/wm/RegisterToolWindowTaskData;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowManagerImpl.kt\ncom/intellij/openapi/wm/impl/ToolWindowManagerImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,2683:1\n13#2:2684\n*S KotlinDebug\n*F\n+ 1 ToolWindowManagerImpl.kt\ncom/intellij/openapi/wm/impl/ToolWindowManagerImplKt\n*L\n89#1:2684\n*E\n"})
public final class ToolWindowManagerImplKt {
    @NotNull
    private static final Logger LOG;
    private static final boolean performShowInSeparateTask;

    private static final boolean areAllModifiersPressed(int modifiers, int mask) {
        return (modifiers ^ mask) == 0;
    }

    private static final int keyCodeToInputMask(int code) {
        return switch (code) {
            case 16 -> 1;
            case 17 -> 2;
            case 157 -> 4;
            case 18 -> 8;
            default -> 0;
        };
    }

    private static final int getActivateToolWindowVKsMask() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return 0;
        }
        if (Registry.Companion.is("toolwindow.disable.overlay.by.double.key")) {
            return 0;
        }
        Shortcut[] shortcutArray = KeymapManager.getInstance().getActiveKeymap().getShortcuts("ActivateProjectToolWindow");
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        Shortcut[] baseShortcut = shortcutArray;
        int defaultModifiers = SystemInfoRt.isMac ? 4 : 8;
        int baseModifiers = 0;
        for (Shortcut each : baseShortcut) {
            KeyStroke keyStroke;
            if (!(each instanceof KeyboardShortcut)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((KeyboardShortcut)each).getFirstKeyStroke(), (String)"getFirstKeyStroke(...)");
            baseModifiers = keyStroke.getModifiers();
            if (baseModifiers > 0) break;
        }
        if (Integer.bitCount(baseModifiers &= 0xF) == 1) {
            return baseModifiers;
        }
        return defaultModifiers;
    }

    private static final boolean isStackEnabled() {
        return Registry.Companion.is("ide.enable.toolwindow.stack");
    }

    private static final String getToolWindowIdForComponent(Component component2) {
        Component c = component2;
        while (c != null) {
            if (c instanceof InternalDecoratorImpl) {
                return ((InternalDecoratorImpl)((Object)c)).toolWindow.getId();
            }
            JComponent jComponent = (JComponent)ClientProperty.get((Component)c, ToolWindowManagerImpl.PARENT_COMPONENT);
            c = jComponent != null ? (Component)jComponent : (Component)c.getParent();
        }
        return null;
    }

    private static final String windowInfoChanges(WindowInfo oldInfo, WindowInfo newInfo) {
        if (!(oldInfo instanceof WindowInfoImpl) || !(newInfo instanceof WindowInfoImpl)) {
            return "Logging of non-standard WindowInfo implementations is not supported";
        }
        StringBuilder sb = new StringBuilder("Changes:");
        Iterator iterator = ((Iterable)((WindowInfoImpl)newInfo).__getProperties()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            StoredProperty newProperty = (StoredProperty)iterator.next();
            StoredProperty oldProperty = (StoredProperty)CollectionsKt.getOrNull((List)((WindowInfoImpl)oldInfo).__getProperties(), (int)index);
            String name2 = newProperty.getName();
            if (oldProperty == null || !Intrinsics.areEqual((Object)oldProperty.getName(), (Object)name2)) {
                return "Old and new window info don't have the same property set: old=" + oldInfo + ", new=" + newInfo;
            }
            if (Intrinsics.areEqual((Object)newProperty, (Object)oldProperty)) continue;
            sb.append(' ').append(oldProperty).append(" -> ").append(newProperty);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean isToolwindowOfBundledPlugin(RegisterToolWindowTaskData task) {
        if (Intrinsics.areEqual((Object)"Dependencies", (Object)task.getId())) {
            return true;
        }
        PluginDescriptor pluginDescriptor = task.getPluginDescriptor();
        if (pluginDescriptor != null) {
            PluginDescriptor it = pluginDescriptor;
            boolean bl = false;
            return it.isBundled();
        }
        Object object = task.getContentFactory();
        if (object == null || (object = object.getClass()) == null) {
            return false;
        }
        PluginDescriptor pluginDescriptor2 = PluginManager.getPluginByClass((Class)object);
        return pluginDescriptor2 == null || pluginDescriptor2.isBundled();
    }

    public static final /* synthetic */ String access$getToolWindowIdForComponent(Component component2) {
        return ToolWindowManagerImplKt.getToolWindowIdForComponent(component2);
    }

    public static final /* synthetic */ int access$getActivateToolWindowVKsMask() {
        return ToolWindowManagerImplKt.getActivateToolWindowVKsMask();
    }

    public static final /* synthetic */ int access$keyCodeToInputMask(int code) {
        return ToolWindowManagerImplKt.keyCodeToInputMask(code);
    }

    public static final /* synthetic */ boolean access$areAllModifiersPressed(int modifiers, int mask) {
        return ToolWindowManagerImplKt.areAllModifiersPressed(modifiers, mask);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isStackEnabled() {
        return ToolWindowManagerImplKt.isStackEnabled();
    }

    public static final /* synthetic */ boolean access$getPerformShowInSeparateTask$p() {
        return performShowInSeparateTask;
    }

    public static final /* synthetic */ boolean access$isToolwindowOfBundledPlugin(RegisterToolWindowTaskData task) {
        return ToolWindowManagerImplKt.isToolwindowOfBundledPlugin(task);
    }

    public static final /* synthetic */ String access$windowInfoChanges(WindowInfo oldInfo, WindowInfo newInfo) {
        return ToolWindowManagerImplKt.windowInfoChanges(oldInfo, newInfo);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolWindowManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        performShowInSeparateTask = Boolean.parseBoolean(System.getProperty("idea.toolwindow.show.separate.task", "false"));
    }
}

