/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header.titleLabel;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.titleLabel.DefaultPartTitle;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.titleLabel.ProjectTitle;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.titleLabel.ShrinkingTitlePart;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/titleLabel/ProjectTitlePane;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/titleLabel/ShrinkingTitlePart;", "<init>", "()V", "openChat", "", "closeChar", "unparsed", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/titleLabel/DefaultPartTitle;", "projectTitle", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/titleLabel/ProjectTitle;", "value", "", "active", "getActive", "()Z", "setActive", "(Z)V", "Lcom/intellij/openapi/project/Project;", "project", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "updatePath", "", "longWidth", "", "getLongWidth", "()I", "shortWidth", "getShortWidth", "toolTipPart", "getToolTipPart", "()Ljava/lang/String;", "getLong", "getShort", "refresh", "label", "Ljavax/swing/JComponent;", "fm", "Ljava/awt/FontMetrics;", "shrink", "maxWidth", "intellij.platform.ide.impl"})
public final class ProjectTitlePane
implements ShrinkingTitlePart {
    @NotNull
    private final String openChat;
    @NotNull
    private final String closeChar;
    @NotNull
    private final DefaultPartTitle unparsed = new DefaultPartTitle(null, null, 3, null);
    @NotNull
    private final ProjectTitle projectTitle = new ProjectTitle();
    @Nullable
    private Project project;

    public ProjectTitlePane() {
        this.openChat = " [";
        this.closeChar = "]";
    }

    @Override
    public boolean getActive() {
        return this.projectTitle.getActive();
    }

    @Override
    public void setActive(boolean value) {
        this.projectTitle.setActive(value);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@Nullable Project value) {
        this.project = value;
        this.updatePath();
    }

    private final void updatePath() {
        Project project2 = this.project;
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            if (!it.isDisposed()) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String name2 = string;
                String string2 = FileUtil.toSystemDependentName((String)FileUtil.getLocationRelativeToUserHome((String)it.getBasePath()));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
                String path = string2;
                this.projectTitle.setProject(name2);
                this.projectTitle.setPath(path);
                this.unparsed.setShortText(name2);
                this.unparsed.setLongText(name2 + this.openChat + path + this.closeChar);
                this.projectTitle.setOpenChar(this.openChat);
                this.projectTitle.setCloseChar(this.closeChar);
                return;
            }
        }
        this.projectTitle.setProject("");
        this.projectTitle.setPath("");
        this.unparsed.setShortText("");
        this.unparsed.setLongText("");
    }

    @Override
    public int getLongWidth() {
        return this.projectTitle.getLongWidth();
    }

    @Override
    public int getShortWidth() {
        return this.projectTitle.getShortWidth();
    }

    @Override
    @NotNull
    public String getToolTipPart() {
        return this.unparsed.getToolTipPart();
    }

    @Override
    @NotNull
    public String getLong() {
        return this.projectTitle.getLong();
    }

    @Override
    @NotNull
    public String getShort() {
        return this.projectTitle.getShort();
    }

    @Override
    public void refresh(@NotNull JComponent label2, @NotNull FontMetrics fm) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        this.unparsed.refresh(label2, fm);
        this.projectTitle.refresh(label2, fm);
    }

    @Override
    @NotNull
    public String shrink(@NotNull JComponent label2, @NotNull FontMetrics fm, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        return this.projectTitle.shrink(label2, fm, maxWidth);
    }
}

