/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header.toolbar;

import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ProjectWindowCustomizerServiceKt;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.RootPaneUtil;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.toolbar.IdeMenuHelper;
import com.intellij.platform.ide.menu.IdeJMenuBar;
import com.intellij.ui.SideBorder;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.util.IJSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0002./B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010 \u001a\u00020\nJ\b\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u001c\u0010$\u001a\u00020#2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010'\u001a\u00020(J\u001c\u0010)\u001a\u00020#2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010+\u001a\u00020#J\b\u0010,\u001a\u00020#H\u0002J\b\u0010-\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/ExpandableMenu;", "", "headerContent", "Ljavax/swing/JComponent;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "frame", "Ljavax/swing/JFrame;", "shouldBeColored", "Lkotlin/Function0;", "", "<init>", "(Ljavax/swing/JComponent;Lkotlinx/coroutines/CoroutineScope;Ljavax/swing/JFrame;Lkotlin/jvm/functions/Function0;)V", "ideMenu", "Lcom/intellij/platform/ide/menu/IdeJMenuBar;", "getIdeMenu", "()Lcom/intellij/platform/ide/menu/IdeJMenuBar;", "ideMenuHelper", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/IdeMenuHelper;", "expandedMenuBar", "Ljavax/swing/JPanel;", "headerColorfulPanel", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/ExpandableMenu$HeaderColorfulPanel;", "shadowComponent", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/ExpandableMenu$ShadowComponent;", "rootPane", "Ljavax/swing/JRootPane;", "getRootPane", "()Ljavax/swing/JRootPane;", "hideMenu", "menuSelectionListener", "Ljavax/swing/event/ChangeListener;", "isEnabled", "isShowing", "updateUI", "", "switchState", "actionMenuToShow", "Lcom/intellij/openapi/actionSystem/impl/ActionMenu;", "itemInd", "", "selectMenu", "actionMenu", "updateColor", "updateBounds", "hideExpandedMenuBar", "HeaderColorfulPanel", "ShadowComponent", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nExpandableMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpandableMenu.kt\ncom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/ExpandableMenu\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1#2:231\n*E\n"})
public final class ExpandableMenu {
    @NotNull
    private final JComponent headerContent;
    @Nullable
    private final Function0<Boolean> shouldBeColored;
    @NotNull
    private final IdeJMenuBar ideMenu;
    @NotNull
    private final IdeMenuHelper ideMenuHelper;
    @Nullable
    private JPanel expandedMenuBar;
    @Nullable
    private HeaderColorfulPanel headerColorfulPanel;
    @NotNull
    private final ShadowComponent shadowComponent;
    private boolean hideMenu;
    @NotNull
    private final ChangeListener menuSelectionListener;

    public ExpandableMenu(@NotNull JComponent headerContent, @NotNull CoroutineScope coroutineScope, @NotNull JFrame frame, @Nullable Function0<Boolean> shouldBeColored) {
        Intrinsics.checkNotNullParameter((Object)headerContent, (String)"headerContent");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.headerContent = headerContent;
        this.shouldBeColored = shouldBeColored;
        this.ideMenu = RootPaneUtil.INSTANCE.createMenuBar(coroutineScope, frame, null);
        this.ideMenuHelper = new IdeMenuHelper(this.ideMenu, null);
        this.shadowComponent = new ShadowComponent();
        this.menuSelectionListener = arg_0 -> ExpandableMenu.menuSelectionListener$lambda$0(this, arg_0);
        MenuSelectionManager.defaultManager().addChangeListener(this.menuSelectionListener);
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> ExpandableMenu._init_$lambda$0(this, arg_0));
        this.ideMenuHelper.installListeners();
        this.headerContent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.updateBounds();
            }
        });
    }

    public /* synthetic */ ExpandableMenu(JComponent jComponent, CoroutineScope coroutineScope, JFrame jFrame, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = null;
        }
        this(jComponent, coroutineScope, jFrame, (Function0<Boolean>)function0);
    }

    @NotNull
    public final IdeJMenuBar getIdeMenu() {
        return this.ideMenu;
    }

    private final JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this.headerContent);
    }

    public final boolean isEnabled() {
        return !SystemInfoRt.isMac && Registry.Companion.is("ide.main.menu.expand.horizontal");
    }

    private final boolean isShowing() {
        return this.expandedMenuBar != null;
    }

    private final void updateUI() {
        IJSwingUtilities.updateComponentTreeUI(this.ideMenu);
        this.ideMenu.setBorder(null);
        this.ideMenuHelper.updateUI();
    }

    /*
     * WARNING - void declaration
     */
    public final void switchState(@Nullable ActionMenu actionMenuToShow, int itemInd) {
        void $this$switchState_u24lambda_u241;
        DialogPanel dialogPanel;
        if (this.isShowing() && actionMenuToShow == null) {
            this.hideExpandedMenuBar();
            return;
        }
        this.hideExpandedMenuBar();
        JComponent jComponent = this.getRootPane();
        if (jComponent == null || (jComponent = ((JRootPane)jComponent).getLayeredPane()) == null) {
            return;
        }
        JComponent layeredPane2 = jComponent;
        DialogPanel dialogPanel2 = dialogPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ExpandableMenu.switchState$lambda$0(this, arg_0)));
        ExpandableMenu expandableMenu = this;
        boolean bl = false;
        $this$switchState_u24lambda_u241.setOpaque(false);
        expandableMenu.expandedMenuBar = (JPanel)dialogPanel;
        this.updateUI();
        this.updateBounds();
        this.updateColor();
        JPanel jPanel = this.expandedMenuBar;
        Intrinsics.checkNotNull((Object)jPanel);
        layeredPane2.add((Component)jPanel, (Object)(JLayeredPane.DEFAULT_LAYER - 2));
        ApplicationManager.getApplication().invokeLater(() -> ExpandableMenu.switchState$lambda$2(this, actionMenuToShow, itemInd));
    }

    public static /* synthetic */ void switchState$default(ExpandableMenu expandableMenu, ActionMenu actionMenu, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            actionMenu = null;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        expandableMenu.switchState(actionMenu, n);
    }

    private final void selectMenu(ActionMenu actionMenu, int itemInd) {
        JMenu menu = this.ideMenu.getMenu(itemInd);
        if (actionMenu != null) {
            for (ActionMenu m : this.ideMenu.getRootMenuItems()) {
                if (m.getMnemonic() != actionMenu.getMnemonic()) continue;
                menu = (JMenu)((Object)m);
                break;
            }
        }
        if (menu == null) {
            return;
        }
        MenuElement[] subElements = menu.getPopupMenu().getSubElements();
        Intrinsics.checkNotNull((Object)subElements);
        if (subElements.length == 0) {
            var5_5 = new MenuElement[]{this.ideMenu, menu};
            MenuSelectionManager.defaultManager().setSelectedPath(var5_5);
        } else {
            var5_5 = new MenuElement[]{this.ideMenu, menu, menu.getPopupMenu(), subElements[0]};
            MenuSelectionManager.defaultManager().setSelectedPath(var5_5);
        }
    }

    static /* synthetic */ void selectMenu$default(ExpandableMenu expandableMenu, ActionMenu actionMenu, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            actionMenu = null;
        }
        expandableMenu.selectMenu(actionMenu, n);
    }

    public final void updateColor() {
        Color color = this.headerContent.getBackground();
        HeaderColorfulPanel headerColorfulPanel = this.headerColorfulPanel;
        if (headerColorfulPanel != null) {
            headerColorfulPanel.setBackground(color);
        }
        HeaderColorfulPanel headerColorfulPanel2 = this.headerColorfulPanel;
        if (headerColorfulPanel2 != null) {
            headerColorfulPanel2.setBorder((Border)new SideBorder(color, 4, 1));
        }
        this.shadowComponent.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 153));
    }

    private final void updateBounds() {
        block3: {
            Point location;
            JRootPane rootPaneCopy;
            block2: {
                JRootPane jRootPane = this.getRootPane();
                if (jRootPane == null) {
                    return;
                }
                rootPaneCopy = jRootPane;
                location = SwingUtilities.convertPoint(this.headerContent, 0, 0, rootPaneCopy);
                if (location != null) break block2;
                HeaderColorfulPanel headerColorfulPanel = this.headerColorfulPanel;
                if (headerColorfulPanel == null) break block3;
                headerColorfulPanel.setHorizontalOffset(0);
                break block3;
            }
            Insets insets = this.headerContent.getInsets();
            HeaderColorfulPanel headerColorfulPanel = this.headerColorfulPanel;
            if (headerColorfulPanel != null) {
                headerColorfulPanel.setHorizontalOffset(location.x + insets.left);
            }
            JPanel jPanel = this.expandedMenuBar;
            if (jPanel == null) break block3;
            JPanel it = jPanel;
            boolean bl = false;
            Insets rootPaneInsets = rootPaneCopy.getInsets();
            it.setBounds(new Rectangle(location.x + insets.left - rootPaneInsets.left, location.y + insets.top - rootPaneInsets.top, this.headerContent.getWidth() - insets.left - insets.right, this.headerContent.getHeight() - insets.top - insets.bottom));
        }
    }

    private final void hideExpandedMenuBar() {
        block2: {
            if (!this.isShowing()) break block2;
            JComponent jComponent = this.getRootPane();
            if (jComponent != null && (jComponent = ((JRootPane)jComponent).getLayeredPane()) != null) {
                jComponent.remove(this.expandedMenuBar);
            }
            this.expandedMenuBar = null;
            this.headerColorfulPanel = null;
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                jRootPane.repaint();
            }
        }
    }

    private static final void menuSelectionListener$lambda$0(ExpandableMenu this$0, ChangeEvent it) {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray == null || menuElementArray.length == 0) {
            this$0.hideMenu = true;
            ApplicationManager.getApplication().invokeLater(() -> ExpandableMenu.menuSelectionListener$lambda$0$0(this$0));
        } else {
            this$0.hideMenu = false;
        }
    }

    private static final void menuSelectionListener$lambda$0$0(ExpandableMenu this$0) {
        if (this$0.hideMenu) {
            this$0.hideMenu = false;
            this$0.hideExpandedMenuBar();
        }
    }

    private static final Unit _init_$lambda$0(ExpandableMenu this$0, Throwable it) {
        MenuSelectionManager.defaultManager().removeChangeListener(this$0.menuSelectionListener);
        return Unit.INSTANCE;
    }

    private static final Unit switchState$lambda$0(ExpandableMenu this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), (Function1<? super Panel, Unit>)((Function1)arg_0 -> ExpandableMenu.switchState$lambda$0$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit switchState$lambda$0$0(ExpandableMenu this$0, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default($this$customizeSpacingConfiguration, null, arg_0 -> ExpandableMenu.switchState$lambda$0$0$0(this$0, arg_0), 1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit switchState$lambda$0$0$0(ExpandableMenu this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Function0<Boolean> function0 = this$0.shouldBeColored;
        this$0.headerColorfulPanel = (HeaderColorfulPanel)$this$row.cell((JComponent)new HeaderColorfulPanel(this$0.ideMenu, function0 != null ? (Boolean)function0.invoke() : true)).align(AlignY.FILL.INSTANCE).getComponent();
        $this$row.cell((JComponent)this$0.shadowComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final void switchState$lambda$2(ExpandableMenu this$0, ActionMenu $actionMenuToShow, int $itemInd) {
        this$0.selectMenu($actionMenuToShow, $itemInd);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/ExpandableMenu$HeaderColorfulPanel;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "isColored", "", "<init>", "(Ljavax/swing/JComponent;Z)V", "horizontalOffset", "", "getHorizontalOffset", "()I", "setHorizontalOffset", "(I)V", "getPreferredSize", "Ljava/awt/Dimension;", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
    private static final class HeaderColorfulPanel
    extends JPanel {
        private final boolean isColored;
        private int horizontalOffset;

        public HeaderColorfulPanel(@NotNull JComponent component2, boolean isColored) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.isColored = isColored;
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)component2, "Center");
            ProjectWindowCustomizerServiceKt.repaintWhenProjectGradientOffsetChanged(this);
        }

        public final int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public final void setHorizontalOffset(int n) {
            this.horizontalOffset = n;
        }

        @Override
        @Nullable
        public Dimension getPreferredSize() {
            Dimension size2 = super.getPreferredSize();
            return new Dimension(size2.width + 12, size2.height);
        }

        @Override
        public void paint(@Nullable Graphics g) {
            Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D cfr_ignored_0 = (Graphics2D)g;
            ((Graphics2D)g).setColor(this.getBackground());
            ((Graphics2D)g).fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.isColored) {
                Window root;
                ((Graphics2D)g).translate(-this.horizontalOffset, 0);
                Component component2 = SwingUtilities.getRoot(this);
                Window window = root = component2 instanceof Window ? (Window)component2 : null;
                if (root != null) {
                    ProjectWindowCustomizerService.Companion.getInstance().paint(root, this, (Graphics2D)g);
                }
                ((Graphics2D)g).translate(this.horizontalOffset, 0);
            }
            super.paint(g);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/ExpandableMenu$ShadowComponent;", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/ExpandableMenu;)V", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
    private final class ShadowComponent
    extends JComponent {
        public ShadowComponent() {
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ExpandableMenu.this.hideExpandedMenuBar();
                }
            });
        }

        @Override
        public void paint(@Nullable Graphics g) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            ((Graphics2D)g).setColor(this.getBackground());
            ((Graphics2D)g).fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

