/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/wm/impl/status/EditorBasedWidgetHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFocusedEditor", "Lcom/intellij/openapi/editor/Editor;", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "getFocusedComponent", "Ljava/awt/Component;", "getEditor", "isOurEditor", "", "editor", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class EditorBasedWidgetHelper {
    @NotNull
    private final Project project;

    public EditorBasedWidgetHelper(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Editor getFocusedEditor(@Nullable StatusBar statusBar) {
        Component component2 = this.getFocusedComponent();
        Editor editor2 = component2 instanceof EditorComponentImpl ? (Editor)((EditorComponentImpl)component2).getEditor() : this.getEditor(statusBar);
        return editor2 != null && !editor2.isDisposed() ? editor2 : null;
    }

    @Nullable
    public final Component getFocusedComponent() {
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 != null) {
            Component it = component2;
            boolean bl = false;
            return it;
        }
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
        Window window = focusManager.getLastFocusedIdeWindow();
        if (window == null) {
            return null;
        }
        return focusManager.getLastFocusedFor(window);
    }

    @Nullable
    public final Editor getEditor(@Nullable StatusBar statusBar) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(statusBar);
        return fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOurEditor(@Nullable Editor editor2, @Nullable StatusBar statusBar) {
        if (editor2 == null) return false;
        if (!editor2.getComponent().isShowing()) return false;
        if (Intrinsics.areEqual((Object)editor2.getUserData(EditorTextField.SUPPLEMENTARY_KEY), (Object)true)) return false;
        JComponent jComponent = editor2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        if (StatusBarUtil.INSTANCE.getStatusBar$intellij_platform_ide_impl(jComponent) != statusBar) return false;
        return true;
    }
}

