/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class PowerSaveStatusWidgetFactory
implements StatusBarWidgetFactory {
    private static final String ID = "PowerSaveMode";

    PowerSaveStatusWidgetFactory() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(PowerSaveMode.TOPIC, () -> {
            for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
                if (statusBar == null) continue;
                statusBar.updateWidget(ID);
            }
        });
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"power.save.mode.widget.display.name", (Object[])new Object[0]);
        if (string == null) {
            PowerSaveStatusWidgetFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project2) {
        if (project2 == null) {
            PowerSaveStatusWidgetFactory.$$$reportNull$$$0(1);
        }
        return new PowerWidget();
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/PowerSaveStatusWidgetFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/PowerSaveStatusWidgetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class PowerWidget
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation {
        private PowerWidget() {
        }

        @NotNull
        public String ID() {
            return PowerSaveStatusWidgetFactory.ID;
        }

        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            PowerWidget powerWidget = this;
            if (powerWidget == null) {
                PowerWidget.$$$reportNull$$$0(0);
            }
            return powerWidget;
        }

        @NotNull
        public String getTooltipText() {
            String string = PowerSaveMode.isEnabled() ? InspectionsBundle.message((String)"power.save.mode.widget.tooltip.enabled", (Object[])new Object[0]) : InspectionsBundle.message((String)"power.save.mode.widget.tooltip.disabled", (Object[])new Object[0]);
            if (string == null) {
                PowerWidget.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public Consumer<MouseEvent> getClickConsumer() {
            Consumer consumer = __ -> PowerSaveMode.setEnabled((!PowerSaveMode.isEnabled() ? 1 : 0) != 0);
            if (consumer == null) {
                PowerWidget.$$$reportNull$$$0(2);
            }
            return consumer;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = PowerSaveMode.isEnabled() ? AllIcons.General.InspectionsPowerSaveMode : AllIcons.General.InspectionsEye;
            if (icon2 == null) {
                PowerWidget.$$$reportNull$$$0(3);
            }
            return icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/wm/impl/status/PowerSaveStatusWidgetFactory$PowerWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClickConsumer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

