/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEvents;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeFrameProvider;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.NoProjectStateHandlerKt;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.platform.ide.bootstrap.SplashManagerKt;
import com.intellij.platform.ide.diagnostic.startUpPerformanceReporter.FUSProjectHotStartUpMeasurer;
import com.intellij.platform.ide.menu.IdeJMenuBarKt;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.DisposableWindow;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001!B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeFrame;", "Ljavax/swing/JFrame;", "Lcom/intellij/openapi/wm/IdeFrame;", "Lcom/intellij/util/ui/accessibility/AccessibleContextAccessor;", "Lcom/intellij/ui/DisposableWindow;", "<init>", "()V", "myScreen", "Lcom/intellij/openapi/wm/WelcomeScreen;", "myBalloonLayout", "Lcom/intellij/ui/BalloonLayout;", "listenerDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "isDisposed", "", "dispose", "", "isWindowDisposed", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "getBalloonLayout", "suggestChildFrameBounds", "Ljava/awt/Rectangle;", "getProject", "Lcom/intellij/openapi/project/Project;", "setFrameTitle", "title", "", "getComponent", "Ljavax/swing/JComponent;", "getCurrentAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "Companion", "intellij.platform.ide.impl"})
public final class WelcomeFrame
extends JFrame
implements IdeFrame,
AccessibleContextAccessor,
DisposableWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WelcomeScreen myScreen;
    @NotNull
    private final BalloonLayout myBalloonLayout;
    @NotNull
    private final Disposable listenerDisposable;
    private boolean isDisposed;
    @JvmField
    @NotNull
    public static final ExtensionPointName<WelcomeFrameProvider> EP = new ExtensionPointName("com.intellij.welcomeFrameProvider");
    @NotNull
    public static final String DIMENSION_KEY = "WELCOME_SCREEN";
    @Nullable
    private static IdeFrame instance;
    @Nullable
    private static Disposable touchbar;

    public WelcomeFrame() {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.listenerDisposable = disposable;
        SplashManagerKt.hideSplashBeforeShow(this);
        JRootPane rootPane = this.getRootPane();
        Intrinsics.checkNotNull((Object)rootPane);
        WelcomeScreen screen = WelcomeFrame.Companion.createScreen(rootPane);
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane, false, 2, null);
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.setContentPane(screen.getWelcomePanel());
        this.setTitle(ApplicationNamesInfo.getInstance().getFullProductName());
        AppUIUtilKt.updateAppWindowIcon(this);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(this.listenerDisposable);
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                this.dispose();
            }
        });
        JBInsets jBInsets = JBUI.insets((int)8);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        this.myBalloonLayout = new BalloonLayoutImpl(rootPane, (Insets)jBInsets);
        this.myScreen = screen;
        Companion.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        this.myScreen.setupFrame((JFrame)this);
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), this::dispose);
    }

    @Override
    public void dispose() {
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        WelcomeFrame.Companion.saveLocation(rectangle);
        super.dispose();
        Disposer.dispose((Disposable)((Disposable)this.myScreen));
        Disposer.dispose((Disposable)this.listenerDisposable);
        Companion.resetInstance();
        this.isDisposed = true;
    }

    public boolean isWindowDisposed() {
        return this.isDisposed;
    }

    @Nullable
    public StatusBar getStatusBar() {
        Container pane2 = this.getContentPane();
        return pane2 instanceof JComponent ? (StatusBar)UIUtil.findComponentOfType((JComponent)((JComponent)pane2), IdeStatusBarImpl.class) : null;
    }

    @NotNull
    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        return rectangle;
    }

    @NotNull
    public Project getProject() {
        Project project2 = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        return project2;
    }

    public void setFrameTitle(@NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.setTitle(title2);
    }

    @NotNull
    public JComponent getComponent() {
        JRootPane jRootPane = this.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return jRootPane;
    }

    @NotNull
    public AccessibleContext getCurrentAccessibleContext() {
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    @JvmStatic
    @Nullable
    public static final IdeFrame getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final void showNow() {
        Companion.showNow();
    }

    @JvmStatic
    @JvmOverloads
    public static final void showIfNoProjectOpened(@Nullable AppLifecycleListener lifecyclePublisher) {
        Companion.showIfNoProjectOpened(lifecyclePublisher);
    }

    @JvmStatic
    @JvmOverloads
    public static final void showIfNoProjectOpened() {
        Companion.showIfNoProjectOpened();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\r\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u000fH\u0007J\u0010\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u001e\u001a\u00020\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeFrame$Companion;", "", "<init>", "()V", "EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/wm/WelcomeFrameProvider;", "DIMENSION_KEY", "", "instance", "Lcom/intellij/openapi/wm/IdeFrame;", "touchbar", "Lcom/intellij/openapi/Disposable;", "getInstance", "saveLocation", "", "location", "Ljava/awt/Rectangle;", "setupCloseAction", "frame", "Ljavax/swing/JFrame;", "createScreen", "Lcom/intellij/openapi/wm/WelcomeScreen;", "rootPane", "Ljavax/swing/JRootPane;", "resetInstance", "showNow", "prepareToShow", "Lkotlin/Function0;", "registerKeyboardShortcuts", "showIfNoProjectOpened", "lifecyclePublisher", "Lcom/intellij/ide/AppLifecycleListener;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nWelcomeFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeFrame.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/WelcomeFrame$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,254:1\n1#2:255\n42#3,3:256\n42#3,3:259\n42#3,3:262\n*S KotlinDebug\n*F\n+ 1 WelcomeFrame.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/WelcomeFrame$Companion\n*L\n164#1:256,3\n207#1:259,3\n214#1:262,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final IdeFrame getInstance() {
            return instance;
        }

        /*
         * WARNING - void declaration
         */
        private final void saveLocation(Rectangle location) {
            void it;
            int n;
            int n2 = n = 2;
            int n3 = location.height;
            int n4 = location.x + location.width / 2;
            boolean bl = false;
            location.y = it;
            Unit unit = Unit.INSTANCE;
            int n5 = n3 / n;
            int n6 = n4;
            Point middle = new Point(n6, n5);
            DimensionService.getInstance().setLocation(WelcomeFrame.DIMENSION_KEY, middle, null);
        }

        public final void setupCloseAction(@NotNull JFrame frame) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new WindowAdapter(frame){
                final /* synthetic */ JFrame $frame;
                {
                    this.$frame = $frame;
                }

                public void windowClosing(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project[] projectArray = ProjectUtilCore.getOpenProjects();
                    Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                    if (((Object[])projectArray).length == 0) {
                        int exitCode2;
                        boolean isActiveClone = CloneableProjectsService.Companion.getInstance().isCloneActive();
                        if (isActiveClone && (exitCode2 = Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"exit.confirm.prompt.tasks", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) == 2) {
                            return;
                        }
                        this.$frame.dispose();
                        ApplicationManager.getApplication().exit();
                    } else {
                        this.$frame.dispose();
                    }
                }
            });
        }

        private final WelcomeScreen createScreen(JRootPane rootPane) {
            for (WelcomeScreenProvider provider : WelcomeScreenProvider.EP_NAME.getExtensionList()) {
                WelcomeScreen welcomeScreen;
                if (!provider.isAvailable() || (welcomeScreen = provider.createWelcomeScreen(rootPane)) == null) continue;
                WelcomeScreen it = welcomeScreen;
                boolean bl = false;
                return it;
            }
            return new NewWelcomeScreen();
        }

        public final void resetInstance() {
            block0: {
                instance = null;
                Disposable disposable = touchbar;
                if (disposable == null) break block0;
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
                touchbar = null;
            }
        }

        @JvmStatic
        public final void showNow() {
            block0: {
                Function0<Unit> function0 = this.prepareToShow();
                if (function0 == null) break block0;
                function0.invoke();
            }
        }

        @ApiStatus.Internal
        @Nullable
        public final Function0<Unit> prepareToShow() {
            if (instance != null) {
                return null;
            }
            boolean $i$f$service = false;
            Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            BuildersKt.launch$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int I$0;
                int I$1;
                Object L$0;
                int label;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            int $i$f$serviceAsync = 0;
                            Application application = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                            ComponentManager $this$serviceAsync$iv$iv = (ComponentManager)application;
                            int $i$f$serviceAsync2 = 0;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                            this.I$0 = $i$f$serviceAsync;
                            this.I$1 = $i$f$serviceAsync2;
                            this.label = 1;
                            Object object2 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ActionManager.class, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            int $i$f$serviceAsync = this.I$1;
                            int $i$f$serviceAsync3 = this.I$0;
                            ComponentManager $this$serviceAsync$iv$iv = (ComponentManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return Companion::prepareToShow$lambda$0;
        }

        private final void registerKeyboardShortcuts(JRootPane rootPane) {
            ActionListener helpAction = Companion::registerKeyboardShortcuts$lambda$0;
            JComponent jComponent = rootPane;
            ShortcutSet shortcutSet = CommonShortcuts.getContextHelp();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getContextHelp(...)");
            ActionUtil.registerForEveryKeyboardShortcut((JComponent)jComponent, (ActionListener)helpAction, (ShortcutSet)shortcutSet);
            rootPane.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        }

        @JvmStatic
        @JvmOverloads
        public final void showIfNoProjectOpened(@Nullable AppLifecycleListener lifecyclePublisher) {
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode()) {
                return;
            }
            Function1<Continuation<? super Project>, Object> customHandler = NoProjectStateHandlerKt.findNoProjectStateHandler();
            if (customHandler != null) {
                boolean $i$f$service = false;
                Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                BuildersKt.launch$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(customHandler, null){
                    int label;
                    final /* synthetic */ Function1<Continuation<? super Project>, Object> $customHandler;
                    {
                        this.$customHandler = $customHandler;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$customHandler.invoke((Object)((Object)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                return;
            }
            Function0<Unit> function0 = this.prepareToShow();
            if (function0 == null) {
                return;
            }
            Function0<Unit> show2 = function0;
            boolean $i$f$service = false;
            Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            CoroutineScope coroutineScope = ((CoreUiCoroutineScopeHolder)object).coroutineScope;
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = ModalityState.nonModal();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(show2, lifecyclePublisher, null){
                int I$0;
                int I$1;
                Object L$0;
                int label;
                final /* synthetic */ Function0<Unit> $show;
                final /* synthetic */ AppLifecycleListener $lifecyclePublisher;
                {
                    this.$show = $show;
                    this.$lifecyclePublisher = $lifecyclePublisher;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $i$f$serviceAsync = 0;
                            v0 = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                            $this$serviceAsync$iv$iv = (ComponentManager)v0;
                            $i$f$serviceAsync = 0;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                            this.I$0 = $i$f$serviceAsync;
                            this.I$1 = $i$f$serviceAsync;
                            this.label = 1;
                            v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(WindowManager.class, (Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl26
                        }
                        case 1: {
                            $i$f$serviceAsync = this.I$1;
                            $i$f$serviceAsync = this.I$0;
                            $this$serviceAsync$iv$iv = (ComponentManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl26:
                            // 2 sources

                            var3_9 = v1;
                            v2 = var3_9 instanceof WindowManagerImpl != false ? (WindowManagerImpl)var3_9 : null;
                            if (v2 == null) {
                                return Unit.INSTANCE;
                            }
                            windowManager = v2;
                            windowManager.disposeRootFrame$intellij_platform_ide_impl();
                            if (windowManager.getProjectFrameHelpers().isEmpty()) {
                                this.$show.invoke();
                                v3 = this.$lifecyclePublisher;
                                if (v3 != null) {
                                    v3.welcomeScreenDisplayed();
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public static /* synthetic */ void showIfNoProjectOpened$default(Companion companion, AppLifecycleListener appLifecycleListener, int n, Object object) {
            if ((n & 1) != 0) {
                appLifecycleListener = null;
            }
            companion.showIfNoProjectOpened(appLifecycleListener);
        }

        @JvmStatic
        @JvmOverloads
        public final void showIfNoProjectOpened() {
            com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame$Companion.showIfNoProjectOpened$default(this, null, 1, null);
        }

        private static final Unit prepareToShow$lambda$0() {
            if (instance != null) {
                return Unit.INSTANCE;
            }
            IdeFrame ideFrame = (IdeFrame)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)EP.lazySequence(), Companion::prepareToShow$lambda$0$0));
            if (ideFrame == null) {
                throw new IllegalStateException("No implementation of `com.intellij.welcomeFrameProvider` extension point");
            }
            IdeFrame frame = ideFrame;
            JFrame jFrame = (JFrame)frame;
            JRootPane jRootPane = jFrame.getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
            Companion.registerKeyboardShortcuts(jRootPane);
            SplashManagerKt.hideSplashBeforeShow(jFrame);
            jFrame.setVisible(true);
            FUSProjectHotStartUpMeasurer.INSTANCE.reportWelcomeScreenShown();
            IdeJMenuBarKt.installAppMenuIfNeeded(jFrame);
            instance = frame;
            if (SystemInfoRt.isMac) {
                touchbar = TouchbarSupport.showWindowActions(frame.getComponent());
            }
            return Unit.INSTANCE;
        }

        private static final IdeFrame prepareToShow$lambda$0$0(WelcomeFrameProvider it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.createFrame();
        }

        private static final void registerKeyboardShortcuts$lambda$0(ActionEvent it) {
            FeatureUsageUiEvents.logClickOnHelpDialog$default((FeatureUsageUiEvents)FeatureUsageUiEventsKt.getUiEventLogger(), WelcomeFrame.class, null, (int)2, null);
            HelpManager.getInstance().invokeHelp("welcome");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

