/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\rJ\b\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\rH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeBalloonLayoutImpl;", "parent", "Ljavax/swing/JRootPane;", "insets", "Ljava/awt/Insets;", "<init>", "(Ljavax/swing/JRootPane;Ljava/awt/Insets;)V", "myShowState", "Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl$ShowState;", "myScrollController", "Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl$ScrollController;", "add", "", "newBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "layoutData", "", "autoPopup", "showPopup", "updateVisible", "visible", "", "queueRelayout", "layoutBalloons", "getTotalHeight", "", "updateBalloons", "ScrollController", "ShowState", "ScrollInfo", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class WelcomeSeparateBalloonLayoutImpl
extends WelcomeBalloonLayoutImpl {
    @NotNull
    private final ShowState myShowState;
    @NotNull
    private final ScrollController myScrollController;

    public WelcomeSeparateBalloonLayoutImpl(@NotNull JRootPane parent, @NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        super(parent, insets);
        this.myShowState = new ShowState();
        this.myScrollController = new ScrollController();
    }

    @Override
    public void add(@NotNull Balloon newBalloon, @Nullable Object layoutData) {
        Intrinsics.checkNotNullParameter((Object)newBalloon, (String)"newBalloon");
        if (layoutData instanceof BalloonLayoutData && ((BalloonLayoutData)layoutData).welcomeScreen && newBalloon instanceof BalloonImpl) {
            ((BalloonLayoutData)layoutData).doLayout = () -> WelcomeSeparateBalloonLayoutImpl.add$lambda$0(this);
            ((BalloonImpl)newBalloon).setBlockClicks(true);
            ((BalloonImpl)newBalloon).setAnimationEnabled(false);
            ((BalloonImpl)newBalloon).getContent().putClientProperty("Type", ((BalloonLayoutData)layoutData).type);
            ((BalloonImpl)newBalloon).setHideListener(new BalloonImpl.HideListenerWithMouse(this, newBalloon){
                final /* synthetic */ WelcomeSeparateBalloonLayoutImpl this$0;
                final /* synthetic */ Balloon $newBalloon;
                {
                    this.this$0 = $receiver;
                    this.$newBalloon = $newBalloon;
                }

                public void run(MouseEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!this.this$0.myVisible) {
                        return;
                    }
                    RelativePoint relativePoint = new RelativePoint(event);
                    if (WelcomeSeparateBalloonLayoutImpl.access$getMyScrollController$p(this.this$0).isInside(relativePoint)) {
                        return;
                    }
                    Iterator<E> iterator = WelcomeSeparateBalloonLayoutImpl.access$getBalloons$p(this.this$0).iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator<E> iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        E e = iterator2.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        Balloon balloon2 = (Balloon)e;
                        if (balloon2 == this.$newBalloon || !((BalloonImpl)balloon2).isInside(relativePoint)) continue;
                        if (WelcomeSeparateBalloonLayoutImpl.access$getMyScrollController$p(this.this$0).checkClip((BalloonImpl)balloon2, relativePoint)) break;
                        return;
                    }
                    this.run();
                }

                public void run() {
                    Runnable runnable2 = this.this$0.hideListener;
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                    if (this.this$0.myVisible) {
                        WelcomeSeparateBalloonLayoutImpl.access$updateVisible(this.this$0, false);
                        WelcomeSeparateBalloonLayoutImpl.access$getMyScrollController$p(this.this$0).hide(true);
                        WelcomeSeparateBalloonLayoutImpl.access$getMyShowState$p(this.this$0).hide();
                    }
                }
            });
            Disposer.register((Disposable)((Disposable)newBalloon), () -> WelcomeSeparateBalloonLayoutImpl.add$lambda$1(this, newBalloon));
            this.balloons.add(newBalloon);
            if (!((BalloonImpl)newBalloon).isDisposed()) {
                JLayeredPane jLayeredPane = this.layeredPane;
                Intrinsics.checkNotNull((Object)jLayeredPane);
                if (jLayeredPane.isShowing()) {
                    ((BalloonImpl)newBalloon).show(this.layeredPane);
                    JComponent jComponent = ((BalloonImpl)newBalloon).getComponent();
                    if (jComponent != null) {
                        jComponent.setVisible(this.myVisible);
                    }
                }
            }
            this.updateBalloons();
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic<WelcomeBalloonLayoutImpl.BalloonNotificationListener> topic = WelcomeBalloonLayoutImpl.BALLOON_NOTIFICATION_TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"BALLOON_NOTIFICATION_TOPIC");
            ((WelcomeBalloonLayoutImpl.BalloonNotificationListener)messageBus.syncPublisher(topic)).newNotifications();
        } else {
            super.add(newBalloon, layoutData);
        }
    }

    public final void autoPopup() {
        WelcomeBalloonLayoutImpl balloonLayout;
        IdeFrame ideFrame = WelcomeFrame.Companion.getInstance();
        BalloonLayout balloonLayout2 = ideFrame != null ? ideFrame.getBalloonLayout() : null;
        WelcomeBalloonLayoutImpl welcomeBalloonLayoutImpl = balloonLayout = balloonLayout2 instanceof WelcomeBalloonLayoutImpl ? (WelcomeBalloonLayoutImpl)balloonLayout2 : null;
        if (balloonLayout != null && !balloonLayout.myVisible && balloonLayout.getLocationComponent() != null) {
            this.showPopup();
        }
    }

    @Override
    public void showPopup() {
        if (this.myShowState.isRecentlyHidden()) {
            Runnable runnable2 = this.hideListener;
            if (runnable2 != null) {
                runnable2.run();
            }
            return;
        }
        this.updateVisible(true);
        this.layoutBalloons();
        this.myShowState.show();
    }

    private final void updateVisible(boolean visible) {
        this.myVisible = visible;
        Iterator iterator = this.balloons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Balloon balloon2 = (Balloon)e;
            ((BalloonImpl)balloon2).getComponent().setVisible(visible);
        }
    }

    @Override
    public void queueRelayout() {
        if (this.myVisible) {
            this.layoutBalloons();
        }
    }

    private final void layoutBalloons() {
        if (this.myLayoutBaseComponent == null || this.layeredPane == null || this.balloons.isEmpty()) {
            return;
        }
        JLayeredPane jLayeredPane = this.layeredPane;
        Intrinsics.checkNotNull((Object)jLayeredPane);
        this.myScrollController.ensureStart(jLayeredPane);
        this.calculateSize();
        int startY = SwingUtilities.convertPoint((Component)this.myLayoutBaseComponent, (int)0, (int)0, (Component)((Component)this.layeredPane)).y;
        JLayeredPane jLayeredPane2 = this.layeredPane;
        Intrinsics.checkNotNull((Object)jLayeredPane2);
        int totalWidth = jLayeredPane2.getSize().width;
        JLayeredPane jLayeredPane3 = this.layeredPane;
        Intrinsics.checkNotNull((Object)jLayeredPane3);
        Object header = jLayeredPane3.getClientProperty("CUSTOM_HEADER");
        int headerHeight = header instanceof JComponent ? ((JComponent)header).getHeight() : 0;
        this.myScrollController.configure(totalWidth, headerHeight, startY - headerHeight);
        this.setBounds(this.balloons, totalWidth - JBUI.scale((int)10), startY + this.myScrollController.getStartY());
        this.myScrollController.setClip(headerHeight, startY);
    }

    private final int getTotalHeight() {
        int height = 0;
        Iterator iterator = this.balloons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Balloon balloon2 = (Balloon)e;
            height += this.getSize((Balloon)balloon2).height;
        }
        return height;
    }

    private final void updateBalloons() {
        ArrayList<NotificationType> types = new ArrayList<NotificationType>();
        Iterator iterator = this.balloons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Balloon balloon2 = (Balloon)e;
            Object object = ((BalloonImpl)balloon2).getContent().getClientProperty("Type");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.notification.NotificationType");
            types.add((NotificationType)object);
        }
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<WelcomeBalloonLayoutImpl.BalloonNotificationListener> topic = WelcomeBalloonLayoutImpl.BALLOON_NOTIFICATION_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"BALLOON_NOTIFICATION_TOPIC");
        ((WelcomeBalloonLayoutImpl.BalloonNotificationListener)messageBus.syncPublisher(topic)).notificationsChanged((List<NotificationType>)types);
        if (this.myVisible) {
            if (this.balloons.isEmpty()) {
                this.myVisible = false;
                this.myScrollController.hide(false);
            } else {
                this.layoutBalloons();
            }
        }
    }

    private static final void add$lambda$0(WelcomeSeparateBalloonLayoutImpl this$0) {
        this$0.layoutBalloons();
    }

    private static final void add$lambda$1(WelcomeSeparateBalloonLayoutImpl this$0, Balloon $newBalloon) {
        this$0.balloons.remove($newBalloon);
        this$0.updateBalloons();
    }

    public static final /* synthetic */ ScrollController access$getMyScrollController$p(WelcomeSeparateBalloonLayoutImpl $this) {
        return $this.myScrollController;
    }

    public static final /* synthetic */ void access$updateVisible(WelcomeSeparateBalloonLayoutImpl $this, boolean visible) {
        $this.updateVisible(visible);
    }

    public static final /* synthetic */ ShowState access$getMyShowState$p(WelcomeSeparateBalloonLayoutImpl $this) {
        return $this.myShowState;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\b\u0010 \u001a\u00020\u0017H\u0002J\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl$ScrollController;", "", "<init>", "(Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl;)V", "myScrollBar", "Lcom/intellij/ui/components/JBScrollBar;", "myState", "Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl$ScrollInfo;", "myStartValue", "", "myValue", "startY", "getStartY", "()I", "setStartY", "(I)V", "myAwtListener", "Ljava/awt/event/AWTEventListener;", "isInside", "", "relativePoint", "Lcom/intellij/ui/awt/RelativePoint;", "hide", "", "save", "ensureStart", "parent", "Ljavax/swing/JComponent;", "configure", "totalWidth", "endY", "setClip", "clearClip", "checkClip", "balloon", "Lcom/intellij/ui/BalloonImpl;", "intellij.platform.ide.impl"})
    private final class ScrollController {
        @NotNull
        private JBScrollBar myScrollBar = new JBScrollBar();
        @NotNull
        private ScrollInfo myState = new ScrollInfo(0, 0, 0, false);
        private int myStartValue;
        private int myValue;
        private int startY;
        @Nullable
        private AWTEventListener myAwtListener;

        public final int getStartY() {
            return this.startY;
        }

        public final void setStartY(int n) {
            this.startY = n;
        }

        public final boolean isInside(@NotNull RelativePoint relativePoint) {
            Intrinsics.checkNotNullParameter((Object)relativePoint, (String)"relativePoint");
            return this.myScrollBar.isVisible() && this.myScrollBar.contains(relativePoint.getPoint((Component)this.myScrollBar));
        }

        public final void hide(boolean save2) {
            if (save2 && this.myScrollBar.isVisible()) {
                this.myState.setValue(this.myValue);
                this.myState.setSave(true);
            } else {
                this.myState.setSave(false);
            }
            this.hide();
        }

        private final void hide() {
            if (this.myAwtListener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtListener);
                this.myAwtListener = null;
            }
            this.myScrollBar.setVisible(false);
            this.startY = 0;
            this.myStartValue = 0;
            this.myValue = 0;
        }

        public final void ensureStart(@NotNull JComponent parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (this.myScrollBar.getParent() != null) {
                return;
            }
            parent.add((Component)this.myScrollBar);
            this.myScrollBar.toggle(true);
            this.hide();
            this.myScrollBar.addAdjustmentListener(arg_0 -> ScrollController.ensureStart$lambda$0(this, WelcomeSeparateBalloonLayoutImpl.this, arg_0));
        }

        public final void configure(int totalWidth, int startY, int endY) {
            int totalHeight = WelcomeSeparateBalloonLayoutImpl.this.getTotalHeight();
            if (totalHeight <= endY) {
                this.hide(false);
            } else {
                if (this.myScrollBar.isVisible()) {
                    int delta = endY - this.myScrollBar.getModel().getExtent() + this.myScrollBar.getMaximum() - totalHeight;
                    if (delta != 0) {
                        if (this.myValue > 0) {
                            this.myValue = Math.max(0, this.myValue - delta);
                        }
                        this.myStartValue = totalHeight - endY;
                        this.startY = this.myStartValue - this.myValue;
                    }
                } else {
                    this.myStartValue = totalHeight - endY;
                    if (this.myState.getSave() && this.myState.getTotalHeight() == totalHeight && this.myState.getExtent() == endY) {
                        this.myValue = this.myState.getValue();
                        this.startY = this.myStartValue - this.myValue;
                    } else {
                        this.myValue = this.myStartValue;
                        this.startY = 0;
                    }
                }
                this.myState.setTotalHeight(totalHeight);
                this.myState.setExtent(endY);
                this.myState.setSave(false);
                this.myScrollBar.setValues(this.myValue, endY, 0, totalHeight);
                int scrollBarWidth = this.myScrollBar.getPreferredSize().width;
                this.myScrollBar.setBounds(totalWidth - scrollBarWidth, startY, scrollBarWidth, endY);
                this.myScrollBar.setVisible(true);
                if (this.myAwtListener == null) {
                    this.myAwtListener = arg_0 -> ScrollController.configure$lambda$0(this, arg_0);
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.myAwtListener, 131072L);
                }
            }
            this.clearClip();
        }

        public final void setClip(int startY, int endY) {
            if (this.myScrollBar.isVisible()) {
                Iterator iterator = WelcomeSeparateBalloonLayoutImpl.this.balloons.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    int clipY;
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Balloon balloon2 = (Balloon)e;
                    BalloonImpl balloonImpl = (BalloonImpl)balloon2;
                    Rectangle bounds = balloonImpl.getComponent().getBounds();
                    if (bounds.y > endY || bounds.getMaxY() < (double)startY) {
                        balloonImpl.setClipY(-1);
                        balloonImpl.getComponent().setVisible(false);
                        continue;
                    }
                    if (bounds.getMaxY() > (double)endY) {
                        clipY = endY - bounds.y;
                        balloonImpl.setClipY(clipY);
                        balloonImpl.getComponent().setVisible(true);
                        balloonImpl.setActionButtonsVisible(clipY > JBUI.scale((int)26));
                        continue;
                    }
                    if (bounds.y < startY) {
                        clipY = startY - bounds.y;
                        balloonImpl.setClipY(clipY);
                        balloonImpl.setTopClip(true);
                        balloonImpl.getComponent().setVisible(true);
                        balloonImpl.setActionButtonsVisible(false);
                        continue;
                    }
                    balloonImpl.setClipY(-1);
                    balloonImpl.getComponent().setVisible(true);
                }
            } else {
                this.clearClip();
            }
        }

        private final void clearClip() {
            Iterator iterator = WelcomeSeparateBalloonLayoutImpl.this.balloons.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Balloon balloon2 = (Balloon)e;
                BalloonImpl balloonImpl = (BalloonImpl)balloon2;
                balloonImpl.setClipY(-1);
                balloonImpl.setTopClip(false);
                JComponent jComponent = balloonImpl.getComponent();
                if (jComponent == null) continue;
                jComponent.setVisible(true);
            }
        }

        public final boolean checkClip(@NotNull BalloonImpl balloon2, @NotNull RelativePoint relativePoint) {
            Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
            Intrinsics.checkNotNullParameter((Object)relativePoint, (String)"relativePoint");
            int clip = balloon2.getClipY();
            if (clip == -1) {
                return false;
            }
            if (clip == 0) {
                return true;
            }
            return relativePoint.getPoint((Component)((Component)balloon2.getComponent())).y > clip;
        }

        private static final void ensureStart$lambda$0(ScrollController this$0, WelcomeSeparateBalloonLayoutImpl this$1, AdjustmentEvent it) {
            int value = this$0.myScrollBar.getValue();
            if (this$0.myValue != value) {
                this$0.myValue = value;
                this$0.startY = this$0.myStartValue - value;
                this$1.layoutBalloons();
            }
        }

        private static final void configure$lambda$0(ScrollController this$0, AWTEvent event) {
            Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type java.awt.event.MouseWheelEvent");
            if (this$0.isInside(new RelativePoint((MouseEvent)((MouseWheelEvent)event)))) {
                this$0.myScrollBar.handleMouseWheelEvent((MouseWheelEvent)event);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl$ScrollInfo;", "", "totalHeight", "", "extent", "value", "save", "", "<init>", "(IIIZ)V", "getTotalHeight", "()I", "setTotalHeight", "(I)V", "getExtent", "setExtent", "getValue", "setValue", "getSave", "()Z", "setSave", "(Z)V", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    private static final class ScrollInfo {
        private int totalHeight;
        private int extent;
        private int value;
        private boolean save;

        public ScrollInfo(int totalHeight, int extent, int value, boolean save2) {
            this.totalHeight = totalHeight;
            this.extent = extent;
            this.value = value;
            this.save = save2;
        }

        public final int getTotalHeight() {
            return this.totalHeight;
        }

        public final void setTotalHeight(int n) {
            this.totalHeight = n;
        }

        public final int getExtent() {
            return this.extent;
        }

        public final void setExtent(int n) {
            this.extent = n;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        public final boolean getSave() {
            return this.save;
        }

        public final void setSave(boolean bl) {
            this.save = bl;
        }

        public final int component1() {
            return this.totalHeight;
        }

        public final int component2() {
            return this.extent;
        }

        public final int component3() {
            return this.value;
        }

        public final boolean component4() {
            return this.save;
        }

        @NotNull
        public final ScrollInfo copy(int totalHeight, int extent, int value, boolean save2) {
            return new ScrollInfo(totalHeight, extent, value, save2);
        }

        public static /* synthetic */ ScrollInfo copy$default(ScrollInfo scrollInfo, int n, int n2, int n3, boolean bl, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = scrollInfo.totalHeight;
            }
            if ((n4 & 2) != 0) {
                n2 = scrollInfo.extent;
            }
            if ((n4 & 4) != 0) {
                n3 = scrollInfo.value;
            }
            if ((n4 & 8) != 0) {
                bl = scrollInfo.save;
            }
            return scrollInfo.copy(n, n2, n3, bl);
        }

        @NotNull
        public String toString() {
            return "ScrollInfo(totalHeight=" + this.totalHeight + ", extent=" + this.extent + ", value=" + this.value + ", save=" + this.save + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.totalHeight);
            result2 = result2 * 31 + Integer.hashCode(this.extent);
            result2 = result2 * 31 + Integer.hashCode(this.value);
            result2 = result2 * 31 + Boolean.hashCode(this.save);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScrollInfo)) {
                return false;
            }
            ScrollInfo scrollInfo = (ScrollInfo)other;
            if (this.totalHeight != scrollInfo.totalHeight) {
                return false;
            }
            if (this.extent != scrollInfo.extent) {
                return false;
            }
            if (this.value != scrollInfo.value) {
                return false;
            }
            return this.save == scrollInfo.save;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/WelcomeSeparateBalloonLayoutImpl$ShowState;", "", "<init>", "()V", "hiddenLongEnough", "", "timeHiddenAt", "", "show", "", "hide", "isRecentlyHidden", "intellij.platform.ide.impl"})
    private static final class ShowState {
        private boolean hiddenLongEnough = true;
        private long timeHiddenAt;

        public final void show() {
            this.hiddenLongEnough = true;
            this.timeHiddenAt = 0L;
        }

        public final void hide() {
            this.hiddenLongEnough = false;
            this.timeHiddenAt = System.currentTimeMillis();
        }

        public final boolean isRecentlyHidden() {
            if (this.hiddenLongEnough) {
                return false;
            }
            this.hiddenLongEnough = true;
            return System.currentTimeMillis() - this.timeHiddenAt < 200L;
        }
    }
}

