/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.collapsedActionGroup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.collapsedActionGroup.CollapsedActionGroup;
import com.intellij.openapi.wm.impl.welcomeScreen.collapsedActionGroup.CollapsibleGroupHeaderSeparator;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CollapsibleGroupedItemsListRenderer
implements ListCellRenderer<AnAction> {
    private final CollapsibleGroupHeaderSeparator separator = new CollapsibleGroupHeaderSeparator();
    private final JLabel textLabel = new JLabel();
    private final JComponent panel = this.createMainPanel();

    public CollapsibleGroupedItemsListRenderer() {
        this.textLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        this.textLabel.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends AnAction> list2, AnAction value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof CollapsedActionGroup) {
            CollapsedActionGroup actionGroup = (CollapsedActionGroup)value;
            return this.prepareCollapsibleSeparator(list2, actionGroup);
        }
        if (value instanceof ActionGroup) {
            return this.prepareTitleSeparator(value);
        }
        return this.prepareActionRenderer(list2, value, isSelected);
    }

    private JComponent createMainPanel() {
        if (ExperimentalUI.isNewUI()) {
            SelectablePanel panel2 = SelectablePanel.wrap((Component)this.textLabel);
            PopupUtil.configListRendererFlexibleHeight((SelectablePanel)panel2);
            return panel2;
        }
        return JBUI.Panels.simplePanel((Component)this.textLabel).withBorder((Border)new EmptyBorder(JBUI.CurrentTheme.ActionsList.cellPadding()));
    }

    protected static void updateSelectedState(JComponent component2, boolean selected, Color background) {
        if (ExperimentalUI.isNewUI() && component2 instanceof SelectablePanel) {
            SelectablePanel selectablePanel = (SelectablePanel)component2;
            selectablePanel.setSelectionColor(selected ? JBUI.CurrentTheme.List.background((boolean)true, (boolean)true) : null);
            selectablePanel.setBackground(background);
        } else {
            UIUtil.setBackgroundRecursively((Component)component2, (Color)(selected ? UIUtil.getListSelectionBackground((boolean)true) : background));
        }
    }

    private CollapsibleGroupHeaderSeparator prepareCollapsibleSeparator(JList<? extends AnAction> list2, CollapsedActionGroup actionGroup) {
        DefaultListModel listMode;
        Object[] groupChildren = actionGroup.getChildren(ActionManager.getInstance());
        boolean groupExpanded = ContainerUtil.exists((Object[])groupChildren, arg_0 -> CollapsibleGroupedItemsListRenderer.lambda$prepareCollapsibleSeparator$0(listMode = (DefaultListModel)list2.getModel(), arg_0));
        if (!groupExpanded) {
            int maxChildWidth = Integer.MIN_VALUE;
            for (Object childAction : groupChildren) {
                this.setLabelByAction((AnAction)childAction);
                maxChildWidth = Math.max(maxChildWidth, this.panel.getPreferredSize().width);
            }
            Dimension preferredSize = this.separator.getPreferredSize();
            if (maxChildWidth != Integer.MIN_VALUE && maxChildWidth > preferredSize.width) {
                this.separator.setPreferredSize(new Dimension(maxChildWidth, preferredSize.height));
            }
        }
        this.separator.setCaption(actionGroup.getTemplateText());
        this.separator.setExpandedState(groupExpanded ? CollapsibleGroupHeaderSeparator.GroupHeaderSeparatorState.EXPANDED : CollapsibleGroupHeaderSeparator.GroupHeaderSeparatorState.COLLAPSED);
        return this.separator;
    }

    private CollapsibleGroupHeaderSeparator prepareTitleSeparator(AnAction value) {
        this.separator.setCaption(value.getTemplateText());
        this.separator.setExpandedState(CollapsibleGroupHeaderSeparator.GroupHeaderSeparatorState.NONE);
        return this.separator;
    }

    private JComponent prepareActionRenderer(JList<? extends AnAction> list2, AnAction value, boolean isSelected) {
        this.setLabelByAction(value);
        CollapsibleGroupedItemsListRenderer.updateSelectedState(this.panel, isSelected, list2.getBackground());
        return this.panel;
    }

    private void setLabelByAction(@NotNull AnAction value) {
        if (value == null) {
            CollapsibleGroupedItemsListRenderer.$$$reportNull$$$0(0);
        }
        this.textLabel.setText(value.getTemplateText());
        this.textLabel.setIcon(value.getTemplatePresentation().getIcon());
    }

    private static /* synthetic */ boolean lambda$prepareCollapsibleSeparator$0(DefaultListModel listMode, AnAction item) {
        return listMode.contains(item);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/wm/impl/welcomeScreen/collapsedActionGroup/CollapsibleGroupedItemsListRenderer", "setLabelByAction"));
    }
}

