/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.logsUploader.LogUploader;
import com.intellij.ide.plugins.EssentialPluginMissingException;
import com.intellij.ide.plugins.PluginConflictReporter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.ExceptionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.ide.bootstrap.SplashManagerKt;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.URLUtil;
import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StartupErrorReporter {
    private static final String SUPPORT_URL_PROPERTY = "ij.startup.error.support.url";
    private static final String REPORT_URL_PROPERTY = "ij.startup.error.report.url";
    private static boolean hasGraphics = !ApplicationManagerEx.isInIntegrationTest();

    public static void pluginInstallationProblem(Throwable t) {
        StartupErrorReporter.showWarning("Plugin Installation Problem", "The IDE failed to install or update some plugins.\nPlease try again, and if the problem persists, report it to the support.\n\nThe cause: " + t.toString());
    }

    public static void showWarning(@NonNls String title2, @NonNls String message) {
        System.out.println();
        System.out.println("**" + title2 + "**");
        System.out.println();
        System.out.println(message);
        try {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), StartupErrorReporter.prepareMessage(message), title2, 2);
        }
        catch (Throwable t) {
            System.err.println("\n-----");
            t.printStackTrace(System.err);
        }
    }

    public static void showError(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String title2, @NotNull Throwable t) {
        if (title2 == null) {
            StartupErrorReporter.$$$reportNull$$$0(0);
        }
        if (t == null) {
            StartupErrorReporter.$$$reportNull$$$0(1);
        }
        StringWriter message = new StringWriter();
        AWTError awtError = StartupErrorReporter.findCause(t, AWTError.class);
        if (awtError != null) {
            message.append(BootstrapBundle.message((String)"bootstrap.error.prefix.graphics", (Object[])new Object[0]));
            hasGraphics = false;
            t = awtError;
        } else {
            message.append(BootstrapBundle.message((String)"bootstrap.error.prefix.other", (Object[])new Object[0]));
        }
        message.append("\n\n");
        t.printStackTrace(new PrintWriter(message));
        message.append("\n-----\n").append(BootstrapBundle.message((String)"bootstrap.error.appendix.jre", (Object[])new Object[]{StartupErrorReporter.jreDetails()}));
        StartupErrorReporter.showError(title2, message.toString(), t);
    }

    @NlsSafe
    private static String jreDetails() {
        Properties sp = System.getProperties();
        String jre = sp.getProperty("java.runtime.version", sp.getProperty("java.version", "(unknown)"));
        String vendor = sp.getProperty("java.vendor", "(unknown vendor)");
        String arch = sp.getProperty("os.arch", "(unknown arch)");
        String home = sp.getProperty("java.home", "(unknown java.home)");
        return jre + " " + arch + " (" + vendor + ")\n" + home;
    }

    public static void showError(@Nls(capitalization=Nls.Capitalization.Title) String title2, @Nls(capitalization=Nls.Capitalization.Sentence) String message) {
        StartupErrorReporter.showError(title2, message, null);
    }

    private static void showError(@Nls(capitalization=Nls.Capitalization.Title) String title2, @Nls(capitalization=Nls.Capitalization.Sentence) String message, @Nullable Throwable error) {
        System.err.println();
        System.err.println("**" + title2 + "**");
        System.err.println();
        System.err.println(message);
        if (!hasGraphics || AppMode.isCommandLine() || GraphicsEnvironment.isHeadless() || AppMode.isRemoteDevHost()) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            SplashManagerKt.hideSplash();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            JScrollPane messageObj = StartupErrorReporter.prepareMessage(message);
            String close2 = BootstrapBundle.message((String)"bootstrap.error.option.close", (Object[])new Object[0]);
            URL iconUrl = StartupErrorReporter.class.getResource("/images/questionSign.png");
            JLabel learnMore = iconUrl != null ? new JLabel(new ImageIcon(iconUrl)) : new JLabel("?");
            learnMore.setToolTipText(BootstrapBundle.message((String)"bootstrap.error.option.support", (Object[])new Object[0]));
            learnMore.setCursor(new Cursor(12));
            learnMore.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    StartupErrorReporter.supportCenter();
                }
            });
            if (error != null) {
                Object[] options2 = new Object[]{close2, BootstrapBundle.message((String)"bootstrap.error.option.reset", (Object[])new Object[0]), BootstrapBundle.message((String)"bootstrap.error.option.report", (Object[])new Object[0]), learnMore};
                int choice = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), messageObj, title2, -1, 0, null, options2, options2[0]);
                switch (choice) {
                    case 1: {
                        StartupErrorReporter.cleanStart();
                        break;
                    }
                    case 2: {
                        StartupErrorReporter.reportProblem(title2, message, error);
                    }
                }
            } else {
                Object[] options3 = new Object[]{close2, learnMore};
                JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), messageObj, title2, -1, 0, null, options3, options3[0]);
            }
        }
        catch (Throwable t) {
            System.err.println("\n-----");
            System.err.println(BootstrapBundle.message((String)"bootstrap.error.appendix.graphics", (Object[])new Object[0]));
            t.printStackTrace(System.err);
        }
    }

    private static void supportCenter() {
        try {
            String url = System.getProperty(SUPPORT_URL_PROPERTY, "https://jb.gg/ide/critical-startup-errors");
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Throwable t) {
            StartupErrorReporter.showBrowserError(t);
        }
    }

    private static void reportProblem(String title2, String description, @Nullable Throwable error) {
        if (error != null) {
            title2 = (String)title2 + " (" + error.getClass().getSimpleName() + ": " + StartupErrorReporter.shorten(error.getMessage()) + ")";
        }
        String uploadId = null;
        if (error instanceof ExceptionWithAttachments) {
            ExceptionWithAttachments ewa = (ExceptionWithAttachments)error;
            JScrollPane message = StartupErrorReporter.prepareMessage(BootstrapBundle.message((String)"bootstrap.error.message.confirm", (Object[])new Object[0]));
            int ok = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, BootstrapBundle.message((String)"bootstrap.error.option.report", (Object[])new Object[0]), 2, 1);
            if (ok != 0) {
                return;
            }
            try {
                uploadId = StartupErrorReporter.uploadLogs(ewa);
            }
            catch (Throwable t) {
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                message = StartupErrorReporter.prepareMessage(BootstrapBundle.message((String)"bootstrap.error.message.no.logs", (Object[])new Object[]{buf}));
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, BootstrapBundle.message((String)"bootstrap.error.title.no.logs", (Object[])new Object[0]), 0);
                return;
            }
        }
        if (uploadId != null) {
            description = (String)description + "\n\n-----\n[Upload ID: " + uploadId + "]";
        }
        try {
            String url = System.getProperty(REPORT_URL_PROPERTY, "https://youtrack.jetbrains.com/newissue?project=IJPL&clearDraft=true&summary=$TITLE$&description=$DESCR$&c=$SUBSYSTEM$").replace("$TITLE$", URLUtil.encodeURIComponent((String)title2)).replace("$DESCR$", URLUtil.encodeURIComponent((String)description)).replace("$SUBSYSTEM$", URLUtil.encodeURIComponent((String)"Subsystem: IDE. Startup"));
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Throwable t) {
            StartupErrorReporter.showBrowserError(t);
        }
    }

    private static String shorten(String message) {
        if (message.length() <= 200) {
            return message;
        }
        int p = message.indexOf(10, 200);
        if (p < 0 || p >= 250) {
            p = message.indexOf(". ", 200);
        }
        if (p < 0 || p >= 250) {
            p = message.indexOf(32, 200);
        }
        if (p < 0 || p >= 250) {
            p = 200;
        }
        return message + ((message = message.substring(0, p)).endsWith(".") ? ".." : "...");
    }

    @Nullable
    private static String uploadLogs(final ExceptionWithAttachments error) throws ExecutionException, InterruptedException {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JLabel label2 = new JLabel(BootstrapBundle.message((String)"bootstrap.error.message.logs", (Object[])new Object[0]));
        JPanel panel2 = new JPanel(new BorderLayout(5, 5));
        panel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel2.add((Component)label2, "North");
        panel2.add((Component)progressBar, "Center");
        final JDialog progressDialog = new JDialog(JOptionPane.getRootFrame(), BootstrapBundle.message((String)"bootstrap.error.title.logs", (Object[])new Object[0]), true);
        progressDialog.add(panel2);
        progressDialog.setSize(300, 100);
        progressDialog.setLocationRelativeTo(null);
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                Path logs2 = StartupErrorReporter.collectLogs(error);
                try {
                    String string = LogUploader.uploadFile(logs2);
                    return string;
                }
                finally {
                    NioFiles.deleteQuietly((Path)logs2);
                }
            }

            @Override
            protected void done() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
            }
        };
        worker.execute();
        progressDialog.setVisible(true);
        return (String)worker.get();
    }

    private static Path collectLogs(ExceptionWithAttachments error) throws IOException {
        String ts = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").format(LocalDateTime.now());
        Path logs2 = Files.createTempFile("startup-err-logs-" + ts + "-", ".zip", new FileAttribute[0]);
        try (Compressor.Zip zip = new Compressor.Zip(logs2);){
            Path productData;
            Path log = PathManager.getLogDir().resolve("idea.log");
            if (Files.exists(log, new LinkOption[0])) {
                zip.addFile(log.getFileName().toString(), log);
            }
            if (!Files.exists(productData = PathManager.getHomeDir().resolve("product-info.json"), new LinkOption[0])) {
                productData = PathManager.getHomeDir().resolve("Resources/product-info.json");
            }
            if (Files.exists(productData, new LinkOption[0])) {
                zip.addFile(productData.getFileName().toString(), productData);
            }
            for (Attachment attachment : error.getAttachments()) {
                zip.addFile(attachment.getName(), attachment.getBytes());
            }
        }
        return logs2;
    }

    private static void cleanStart() {
        try {
            Path backupPath = ConfigBackup.Companion.getNextBackupPath(PathManager.getConfigDir());
            CustomConfigMigrationOption.StartWithCleanConfig.INSTANCE.writeConfigMarkerFile();
            String message = BootstrapBundle.message((String)"bootstrap.error.message.reset", (Object[])new Object[]{backupPath});
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, BootstrapBundle.message((String)"bootstrap.error.title.reset", (Object[])new Object[0]), 1);
        }
        catch (Throwable t) {
            String message = BootstrapBundle.message((String)"bootstrap.error.message.reset.failed", (Object[])new Object[]{t});
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, BootstrapBundle.message((String)"bootstrap.error.title.reset", (Object[])new Object[0]), 0);
        }
    }

    private static void showBrowserError(Throwable t) {
        JScrollPane message = StartupErrorReporter.prepareMessage(BootstrapBundle.message((String)"bootstrap.error.message.browser", (Object[])new Object[]{t}));
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, BootstrapBundle.message((String)"bootstrap.error.title.browser", (Object[])new Object[0]), 0);
    }

    private static JScrollPane prepareMessage(String message) {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setText(message.replaceAll("\t", "    "));
        textPane.setBackground(UIManager.getColor("Panel.background"));
        textPane.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textPane, 20, 30);
        scrollPane.setBorder(null);
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        Dimension paneSize = scrollPane.getPreferredSize();
        if (paneSize.height > maxHeight || paneSize.width > maxWidth) {
            scrollPane.setPreferredSize(new Dimension(Math.min(maxWidth, paneSize.width), Math.min(maxHeight, paneSize.height)));
        }
        return scrollPane;
    }

    public static void processException(@NotNull Throwable t) {
        ImplementationConflictException conflictException;
        PluginException pluginException;
        PluginId pluginId;
        if (t == null) {
            StartupErrorReporter.$$$reportNull$$$0(2);
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred() && !(t instanceof StartupAbortedException)) {
            if (!(t instanceof ControlFlowException)) {
                PluginManagerCore.getLogger().error(t);
                ExceptionsKt.processUnhandledException(t, null);
            }
            return;
        }
        EssentialPluginMissingException essentialPluginMissingException = StartupErrorReporter.findCause(t, EssentialPluginMissingException.class);
        if (essentialPluginMissingException != null) {
            List pluginIds = essentialPluginMissingException.pluginIds;
            StartupErrorReporter.showError(BootstrapBundle.message((String)"bootstrap.error.title.corrupted", (Object[])new Object[0]), BootstrapBundle.message((String)"bootstrap.error.essential.plugins", (Object[])new Object[]{pluginIds.size(), "  " + String.join((CharSequence)"\n  ", pluginIds) + "\n\n"}));
            System.exit(12);
        }
        PluginId pluginId2 = pluginId = (pluginException = StartupErrorReporter.findCause(t, PluginException.class)) == null ? null : pluginException.getPluginId();
        if (Logger.isInitialized() && !(t instanceof ProcessCanceledException)) {
            try {
                PluginManagerCore.getLogger().error(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t instanceof StackOverflowError && "Nashorn AST Serializer".equals(Thread.currentThread().getName())) {
                return;
            }
        }
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred() && (conflictException = StartupErrorReporter.findCause(t, ImplementationConflictException.class)) != null) {
            PluginConflictReporter pluginConflictReporter = (PluginConflictReporter)ApplicationManager.getApplication().getService(PluginConflictReporter.class);
            pluginConflictReporter.reportConflict((Collection)conflictException.getConflictingPluginIds(), conflictException.isConflictWithPlatform());
        }
        if (pluginId != null && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(pluginId)) {
            PluginManagerCore.disablePlugin((PluginId)pluginId);
            StringWriter message = new StringWriter();
            message.append(BootstrapBundle.message((String)"bootstrap.error.message.plugin.failed", (Object[])new Object[]{pluginId.getIdString()}));
            message.append("\n\n");
            ((Throwable)Objects.requireNonNullElse(pluginException.getCause(), pluginException)).printStackTrace(new PrintWriter(message));
            StartupErrorReporter.showError(BootstrapBundle.message((String)"bootstrap.error.title.plugin.init", (Object[])new Object[0]), message.toString());
            System.exit(8);
        } else {
            StartupErrorReporter.showError(BootstrapBundle.message((String)"bootstrap.error.title.start.failed", (Object[])new Object[0]), t);
            System.exit(3);
        }
    }

    private static <T extends Throwable> T findCause(Throwable t, Class<T> clazz) {
        while (t != null) {
            if (clazz.isInstance(t)) {
                return (T)((Throwable)clazz.cast(t));
            }
            t = t.getCause();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/ide/bootstrap/StartupErrorReporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processException";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

