/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.menu;

import com.intellij.diagnostic.UILatencyLogger;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.ActionPresentationDecorator;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRefKt;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.ide.menu.FrameMenuUiKind;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.mac.screenmenu.Menu;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aB\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"createMacNativeActionMenu", "Lcom/intellij/ui/mac/screenmenu/Menu;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "place", "", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "presentationFactory", "Lcom/intellij/openapi/actionSystem/impl/PresentationFactory;", "isMnemonicEnabled", "", "frame", "Ljavax/swing/JFrame;", "useDarkIcons", "getDataContext", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMacNativeActionMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacNativeActionMenu.kt\ncom/intellij/platform/ide/menu/MacNativeActionMenuKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n13#2:84\n13#2:85\n*S KotlinDebug\n*F\n+ 1 MacNativeActionMenu.kt\ncom/intellij/platform/ide/menu/MacNativeActionMenuKt\n*L\n49#1:84\n52#1:85\n*E\n"})
public final class MacNativeActionMenuKt {
    @NotNull
    public static final Menu createMacNativeActionMenu(@Nullable DataContext context, @NotNull String place, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, boolean isMnemonicEnabled, @NotNull JFrame frame, boolean useDarkIcons) {
        Menu menuPeer;
        block2: {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            Intrinsics.checkNotNullParameter((Object)presentationFactory, (String)"presentationFactory");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            ActionRef<AnAction> groupRef = ActionRefKt.createActionRef((AnAction)group2);
            Presentation presentation2 = presentationFactory.getPresentation((AnAction)group2);
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            Presentation presentation3 = presentation2;
            menuPeer = new Menu(ActionPresentationDecorator.decorateTextIfNeeded((AnAction)group2, presentation3.getText(isMnemonicEnabled)));
            if (group2 instanceof Toggleable && Toggleable.isSelected((Presentation)presentation3)) {
                menuPeer.setState(true);
            }
            menuPeer.setOnOpen(frame, () -> MacNativeActionMenuKt.createMacNativeActionMenu$lambda$0(menuPeer, frame, groupRef, isMnemonicEnabled, presentationFactory, context, place));
            menuPeer.listenPresentationChanges(presentation3);
            if (ExperimentalUI.Companion.isNewUI() || !UISettings.Companion.getInstance().getShowIconsInMenus()) break block2;
            Icon icon2 = presentation3.getIcon();
            if (icon2 != null) {
                Icon icon3 = icon2;
                boolean bl = false;
                menuPeer.setIcon(IconUtilKt.getMenuBarIcon((Icon)icon3, (boolean)useDarkIcons));
            }
        }
        return menuPeer;
    }

    private static final DataContext getDataContext(JFrame frame) {
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext2 = dataManager.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext context = dataContext2;
        if (PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context) == null) {
            DataContext dataContext3 = dataManager.getDataContext(IdeFocusManager.getGlobalInstance().getLastFocusedFor((Window)frame));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
            context = dataContext3;
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createMacNativeActionMenu$lambda$0(Menu $menuPeer, JFrame $frame, ActionRef $groupRef, boolean $isMnemonicEnabled, PresentationFactory $presentationFactory, DataContext $context, String $place) {
        try {
            WriteIntentReadAction.run(() -> MacNativeActionMenuKt.createMacNativeActionMenu$lambda$0$0($frame, $menuPeer, $groupRef, $isMnemonicEnabled, $presentationFactory, $context, $place));
        }
        catch (ProcessCanceledException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(Menu.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("ProcessCanceledException is not expected", new Throwable().initCause(e));
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(Menu.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(e);
        }
        finally {
            UILatencyLogger.MAIN_MENU_LATENCY.log((Object)(System.currentTimeMillis() - $menuPeer.getOpenTimeMs()));
        }
    }

    private static final void createMacNativeActionMenu$lambda$0$0(JFrame $frame, Menu $menuPeer, ActionRef $groupRef, boolean $isMnemonicEnabled, PresentationFactory $presentationFactory, DataContext $context, String $place) {
        ActionUiKind.Popup popup2 = new FrameMenuUiKind($frame, $menuPeer);
        ActionGroup actionGroup = (ActionGroup)$groupRef.getAction();
        DataContext dataContext2 = $context;
        if (dataContext2 == null) {
            dataContext2 = MacNativeActionMenuKt.getDataContext($frame);
        }
        Utils.INSTANCE.fillMenu$intellij_platform_ide_impl(popup2, actionGroup, $isMnemonicEnabled, $presentationFactory, dataContext2, $place, null, (Function0<Boolean>)((Function0)() -> MacNativeActionMenuKt.createMacNativeActionMenu$lambda$0$0$0($menuPeer)));
    }

    private static final boolean createMacNativeActionMenu$lambda$0$0$0(Menu $menuPeer) {
        return !$menuPeer.isOpened();
    }
}

