/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.menu;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.platform.ide.menu.IdeMenuBarHelper;
import com.intellij.platform.ide.menu.IdeMenuFlavor;
import com.intellij.platform.ide.menu.MacNativeActionMenuKt;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.screenmenu.MenuBar;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J$\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/ide/menu/PeerBasedIdeMenuBarHelper;", "Lcom/intellij/platform/ide/menu/IdeMenuBarHelper;", "screenMenuPeer", "Lcom/intellij/ui/mac/screenmenu/MenuBar;", "flavor", "Lcom/intellij/platform/ide/menu/IdeMenuFlavor;", "menuBar", "Lcom/intellij/platform/ide/menu/IdeMenuBarHelper$MenuBarImpl;", "<init>", "(Lcom/intellij/ui/mac/screenmenu/MenuBar;Lcom/intellij/platform/ide/menu/IdeMenuFlavor;Lcom/intellij/platform/ide/menu/IdeMenuBarHelper$MenuBarImpl;)V", "isUpdateForbidden", "", "doUpdateVisibleActions", "", "newVisibleActions", "", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "forceRebuild", "(Ljava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
public non-sealed class PeerBasedIdeMenuBarHelper
extends IdeMenuBarHelper {
    @NotNull
    private final MenuBar screenMenuPeer;

    public PeerBasedIdeMenuBarHelper(@NotNull MenuBar screenMenuPeer, @NotNull IdeMenuFlavor flavor2, @NotNull IdeMenuBarHelper.MenuBarImpl menuBar) {
        Intrinsics.checkNotNullParameter((Object)screenMenuPeer, (String)"screenMenuPeer");
        Intrinsics.checkNotNullParameter((Object)flavor2, (String)"flavor");
        Intrinsics.checkNotNullParameter((Object)menuBar, (String)"menuBar");
        super(flavor2, menuBar, null);
        this.screenMenuPeer = screenMenuPeer;
    }

    @Override
    protected boolean isUpdateForbidden() {
        return this.screenMenuPeer.isAnyChildOpened();
    }

    @Override
    @Nullable
    protected Object doUpdateVisibleActions(@NotNull List<? extends ActionGroup> newVisibleActions, boolean forceRebuild, @NotNull Continuation<? super Unit> $completion) {
        return PeerBasedIdeMenuBarHelper.doUpdateVisibleActions$suspendImpl(this, newVisibleActions, forceRebuild, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Object doUpdateVisibleActions$suspendImpl(PeerBasedIdeMenuBarHelper $this, List<? extends ActionGroup> newVisibleActions, boolean forceRebuild, Continuation<? super Unit> $completion) {
        ThreadingAssertions.assertEventDispatchThread();
        if (!forceRebuild && Intrinsics.areEqual(newVisibleActions, (Object)$this.visibleActions) && !$this.presentationFactory.isNeedRebuild()) {
            return Unit.INSTANCE;
        }
        $this.visibleActions = newVisibleActions;
        $this.screenMenuPeer.beginFill();
        try {
            if (!newVisibleActions.isEmpty()) {
                boolean enableMnemonics = !UISettings.Companion.getInstance().getDisableMnemonics();
                for (ActionGroup actionGroup : newVisibleActions) {
                    $this.screenMenuPeer.add(MacNativeActionMenuKt.createMacNativeActionMenu(null, "MainMenu", actionGroup, $this.presentationFactory, enableMnemonics, $this.menuBar.getFrame(), NSDefaults.isDarkMenuBar()));
                }
            }
        }
        finally {
            $this.screenMenuPeer.endFill();
            $this.presentationFactory.resetNeedRebuild();
        }
        $this.flavor.updateAppMenu();
        return Unit.INSTANCE;
    }
}

