/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.toolWindow.StripeActionGroupKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/toolWindow/TogglePinActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "toolWindowId", "", "<init>", "(Ljava/lang/String;)V", "getToolWindowId", "()Ljava/lang/String;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.ide.impl"})
class TogglePinActionBase
extends DumbAwareAction {
    @NotNull
    private final String toolWindowId;

    public TogglePinActionBase(@NotNull String toolWindowId) {
        Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
        super(ActionsBundle.messagePointer((String)"action.TopStripePinButton.text", (Object[])new Object[0]));
        this.toolWindowId = toolWindowId;
        this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfPreferred);
    }

    @NotNull
    public final String getToolWindowId() {
        return this.toolWindowId;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean pinned = StripeActionGroupKt.access$getButtonState().isPinned(this.toolWindowId);
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)pinned);
        e.getPresentation().setText(pinned ? ActionsBundle.message((String)"action.TopStripeUnPinButton.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.TopStripePinButton.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StripeActionGroupKt.access$getButtonState().setPinned(this.toolWindowId, !Toggleable.isSelected((Presentation)e.getPresentation()));
        ActionToolbarImpl.Companion.updateAllToolbarsImmediately();
    }
}

