/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.toolWindow.ToolWindowDefaultLayoutManagerKt;
import com.intellij.toolWindow.ToolWindowLayoutDescriptor;
import com.intellij.toolWindow.ToolWindowLayoutStorageManagerState;
import com.intellij.ui.ExperimentalUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@State(name="ToolWindowLayout", storages={@Storage(value="window.layouts.xml"), @Storage(value="window.state.xml", deprecated=true, roamingType=RoamingType.DISABLED)}, category=SettingsCategory.UI)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0015J\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\fJ\b\u0010\u001f\u001a\u00020\u0002H\u0017J\b\u0010 \u001a\u00020!H\u0017J\b\u0010\"\u001a\u00020\u0018H\u0017J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0002H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/intellij/toolWindow/ToolWindowDefaultLayoutManager;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/toolWindow/ToolWindowLayoutStorageManagerState;", "isNewUi", "", "<init>", "(Z)V", "()V", "state", "tracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "value", "", "activeLayoutName", "getActiveLayoutName", "()Ljava/lang/String;", "setActiveLayoutName", "(Ljava/lang/String;)V", "getLayoutNames", "", "getLayoutCopy", "Lcom/intellij/openapi/wm/impl/DesktopLayout;", "getFactoryDefaultLayoutCopy", "setLayout", "", "layout", "name", "renameLayout", "oldName", "newName", "deleteLayout", "getState", "getStateModificationCount", "", "noStateLoaded", "loadDefaultLayout", "loadState", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowDefaultLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowDefaultLayoutManager.kt\ncom/intellij/toolWindow/ToolWindowDefaultLayoutManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1563#2:306\n1634#2,3:307\n*S KotlinDebug\n*F\n+ 1 ToolWindowDefaultLayoutManager.kt\ncom/intellij/toolWindow/ToolWindowDefaultLayoutManager\n*L\n66#1:306\n66#1:307,3\n*E\n"})
public final class ToolWindowDefaultLayoutManager
implements PersistentStateComponentWithModificationTracker<ToolWindowLayoutStorageManagerState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isNewUi;
    @NotNull
    private volatile ToolWindowLayoutStorageManagerState state;
    @NotNull
    private final SimpleModificationTracker tracker;
    @NotNull
    public static final String INITIAL_LAYOUT_NAME = "Custom";
    @NotNull
    public static final String FACTORY_DEFAULT_LAYOUT_NAME = "";

    public ToolWindowDefaultLayoutManager(boolean isNewUi) {
        this.isNewUi = isNewUi;
        this.state = new ToolWindowLayoutStorageManagerState(null, null, null, null, 15, null);
        this.tracker = new SimpleModificationTracker();
    }

    @NotNull
    public final String getActiveLayoutName() {
        return this.state.getActiveLayoutName();
    }

    public final void setActiveLayoutName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.tracker.incModificationCount();
        this.state = ToolWindowLayoutStorageManagerState.copy$default(this.state, value, null, null, null, 14, null);
    }

    public ToolWindowDefaultLayoutManager() {
        this(ExperimentalUI.Companion.isNewUI());
    }

    @NotNull
    public final Set<String> getLayoutNames() {
        return this.state.getLayouts().keySet();
    }

    @NotNull
    public final DesktopLayout getLayoutCopy() {
        return this.state.getActiveLayoutCopy(this.isNewUi);
    }

    @NotNull
    public final DesktopLayout getFactoryDefaultLayoutCopy() {
        return this.state.getLayoutCopy(FACTORY_DEFAULT_LAYOUT_NAME, this.isNewUi);
    }

    public final void setLayout(@NotNull DesktopLayout layout2) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        this.setLayout(this.getActiveLayoutName(), layout2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setLayout(@NotNull String name2, @NotNull DesktopLayout layout2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        this.tracker.incModificationCount();
        String layoutName = name2;
        if (Intrinsics.areEqual((Object)layoutName, (Object)FACTORY_DEFAULT_LAYOUT_NAME)) {
            layoutName = INITIAL_LAYOUT_NAME;
        }
        Iterable $this$map$iv = layout2.getSortedList$intellij_platform_ide_impl();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            WindowInfoImpl windowInfoImpl = (WindowInfoImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ToolWindowDefaultLayoutManagerKt.access$convertWindowStateToDescriptor((WindowInfoImpl)p0));
        }
        List list2 = (List)destination$iv$iv;
        Map weights = ToolWindowDefaultLayoutManagerKt.access$convertUnifiedWeightsToDescriptor(layout2.getUnifiedWeights());
        this.state = this.state.withUpdatedLayout(layoutName, list2, this.isNewUi, weights);
    }

    public final void renameLayout(@NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this.tracker.incModificationCount();
        this.state = this.state.withRenamedLayout(oldName, newName);
    }

    public final void deleteLayout(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.tracker.incModificationCount();
        this.state = this.state.withoutLayout(name2);
    }

    @ApiStatus.Internal
    @NotNull
    public ToolWindowLayoutStorageManagerState getState() {
        return this.state;
    }

    @ApiStatus.Internal
    public long getStateModificationCount() {
        return this.tracker.getModificationCount();
    }

    @ApiStatus.Internal
    public void noStateLoaded() {
        if (!this.isNewUi) {
            WindowManagerImpl windowManagerImpl;
            Object object = WindowManager.getInstance();
            WindowManagerImpl windowManagerImpl2 = windowManagerImpl = object instanceof WindowManagerImpl ? (WindowManagerImpl)((Object)object) : null;
            if (windowManagerImpl != null && (object = windowManagerImpl.getOldLayout$intellij_platform_ide_impl()) != null) {
                Object it = object;
                boolean bl = false;
                this.setLayout(INITIAL_LAYOUT_NAME, (DesktopLayout)it);
                return;
            }
        }
        this.loadDefaultLayout(this.isNewUi);
    }

    private final void loadDefaultLayout(boolean isNewUi) {
        this.state = ToolWindowLayoutStorageManagerState.withUpdatedLayout$default(this.state, INITIAL_LAYOUT_NAME, ToolWindowDefaultLayoutManagerKt.access$getDefaultLayoutToolWindowDescriptors(isNewUi), isNewUi, null, 8, null);
    }

    @ApiStatus.Internal
    public void loadState(@NotNull ToolWindowLayoutStorageManagerState state2) {
        ToolWindowLayoutStorageManagerState newState;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.state = newState = state2.getLayouts().isEmpty() && (!((Collection)state2.getV1()).isEmpty() || !((Collection)state2.getV2()).isEmpty()) ? new ToolWindowLayoutStorageManagerState(null, MapsKt.mapOf((Pair)TuplesKt.to((Object)INITIAL_LAYOUT_NAME, (Object)new ToolWindowLayoutDescriptor(state2.getV1(), state2.getV2(), null, 4, null))), null, null, 13, null) : state2.withoutLayout(FACTORY_DEFAULT_LAYOUT_NAME);
        if (!Intrinsics.areEqual((Object)newState.getActiveLayoutName(), (Object)FACTORY_DEFAULT_LAYOUT_NAME)) {
            this.setLayout(newState.getActiveLayoutName(), newState.getActiveLayoutCopy(this.isNewUi));
        }
    }

    @JvmStatic
    @NotNull
    public static final ToolWindowDefaultLayoutManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/toolWindow/ToolWindowDefaultLayoutManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/toolWindow/ToolWindowDefaultLayoutManager;", "INITIAL_LAYOUT_NAME", "", "FACTORY_DEFAULT_LAYOUT_NAME", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nToolWindowDefaultLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowDefaultLayoutManager.kt\ncom/intellij/toolWindow/ToolWindowDefaultLayoutManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,305:1\n42#2,3:306\n*S KotlinDebug\n*F\n+ 1 ToolWindowDefaultLayoutManager.kt\ncom/intellij/toolWindow/ToolWindowDefaultLayoutManager$Companion\n*L\n27#1:306,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ToolWindowDefaultLayoutManager getInstance() {
            boolean $i$f$service = false;
            Class<ToolWindowDefaultLayoutManager> serviceClass$iv = ToolWindowDefaultLayoutManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ToolWindowDefaultLayoutManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

