/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.WindowInfoKt;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.openapi.wm.impl.AbstractSquareStripeButton;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.openapi.wm.impl.SquareStripeButtonKt;
import com.intellij.openapi.wm.impl.SquareStripeButtonLook;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowTypeExtensionsKt;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.MoreSquareStripeButton;
import com.intellij.toolWindow.StripeButton;
import com.intellij.toolWindow.StripeButtonManager;
import com.intellij.toolWindow.ToolWindowDragHelperKt;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.DevicePoint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.drag.DialogDragImageView;
import com.intellij.ui.drag.DialogWithImage;
import com.intellij.ui.drag.DragImageView;
import com.intellij.ui.drag.GlassPaneDragImageView;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004tuvwB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0016H\u0014J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u0016H\u0014J \u00103\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0016H\u0014J\u0010\u00103\u001a\u00020\t2\u0006\u00106\u001a\u000207H\u0002J(\u00108\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u00162\u0006\u00109\u001a\u00020\tH\u0014J \u0010:\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0016H\u0014J\u0018\u0010;\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00105\u001a\u00020\u0016H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020,2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\tH\u0002J\u0010\u0010F\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010G\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010H\u001a\u00020,2\u0006\u0010I\u001a\u00020\tH\u0002J\u0010\u0010J\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010K\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010L\u001a\u00020\tH\u0014J\b\u0010M\u001a\u00020,H\u0014J\b\u0010N\u001a\u00020,H\u0014J\u0012\u0010O\u001a\u00020,2\b\u0010P\u001a\u0004\u0018\u00010.H\u0016J\b\u0010Q\u001a\u00020,H\u0016J\b\u0010R\u001a\u00020,H\u0002J\b\u0010S\u001a\u00020,H\u0002J\u0010\u0010T\u001a\u00020,2\u0006\u0010U\u001a\u00020\u0002H\u0002J\u0010\u0010V\u001a\u00020,2\u0006\u0010U\u001a\u00020\u0002H\u0002J\n\u0010W\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010X\u001a\u0004\u0018\u00010B2\u0006\u0010Y\u001a\u00020@H\u0002J\u0012\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0012\u0010\\\u001a\u0004\u0018\u00010\u000e2\u0006\u0010Y\u001a\u00020@H\u0002J\b\u0010]\u001a\u00020\tH\u0002J\u0010\u0010^\u001a\u00020_2\u0006\u0010U\u001a\u00020\u0002H\u0002J(\u0010`\u001a\u00020_2\u0006\u0010U\u001a\u00020\u00022\u0006\u0010a\u001a\u00020\u00102\u0006\u0010b\u001a\u0002002\u0006\u0010c\u001a\u000200H\u0002J\u0012\u0010d\u001a\u0004\u0018\u00010_2\u0006\u0010D\u001a\u00020\u000eH\u0002J\u0010\u0010e\u001a\u00020\u00182\u0006\u0010D\u001a\u00020\u000eH\u0002J\u0018\u0010f\u001a\u00020_2\u0006\u0010g\u001a\u00020\u00022\u0006\u0010a\u001a\u00020\u0010H\u0002J\u0010\u0010h\u001a\u00020\t2\u0006\u00106\u001a\u000207H\u0002J\u0018\u0010i\u001a\u0002002\u0006\u0010U\u001a\u00020\u00022\u0006\u0010a\u001a\u00020\u0010H\u0002J\u0018\u0010j\u001a\u0002002\u0006\u0010U\u001a\u00020\u00022\u0006\u0010a\u001a\u00020\u0010H\u0002J\u0014\u0010k\u001a\u0004\u0018\u00010)2\b\u0010l\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010m\u001a\u00020\u001a2\u0006\u0010a\u001a\u00020\u00102\u0006\u0010n\u001a\u00020\tH\u0002J\u001a\u0010o\u001a\u0004\u0018\u00010\u001a2\u0006\u00106\u001a\u0002072\u0006\u0010p\u001a\u00020\u001aH\u0002J\u0012\u0010q\u001a\u0004\u0018\u00010r2\u0006\u0010s\u001a\u00020BH\u0002R\u0010\u0010\u0005\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/intellij/toolWindow/ToolWindowDragHelper;", "Lcom/intellij/ui/MouseDragHelper;", "Lcom/intellij/toolWindow/ToolWindowPane;", "parent", "Lcom/intellij/openapi/Disposable;", "dragSourcePane", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/toolWindow/ToolWindowPane;)V", "isNewUi", "", "dropTargetHighlightComponent", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "toolWindowRef", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "initialAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "initialIsSplit", "Ljava/lang/Boolean;", "initialStripeButton", "Lcom/intellij/toolWindow/StripeButtonManager;", "initialOffset", "Ljava/awt/Point;", "floatingWindowSize", "Ljava/awt/Dimension;", "lastStripe", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "lastDropTargetPaneId", "", "lastDropTargetPane", "dragSession", "Lcom/intellij/toolWindow/ToolWindowDragHelper$DragSession;", "dragMoreButton", "Lcom/intellij/toolWindow/MoreSquareStripeButton;", "dragMoreButtonNewSide", "lastDropTooltipAnchor", "Lcom/intellij/ide/actions/ToolWindowMoveAction$Anchor;", "dropTooltipPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "canStartDragging", "dragComponent", "Ljavax/swing/JComponent;", "dragComponentPoint", "processMousePressed", "", "event", "Ljava/awt/event/MouseEvent;", "getDragStartDeadzone", "", "pressedScreenPoint", "draggedScreenPoint", "isDragOut", "dragToScreenPoint", "startScreenPoint", "devicePoint", "Lcom/intellij/ui/awt/DevicePoint;", "processDragOut", "dragOutJustStarted", "processDrag", "startDrag", "createDragImageView", "Lcom/intellij/ui/drag/DragImageView;", "setInitialOffsetFromStripeButton", "relativePoint", "Lcom/intellij/ui/awt/RelativePoint;", "clickedComponent", "Ljava/awt/Component;", "overlayStripesIfHidden", "toolWindow", "show", "relocateImageView", "relocate", "setDragOut", "dragOut", "processDragOutFinish", "processDragFinish", "willDragOutStart", "processDragOutCancel", "processDragCancel", "mouseReleased", "e", "stop", "stopDrag", "clearDropTooltip", "addDropTargetHighlighter", "pane", "removeDropTargetHighlighter", "getToolWindow", "getComponentFromDragSourcePane", "point", "getTopmostLayeredPane", "Ljavax/swing/JLayeredPane;", "getToolWindowAtPoint", "isHeaderDraggingEnabled", "getPaneContentScreenBounds", "Ljava/awt/Rectangle;", "getAdjustedPaneContentsScreenBounds", "anchor", "adjustedHorizontalHeight", "adjustedVerticalWidth", "getToolWindowScreenBoundsIfVisibleAndDocked", "getDefaultFloatingToolWindowSize", "getDropTargetScreenBounds", "dropTargetPane", "isPointInVisibleDockedToolWindow", "getStripeWidth", "getStripeHeight", "getStripeButtonForToolWindow", "window", "getSourceStripe", "isSplit", "getTargetStripeByDropLocation", "preferredStripe", "createStripeButtonDragImage", "Ljava/awt/image/BufferedImage;", "component", "Companion", "DragSession", "DragImageDialog", "ToolWindowProvider", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowDragHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowDragHelper.kt\ncom/intellij/toolWindow/ToolWindowDragHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,819:1\n1#2:820\n1869#3,2:821\n*S KotlinDebug\n*F\n+ 1 ToolWindowDragHelper.kt\ncom/intellij/toolWindow/ToolWindowDragHelper\n*L\n682#1:821,2\n*E\n"})
public final class ToolWindowDragHelper
extends MouseDragHelper<ToolWindowPane> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ToolWindowPane dragSourcePane;
    private final boolean isNewUi;
    @NotNull
    private final NonOpaquePanel dropTargetHighlightComponent;
    @Nullable
    private WeakReference<ToolWindowImpl> toolWindowRef;
    @Nullable
    private ToolWindowAnchor initialAnchor;
    @Nullable
    private Boolean initialIsSplit;
    @Nullable
    private StripeButtonManager initialStripeButton;
    @NotNull
    private final Point initialOffset;
    @NotNull
    private final Dimension floatingWindowSize;
    @Nullable
    private AbstractDroppableStripe lastStripe;
    @Nullable
    private String lastDropTargetPaneId;
    @Nullable
    private ToolWindowPane lastDropTargetPane;
    @Nullable
    private DragSession dragSession;
    @Nullable
    private MoreSquareStripeButton dragMoreButton;
    @Nullable
    private ToolWindowAnchor dragMoreButtonNewSide;
    @Nullable
    private ToolWindowMoveAction.Anchor lastDropTooltipAnchor;
    @Nullable
    private JBPopup dropTooltipPopup;
    public static final float THUMB_OPACITY = 0.85f;

    public ToolWindowDragHelper(@NotNull Disposable parent, @NotNull ToolWindowPane dragSourcePane) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)dragSourcePane, (String)"dragSourcePane");
        super(parent, (JComponent)dragSourcePane);
        this.dragSourcePane = dragSourcePane;
        this.isNewUi = this.dragSourcePane.buttonManager.isNewUi();
        this.dropTargetHighlightComponent = Companion.createDropTargetHighlightComponent$intellij_platform_ide_impl();
        this.initialOffset = new Point();
        this.floatingWindowSize = new Dimension();
    }

    protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
        Intrinsics.checkNotNullParameter((Object)dragComponent, (String)"dragComponent");
        Intrinsics.checkNotNullParameter((Object)dragComponentPoint, (String)"dragComponentPoint");
        RelativePoint point = new RelativePoint((Component)dragComponent, dragComponentPoint);
        return this.getToolWindowAtPoint(point) != null || this.getComponentFromDragSourcePane(point) instanceof MoreSquareStripeButton;
    }

    protected void processMousePressed(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ToolWindowImpl toolWindowImpl = this.getToolWindowAtPoint(new RelativePoint(event));
        if (toolWindowImpl == null) {
            return;
        }
        ToolWindowImpl toolWindow2 = toolWindowImpl;
        this.toolWindowRef = new WeakReference<ToolWindowImpl>(toolWindow2);
    }

    protected int getDragStartDeadzone(@NotNull Point pressedScreenPoint, @NotNull Point draggedScreenPoint) {
        Point point;
        Intrinsics.checkNotNullParameter((Object)pressedScreenPoint, (String)"pressedScreenPoint");
        Intrinsics.checkNotNullParameter((Object)draggedScreenPoint, (String)"draggedScreenPoint");
        Point it = point = pressedScreenPoint.getLocation();
        boolean bl = false;
        SwingUtilities.convertPointFromScreen(it, this.dragSourcePane);
        Point point2 = point;
        Component component2 = this.getComponentFromDragSourcePane(new RelativePoint((Component)this.dragSourcePane, point2));
        if (component2 instanceof StripeButton || component2 instanceof AbstractSquareStripeButton) {
            return super.getDragStartDeadzone(pressedScreenPoint, draggedScreenPoint);
        }
        return JBUI.scale((int)Registry.Companion.intValue("ide.new.tool.window.start.drag.deadzone", 7, 0, 100));
    }

    protected boolean isDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        if (this.getToolWindow() == null) {
            Point dragComponentPoint = new Point(startScreenPoint);
            SwingUtilities.convertPointFromScreen(dragComponentPoint, this.myDragComponent);
            Component clickedComponent = this.getComponentFromDragSourcePane(new RelativePoint((Component)this.myDragComponent, dragComponentPoint));
            if (clickedComponent instanceof MoreSquareStripeButton) {
                return false;
            }
        }
        return this.isDragOut(new DevicePoint(event));
    }

    private final boolean isDragOut(DevicePoint devicePoint) {
        if (this.isPointInVisibleDockedToolWindow(devicePoint)) {
            return false;
        }
        return this.lastStripe == null;
    }

    protected void processDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint, boolean dragOutJustStarted) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        if (this.getToolWindow() == null || !MouseDragHelper.checkModifiers((InputEvent)event)) {
            return;
        }
        if (this.isDragJustStarted()) {
            this.startDrag(event, startScreenPoint);
        }
        if (dragOutJustStarted) {
            this.setDragOut(true);
        }
        this.relocate(event);
        event.consume();
    }

    protected void processDrag(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        if (!MouseDragHelper.checkModifiers((InputEvent)event)) {
            return;
        }
        if (this.isDragJustStarted()) {
            this.startDrag(event, startScreenPoint);
        } else {
            this.relocate(event);
        }
    }

    private final void startDrag(MouseEvent event, Point startScreenPoint) {
        Component dragImage;
        BufferedImage dragOutImage;
        Component clickedComponent;
        RelativePoint relativePoint;
        block14: {
            Object object;
            block13: {
                Point point;
                Point it = point = new Point(startScreenPoint);
                boolean bl = false;
                SwingUtilities.convertPointFromScreen(it, event.getComponent());
                Point startPoint = point;
                relativePoint = new RelativePoint(event.getComponent(), startPoint);
                ToolWindowImpl toolWindow2 = this.getToolWindow();
                clickedComponent = this.getComponentFromDragSourcePane(relativePoint);
                if (toolWindow2 == null) {
                    if (clickedComponent instanceof MoreSquareStripeButton) {
                        this.dragMoreButton = (MoreSquareStripeButton)clickedComponent;
                        BufferedImage dragImage2 = this.createStripeButtonDragImage(clickedComponent);
                        if (dragImage2 != null) {
                            DragSession dragSession = this.dragSession = new DragSession(this.createDragImageView(event), dragImage2, null);
                            Intrinsics.checkNotNull((Object)dragSession);
                            dragSession.start();
                        }
                        this.setInitialOffsetFromStripeButton(relativePoint, clickedComponent);
                        this.relocate(event);
                        this.addDropTargetHighlighter(this.dragSourcePane);
                        this.dropTargetHighlightComponent.setVisible(true);
                        ((MoreSquareStripeButton)clickedComponent).setDragState(true);
                    }
                    return;
                }
                this.overlayStripesIfHidden(toolWindow2, true);
                InternalDecoratorImpl decorator = toolWindow2.isVisible() ? toolWindow2.getDecorator$intellij_platform_ide_impl() : null;
                this.initialAnchor = toolWindow2.getAnchor();
                this.initialIsSplit = toolWindow2.isSplitMode();
                AbstractDroppableStripe it2 = this.getSourceStripe(toolWindow2.getAnchor(), toolWindow2.isSplitMode());
                boolean bl2 = false;
                this.lastStripe = it2;
                this.initialStripeButton = it2.isShowing() || !it2.isNewStripes() ? it2.getButtonFor(toolWindow2.getId()) : null;
                Cloneable cloneable = toolWindow2.getWindowInfo().getFloatingBounds();
                if (cloneable == null || (cloneable = cloneable.getSize()) == null) {
                    cloneable = this.getDefaultFloatingToolWindowSize(toolWindow2);
                }
                this.floatingWindowSize.setSize((Dimension)cloneable);
                Object object2 = this.initialStripeButton;
                Component dragImageComponent = object2 != null && (object2 = object2.getComponent()) != null ? (Component)object2 : clickedComponent;
                dragOutImage = decorator != null && !decorator.getBounds().isEmpty() ? com.intellij.toolWindow.ToolWindowDragHelper$Companion.createThumbnailDragImage$intellij_platform_ide_impl$default(Companion, (JComponent)((Object)decorator), 0, 2, null) : null;
                object = dragImageComponent;
                if (object == null) break block13;
                Component p0 = object;
                boolean bl3 = false;
                BufferedImage bufferedImage = this.createStripeButtonDragImage(p0);
                object = bufferedImage;
                if (bufferedImage != null) break block14;
            }
            object = dragImage = dragOutImage;
        }
        if (clickedComponent instanceof StripeButton || clickedComponent instanceof SquareStripeButton) {
            this.setInitialOffsetFromStripeButton(relativePoint, clickedComponent);
        } else if (dragImage != null) {
            this.initialOffset.setLocation(new Point(((BufferedImage)((Object)dragImage)).getWidth(this.dragSourcePane) / 4, ((BufferedImage)((Object)dragImage)).getHeight(this.dragSourcePane) / 4));
        }
        if (dragImage != null) {
            this.dragSession = new DragSession(this.createDragImageView(event), (BufferedImage)((Object)dragImage), dragOutImage);
        }
        this.relocate(event);
        Object object = this.initialStripeButton;
        if (object != null && (object = object.getComponent()) != null) {
            ((JComponent)object).setVisible(false);
        }
        DragSession dragSession = this.dragSession;
        if (dragSession != null) {
            dragSession.start();
        }
        this.addDropTargetHighlighter(this.dragSourcePane);
        this.dragSourcePane.buttonManager.startDrag();
    }

    private final DragImageView createDragImageView(MouseEvent event) {
        DragImageView dragImageView;
        if (StartupUiUtil.isWaylandToolkit()) {
            IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)event.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)ideGlassPane, (String)"find(...)");
            dragImageView = new GlassPaneDragImageView(ideGlassPane);
        } else {
            dragImageView = new DialogDragImageView(new DragImageDialog(this.dragSourcePane, this));
        }
        return dragImageView;
    }

    private final void setInitialOffsetFromStripeButton(RelativePoint relativePoint, Component clickedComponent) {
        Point point;
        Point point2 = point = relativePoint.getPoint(clickedComponent);
        Point point3 = this.initialOffset;
        boolean bl = false;
        if (clickedComponent instanceof AbstractSquareStripeButton) {
            it.x -= ((AbstractSquareStripeButton)clickedComponent).getInsets().left + SquareStripeButtonLook.Companion.getIconPadding((boolean)SquareStripeButtonKt.isOnTheLeftStripe((Component)clickedComponent)).left;
            it.y -= ((AbstractSquareStripeButton)clickedComponent).getInsets().top + SquareStripeButtonLook.Companion.getIconPadding((boolean)SquareStripeButtonKt.isOnTheLeftStripe((Component)clickedComponent)).top;
        }
        point3.setLocation(point);
    }

    private final void overlayStripesIfHidden(ToolWindowImpl toolWindow2, boolean show2) {
        if (UISettings.Companion.getInstance().getHideToolStripes()) {
            for (ToolWindowPane pane2 : toolWindow2.toolWindowManager.getToolWindowPanes$intellij_platform_ide_impl()) {
                pane2.setStripesOverlaid$intellij_platform_ide_impl(show2);
            }
        }
    }

    private final void relocateImageView(MouseEvent event) {
        Point point;
        Object object = this.dragSession;
        if (object == null || (object = ((DragSession)object).getView()) == null) {
            return;
        }
        Object view2 = object;
        DevicePoint eventDevicePoint = new DevicePoint(event);
        Point it = point = eventDevicePoint.getLocationOnScreen();
        boolean bl = false;
        it.translate(-this.initialOffset.x, -this.initialOffset.y);
        Point dialogScreenLocation = point;
        view2.setLocation(dialogScreenLocation);
    }

    private final void relocate(MouseEvent event) {
        if (this.dragMoreButton != null) {
            Point point = new Point();
            Window window = ComponentUtil.getWindow((Component)this.myDragComponent);
            Intrinsics.checkNotNull((Object)window);
            Rectangle bounds = new Rectangle(point, window.getSize());
            if (event.getX() > bounds.width / 2) {
                bounds.x = 1 + 2 * bounds.width / 3;
                this.dragMoreButtonNewSide = ToolWindowAnchor.RIGHT;
            } else {
                this.dragMoreButtonNewSide = ToolWindowAnchor.LEFT;
            }
            bounds.width /= 3;
            this.dropTargetHighlightComponent.setBounds(bounds);
            this.relocateImageView(event);
            return;
        }
        DevicePoint eventDevicePoint = new DevicePoint(event);
        Object object = this.dragSession;
        if (object == null || (object = ((DragSession)object).getView()) == null) {
            return;
        }
        Object view2 = object;
        ToolWindowImpl toolWindowImpl = this.getToolWindow();
        if (toolWindowImpl == null) {
            return;
        }
        ToolWindowImpl toolWindow2 = toolWindowImpl;
        this.relocateImageView(event);
        AbstractDroppableStripe preferredStripe = this.getSourceStripe(toolWindow2.getAnchor(), toolWindow2.isSplitMode());
        AbstractDroppableStripe abstractDroppableStripe = this.getTargetStripeByDropLocation(eventDevicePoint, preferredStripe);
        if (abstractDroppableStripe == null) {
            abstractDroppableStripe = this.isPointInVisibleDockedToolWindow(eventDevicePoint) ? preferredStripe : null;
        }
        AbstractDroppableStripe targetStripe = abstractDroppableStripe;
        AbstractDroppableStripe abstractDroppableStripe2 = this.lastStripe;
        if (abstractDroppableStripe2 != null) {
            AbstractDroppableStripe it = abstractDroppableStripe2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Object)it), (Object)((Object)targetStripe))) {
                this.removeDropTargetHighlighter(toolWindow2.toolWindowManager.getToolWindowPane(it.getPaneId()));
                it.resetDrop();
            }
        }
        if (this.isNewUi) {
            if (this.lastStripe == null) {
                this.clearDropTooltip();
            } else {
                AbstractDroppableStripe abstractDroppableStripe3 = this.lastStripe;
                Intrinsics.checkNotNull((Object)((Object)abstractDroppableStripe3));
                ToolWindowAnchor toolWindowAnchor = abstractDroppableStripe3.getAnchor();
                AbstractDroppableStripe abstractDroppableStripe4 = this.lastStripe;
                Intrinsics.checkNotNull((Object)((Object)abstractDroppableStripe4));
                ToolWindowMoveAction.Anchor anchor = ToolWindowMoveAction.Anchor.getAnchor(toolWindowAnchor, Intrinsics.areEqual((Object)abstractDroppableStripe4.getDropToSide(), (Object)true));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)anchor), (String)"getAnchor(...)");
                ToolWindowMoveAction.Anchor anchor2 = anchor;
                if (anchor2 != this.lastDropTooltipAnchor) {
                    this.clearDropTooltip();
                    this.lastDropTooltipAnchor = anchor2;
                    HelpTooltip tooltip = new HelpTooltip();
                    tooltip.setTitle(UIBundle.message((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]) + " " + anchor2);
                    this.dropTooltipPopup = HelpTooltip.initPopupBuilder((JComponent)tooltip.createTipPanel()).createPopup();
                }
                Rectangle bounds = view2.getBounds();
                JBPopup jBPopup = this.dropTooltipPopup;
                Intrinsics.checkNotNull((Object)jBPopup);
                Dimension size2 = jBPopup.getContent().getPreferredSize();
                Point location = new Point(0, bounds.y + (bounds.height - size2.height) / 2);
                String string = anchor2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                location.x = StringsKt.contains$default((CharSequence)string2, (CharSequence)"left", (boolean)false, (int)2, null) ? bounds.x + bounds.width + JBUI.scale((int)10) : bounds.x - JBUI.scale((int)10) - size2.width;
                JBPopup jBPopup2 = this.dropTooltipPopup;
                Intrinsics.checkNotNull((Object)jBPopup2);
                if (jBPopup2.isVisible()) {
                    JBPopup jBPopup3 = this.dropTooltipPopup;
                    Intrinsics.checkNotNull((Object)jBPopup3);
                    jBPopup3.setLocation(location);
                } else {
                    JBPopup jBPopup4 = this.dropTooltipPopup;
                    Intrinsics.checkNotNull((Object)jBPopup4);
                    jBPopup4.show(new RelativePoint(location));
                }
            }
        }
        this.lastStripe = targetStripe;
        this.setDragOut(this.isDragOut(eventDevicePoint));
        StripeButtonManager initialStripeButton = this.initialStripeButton;
        if (targetStripe != null && initialStripeButton != null) {
            this.addDropTargetHighlighter(toolWindow2.toolWindowManager.getToolWindowPane(targetStripe.getPaneId()));
            targetStripe.processDropButton(initialStripeButton, view2.asDragButton(), eventDevicePoint);
            if (!Intrinsics.areEqual((Object)this.lastDropTargetPaneId, (Object)targetStripe.getPaneId())) {
                this.lastDropTargetPaneId = targetStripe.getPaneId();
                this.lastDropTargetPane = toolWindow2.toolWindowManager.getToolWindowPane(targetStripe.getPaneId());
            }
            SwingUtilities.invokeLater(() -> ToolWindowDragHelper.relocate$lambda$1(this, targetStripe, toolWindow2, eventDevicePoint, preferredStripe, event));
        }
    }

    private final void setDragOut(boolean dragOut) {
        DragSession dragSession = this.dragSession;
        if (dragSession != null) {
            dragSession.setDragOut(dragOut);
        }
        this.dropTargetHighlightComponent.setVisible(!dragOut);
    }

    protected void processDragOutFinish(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processDragFinish(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!MouseDragHelper.checkModifiers((InputEvent)event)) {
            this.stopDrag();
            return;
        }
        if (this.dragMoreButton != null) {
            MoreSquareStripeButton moreSquareStripeButton = this.dragMoreButton;
            Intrinsics.checkNotNull((Object)moreSquareStripeButton);
            if (moreSquareStripeButton.getSide() != this.dragMoreButtonNewSide) {
                JFrame jFrame = this.dragSourcePane.getFrame$intellij_platform_ide_impl();
                Intrinsics.checkNotNull((Object)jFrame, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.IdeFrame");
                Project project2 = ((IdeFrame)jFrame).getProject();
                Intrinsics.checkNotNull((Object)project2);
                ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.Companion.getInstanceEx(project2);
                ToolWindowAnchor toolWindowAnchor = this.dragMoreButtonNewSide;
                Intrinsics.checkNotNull((Object)toolWindowAnchor);
                toolWindowManagerEx.setMoreButtonSide(toolWindowAnchor);
            }
            this.stopDrag();
            return;
        }
        ToolWindowImpl toolWindowImpl = this.getToolWindow();
        if (toolWindowImpl == null) {
            return;
        }
        ToolWindowImpl toolWindow2 = toolWindowImpl;
        if (willDragOutStart) {
            return;
        }
        try {
            DevicePoint devicePoint = new DevicePoint(event);
            ToolWindowAnchor toolWindowAnchor = this.initialAnchor;
            Intrinsics.checkNotNull((Object)toolWindowAnchor);
            Boolean bl = this.initialIsSplit;
            Intrinsics.checkNotNull((Object)bl);
            AbstractDroppableStripe preferredStripe = this.getSourceStripe(toolWindowAnchor, bl);
            if (this.getTargetStripeByDropLocation(devicePoint, preferredStripe) == null && this.isPointInVisibleDockedToolWindow(devicePoint)) {
                return;
            }
            AbstractDroppableStripe stripe = this.lastStripe;
            if (stripe != null) {
                stripe.finishDrop(toolWindow2.toolWindowManager);
            } else {
                void it;
                WindowInfoImpl windowInfoImpl;
                WindowInfoImpl windowInfoImpl2 = windowInfoImpl = toolWindow2.toolWindowManager.getRegisteredMutableInfoOrLogError$intellij_platform_ide_impl(toolWindow2.getId());
                ToolWindowImpl toolWindowImpl2 = toolWindow2;
                boolean bl2 = false;
                Rectangle bounds = new Rectangle(devicePoint.getLocationOnScreen(), this.floatingWindowSize);
                bounds.translate(-this.initialOffset.x, -this.initialOffset.y);
                ScreenUtil.fitToScreen((Rectangle)bounds);
                it.setFloatingBounds(bounds);
                toolWindowImpl2.applyWindowInfo$intellij_platform_ide_impl(windowInfoImpl);
                toolWindow2.toolWindowManager.setToolWindowType(toolWindow2.getId(), ToolWindowType.FLOATING);
                toolWindow2.toolWindowManager.activateToolWindow(toolWindow2.getId(), null, true, null);
                if (this.isNewUi) {
                    WindowInfoImpl info = toolWindow2.toolWindowManager.getLayout().getInfo(toolWindow2.getId());
                    ToolWindowManagerImpl toolWindowManagerImpl = toolWindow2.toolWindowManager;
                    String string = toolWindow2.getId();
                    Object object = info;
                    if (object == null || (object = WindowInfoKt.getSafeToolWindowPaneId((WindowInfo)((WindowInfo)object))) == null) {
                        object = "root";
                    }
                    WindowInfoImpl windowInfoImpl3 = info;
                    WindowInfoImpl windowInfoImpl4 = info;
                    toolWindowManagerImpl.setSideToolAndAnchor$intellij_platform_ide_impl(string, (String)object, preferredStripe.getAnchor(), windowInfoImpl3 != null ? windowInfoImpl3.getOrder() : -1, windowInfoImpl4 != null ? windowInfoImpl4.isSplit() : preferredStripe.getSplit());
                }
            }
        }
        finally {
            this.stopDrag();
        }
    }

    protected void processDragOutCancel() {
        this.stopDrag();
    }

    protected void processDragCancel() {
        this.stopDrag();
    }

    public void mouseReleased(@Nullable MouseEvent e) {
        super.mouseReleased(e);
        this.toolWindowRef = null;
    }

    public void stop() {
        super.stop();
        this.stopDrag();
    }

    private final void stopDrag() {
        ToolWindowImpl window;
        ToolWindowImpl toolWindowImpl = window = this.getToolWindow();
        if (toolWindowImpl != null) {
            ToolWindowImpl it = toolWindowImpl;
            boolean bl = false;
            this.overlayStripesIfHidden(it, false);
        }
        JComponent jComponent = this.getStripeButtonForToolWindow(window);
        if (jComponent != null) {
            jComponent.setVisible(true);
        }
        this.dragSourcePane.buttonManager.stopDrag();
        ToolWindowPane toolWindowPane2 = this.lastDropTargetPane;
        if (toolWindowPane2 != null) {
            ToolWindowPane it = toolWindowPane2;
            boolean bl = false;
            this.removeDropTargetHighlighter(it);
        }
        this.dropTargetHighlightComponent.setBounds(new Rectangle(0, 0, 0, 0));
        DragSession dragSession = this.dragSession;
        if (dragSession != null) {
            dragSession.stop();
        }
        this.dragSession = null;
        this.toolWindowRef = null;
        this.initialAnchor = null;
        this.initialIsSplit = null;
        AbstractDroppableStripe abstractDroppableStripe = this.lastStripe;
        if (abstractDroppableStripe != null) {
            abstractDroppableStripe.resetDrop();
        }
        this.lastStripe = null;
        this.lastDropTargetPaneId = null;
        this.lastDropTargetPane = null;
        this.initialStripeButton = null;
        MoreSquareStripeButton moreSquareStripeButton = this.dragMoreButton;
        if (moreSquareStripeButton != null) {
            moreSquareStripeButton.setDragState(false);
        }
        this.dragMoreButton = null;
        this.dragMoreButtonNewSide = null;
        this.clearDropTooltip();
    }

    private final void clearDropTooltip() {
        JBPopup popup2 = this.dropTooltipPopup;
        this.dropTooltipPopup = null;
        this.lastDropTooltipAnchor = null;
        if (popup2 != null && popup2.isVisible()) {
            popup2.cancel();
        }
    }

    private final void addDropTargetHighlighter(ToolWindowPane pane2) {
        Component component2 = pane2.getRootPane().getGlassPane();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent $this$addDropTargetHighlighter_u24lambda_u240 = (JComponent)component2;
        boolean bl = false;
        if (!$this$addDropTargetHighlighter_u24lambda_u240.isAncestorOf((Component)this.dropTargetHighlightComponent)) {
            $this$addDropTargetHighlighter_u24lambda_u240.add((Component)this.dropTargetHighlightComponent);
            $this$addDropTargetHighlighter_u24lambda_u240.revalidate();
            $this$addDropTargetHighlighter_u24lambda_u240.repaint();
        }
    }

    private final void removeDropTargetHighlighter(ToolWindowPane pane2) {
        Component component2 = pane2.getRootPane().getGlassPane();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent $this$removeDropTargetHighlighter_u24lambda_u240 = (JComponent)component2;
        boolean bl = false;
        if ($this$removeDropTargetHighlighter_u24lambda_u240.isAncestorOf((Component)this.dropTargetHighlightComponent)) {
            $this$removeDropTargetHighlighter_u24lambda_u240.remove((Component)this.dropTargetHighlightComponent);
            $this$removeDropTargetHighlighter_u24lambda_u240.revalidate();
            $this$removeDropTargetHighlighter_u24lambda_u240.repaint();
        }
    }

    private final ToolWindowImpl getToolWindow() {
        WeakReference<ToolWindowImpl> weakReference = this.toolWindowRef;
        return weakReference != null ? (ToolWindowImpl)weakReference.get() : null;
    }

    private final Component getComponentFromDragSourcePane(RelativePoint point) {
        JLayeredPane jLayeredPane = this.getTopmostLayeredPane(this.dragSourcePane);
        if (jLayeredPane == null) {
            return null;
        }
        JLayeredPane layeredPane2 = jLayeredPane;
        Point point2 = point.getPoint((Component)layeredPane2);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getPoint(...)");
        Point pointOnWindow = point2;
        return SwingUtilities.getDeepestComponentAt(layeredPane2, pointOnWindow.x, pointOnWindow.y);
    }

    private final JLayeredPane getTopmostLayeredPane(ToolWindowPane dragSourcePane) {
        JLayeredPane result2 = null;
        for (Component component2 = (Component)dragSourcePane; component2 != null; component2 = (Component)component2.getParent()) {
            if (!(component2 instanceof JLayeredPane)) continue;
            result2 = (JLayeredPane)component2;
        }
        return result2;
    }

    private final ToolWindowImpl getToolWindowAtPoint(RelativePoint point) {
        InternalDecoratorImpl decorator;
        Component clickedComponent = this.getComponentFromDragSourcePane(point);
        if (clickedComponent != null && MouseDragHelper.isComponentDraggable((Component)clickedComponent) && (decorator = InternalDecoratorImpl.Companion.findNearestDecorator(clickedComponent)) != null && this.isHeaderDraggingEnabled() && (!Intrinsics.areEqual((Object)decorator.toolWindow.getAnchor(), (Object)ToolWindowAnchor.BOTTOM) || decorator.getLocationOnScreen().y < point.getScreenPoint().y - ToolWindowPane.Companion.getHeaderResizeArea())) {
            return decorator.toolWindow;
        }
        Component component2 = clickedComponent;
        return component2 instanceof StripeButton ? ((StripeButton)clickedComponent).toolWindow : (component2 instanceof SquareStripeButton ? ((SquareStripeButton)clickedComponent).getToolWindow() : (component2 instanceof ToolWindowProvider ? ((ToolWindowProvider)((Object)clickedComponent)).getToolWindow() : null));
    }

    private final boolean isHeaderDraggingEnabled() {
        return AdvancedSettings.Companion.getBoolean("ide.tool.window.header.dnd");
    }

    private final Rectangle getPaneContentScreenBounds(ToolWindowPane pane2) {
        Point location = pane2.getLocationOnScreen();
        if (this.isNewUi) {
            return new Rectangle(location.x, location.y, pane2.getWidth(), pane2.getHeight());
        }
        int n = location.x;
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"LEFT");
        location.x = n + this.getStripeWidth(pane2, toolWindowAnchor);
        int n2 = location.y;
        ToolWindowAnchor toolWindowAnchor2 = ToolWindowAnchor.TOP;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor2, (String)"TOP");
        location.y = n2 + this.getStripeHeight(pane2, toolWindowAnchor2);
        int n3 = pane2.getWidth();
        ToolWindowAnchor toolWindowAnchor3 = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor3, (String)"LEFT");
        int n4 = n3 - this.getStripeWidth(pane2, toolWindowAnchor3);
        ToolWindowAnchor toolWindowAnchor4 = ToolWindowAnchor.RIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor4, (String)"RIGHT");
        int width = n4 - this.getStripeWidth(pane2, toolWindowAnchor4);
        int n5 = pane2.getHeight();
        ToolWindowAnchor toolWindowAnchor5 = ToolWindowAnchor.TOP;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor5, (String)"TOP");
        int n6 = n5 - this.getStripeHeight(pane2, toolWindowAnchor5);
        ToolWindowAnchor toolWindowAnchor6 = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor6, (String)"BOTTOM");
        int height = n6 - this.getStripeHeight(pane2, toolWindowAnchor6);
        return new Rectangle(location.x, location.y, width, height);
    }

    private final Rectangle getAdjustedPaneContentsScreenBounds(ToolWindowPane pane2, ToolWindowAnchor anchor, int adjustedHorizontalHeight, int adjustedVerticalWidth) {
        Rectangle rectangle;
        Rectangle it = rectangle = this.getPaneContentScreenBounds(pane2);
        boolean bl = false;
        int paneHeight = it.height;
        int paneWidth = it.width;
        if (anchor.isHorizontal()) {
            it.height = adjustedHorizontalHeight;
        } else {
            it.width = adjustedVerticalWidth;
        }
        ToolWindowAnchor toolWindowAnchor = anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) {
            it.y = it.y + paneHeight - it.height;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            it.x = it.x + paneWidth - it.width;
        }
        return rectangle;
    }

    private final Rectangle getToolWindowScreenBoundsIfVisibleAndDocked(ToolWindowImpl toolWindow2) {
        if (!toolWindow2.isVisible() || !ToolWindowTypeExtensionsKt.isInternal(toolWindow2.getType())) {
            return null;
        }
        return this.getAdjustedPaneContentsScreenBounds(this.dragSourcePane, toolWindow2.getAnchor(), (int)((float)this.dragSourcePane.getRootPane().getHeight() * toolWindow2.getWindowInfo().getWeight()), (int)((float)this.dragSourcePane.getRootPane().getWidth() * toolWindow2.getWindowInfo().getWeight()));
    }

    private final Dimension getDefaultFloatingToolWindowSize(ToolWindowImpl toolWindow2) {
        Dimension dimension = this.getAdjustedPaneContentsScreenBounds(this.dragSourcePane, toolWindow2.getAnchor(), (int)((float)this.dragSourcePane.getRootPane().getHeight() * toolWindow2.getWindowInfo().getWeight()), (int)((float)this.dragSourcePane.getRootPane().getWidth() * toolWindow2.getWindowInfo().getWeight())).getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        return dimension;
    }

    private final Rectangle getDropTargetScreenBounds(ToolWindowPane dropTargetPane, ToolWindowAnchor anchor) {
        return this.getAdjustedPaneContentsScreenBounds(dropTargetPane, anchor, 200, 200);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPointInVisibleDockedToolWindow(DevicePoint devicePoint) {
        ToolWindowImpl toolWindowImpl = this.getToolWindow();
        ToolWindowImpl toolWindowImpl2 = toolWindowImpl;
        if (toolWindowImpl == null) return false;
        ToolWindowImpl it = toolWindowImpl2;
        boolean bl = false;
        Rectangle rectangle = this.getToolWindowScreenBoundsIfVisibleAndDocked(it);
        if (rectangle == null) return false;
        Boolean bl2 = rectangle.contains(devicePoint.getLocationOnScreen((Component)it.getComponent()));
        toolWindowImpl2 = bl2;
        if (bl2 == null) return false;
        boolean bl3 = (Boolean)((Object)toolWindowImpl2);
        return bl3;
    }

    private final int getStripeWidth(ToolWindowPane pane2, ToolWindowAnchor anchor) {
        return pane2.buttonManager.getStripeWidth(anchor);
    }

    private final int getStripeHeight(ToolWindowPane pane2, ToolWindowAnchor anchor) {
        return pane2.buttonManager.getStripeHeight(anchor);
    }

    private final JComponent getStripeButtonForToolWindow(ToolWindowImpl window) {
        JComponent jComponent;
        ToolWindowImpl toolWindowImpl = window;
        if (toolWindowImpl != null) {
            ToolWindowImpl it = toolWindowImpl;
            boolean bl = false;
            StripeButtonManager stripeButtonManager = this.dragSourcePane.buttonManager.getStripeFor(it.getAnchor(), it.isSplitMode()).getButtonFor(it.getId());
            jComponent = stripeButtonManager != null ? stripeButtonManager.getComponent() : null;
        } else {
            jComponent = null;
        }
        return jComponent;
    }

    private final AbstractDroppableStripe getSourceStripe(ToolWindowAnchor anchor, boolean isSplit) {
        return this.dragSourcePane.buttonManager.getStripeFor(anchor, isSplit);
    }

    private final AbstractDroppableStripe getTargetStripeByDropLocation(DevicePoint devicePoint, AbstractDroppableStripe preferredStripe) {
        AbstractDroppableStripe stripe;
        AbstractDroppableStripe abstractDroppableStripe = this.dragSourcePane.getStripeFor$intellij_platform_ide_impl(devicePoint, preferredStripe);
        if (abstractDroppableStripe == null) {
            abstractDroppableStripe = ToolWindowDragHelper.getTargetStripeByDropLocation$getTargetStripeForOtherPanes(this, devicePoint, preferredStripe);
        }
        AbstractDroppableStripe abstractDroppableStripe2 = stripe = abstractDroppableStripe;
        return Intrinsics.areEqual((Object)(abstractDroppableStripe2 != null ? abstractDroppableStripe2.getAnchor() : null), (Object)ToolWindowAnchor.TOP) ? null : stripe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BufferedImage createStripeButtonDragImage(Component component2) {
        Rectangle initialBounds = component2.getBounds();
        try {
            Dimension dimension;
            Object it;
            Object object;
            if (initialBounds.isEmpty()) {
                component2.setSize(component2.getPreferredSize());
            }
            boolean isLeft = SquareStripeButtonKt.isOnTheLeftStripe(component2);
            Component component3 = component2;
            if (component3 instanceof StripeButton) {
                it = object = ((StripeButton)component2).getSize();
                boolean bl = false;
                int delta = JBUIScale.scale((int)1);
                ((Dimension)it).width -= delta;
                ((Dimension)it).height -= delta;
                dimension = object;
            } else if (component3 instanceof AbstractSquareStripeButton) {
                it = object = ((AbstractSquareStripeButton)component2).getSize();
                boolean bl = false;
                JBInsets.removeFrom((Dimension)it, (Insets)((AbstractSquareStripeButton)component2).getInsets());
                JBInsets.removeFrom((Dimension)it, (Insets)SquareStripeButtonLook.Companion.getIconPadding(isLeft));
                dimension = object;
            } else {
                dimension = (Dimension)JBUI.emptySize();
            }
            Dimension areaSize = dimension;
            Intrinsics.checkNotNull((Object)areaSize);
            if (!ToolWindowDragHelperKt.access$isNotEmpty(areaSize)) {
                component3 = null;
                return component3;
            }
            BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)component2.getGraphicsConfiguration(), (int)areaSize.width, (int)areaSize.height, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage image2 = bufferedImage;
            it = image2.getGraphics();
            boolean bl = false;
            ((Graphics)it).setColor(this.isNewUi ? JBUI.CurrentTheme.ToolWindow.DragAndDrop.BUTTON_FLOATING_BACKGROUND : UIUtil.getBgFillColor((Component)component2.getParent()));
            ((Graphics)it).fillRect(0, 0, areaSize.width, areaSize.height);
            Component component4 = component2;
            if (component4 instanceof StripeButton) {
                ((StripeButton)component2).paint((Graphics)it);
            } else if (component4 instanceof AbstractSquareStripeButton) {
                AbstractSquareStripeButton abstractSquareStripeButton = (AbstractSquareStripeButton)component2;
                Intrinsics.checkNotNull((Object)it);
                abstractSquareStripeButton.paintDraggingButton((Graphics)it, isLeft);
            }
            ((Graphics)it).dispose();
            object = image2;
            return object;
        }
        finally {
            component2.setBounds(initialBounds);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void relocate$lambda$1(ToolWindowDragHelper this$0, AbstractDroppableStripe $targetStripe, ToolWindowImpl $toolWindow, DevicePoint $eventDevicePoint, AbstractDroppableStripe $preferredStripe, MouseEvent $event) {
        void it;
        Point toolWindowBounds;
        Cloneable cloneable;
        if (this$0.initialAnchor == null || this$0.initialIsSplit == null) {
            return;
        }
        if (this$0.isNewUi) {
            cloneable = $targetStripe.getToolWindowDropAreaScreenBounds();
        } else {
            Rectangle rectangle;
            Rectangle rectangle2 = this$0.getToolWindowScreenBoundsIfVisibleAndDocked($toolWindow);
            if (rectangle2 != null) {
                Rectangle rectangle3;
                Rectangle it2 = rectangle3 = rectangle2;
                boolean bl = false;
                rectangle = this$0.getTargetStripeByDropLocation($eventDevicePoint, $preferredStripe) == null && it2.contains($event.getLocationOnScreen()) ? rectangle3 : null;
            } else {
                rectangle = null;
            }
            if ((cloneable = (toolWindowBounds = rectangle)) == null) {
                ToolWindowPane toolWindowPane2 = this$0.lastDropTargetPane;
                Intrinsics.checkNotNull((Object)toolWindowPane2);
                cloneable = this$0.getDropTargetScreenBounds(toolWindowPane2, $targetStripe.getAnchor());
            }
        }
        Rectangle bounds = cloneable;
        Point point = toolWindowBounds = bounds.getLocation();
        Rectangle rectangle = bounds;
        boolean bl = false;
        ToolWindowPane toolWindowPane3 = this$0.lastDropTargetPane;
        Intrinsics.checkNotNull((Object)toolWindowPane3);
        SwingUtilities.convertPointFromScreen((Point)it, toolWindowPane3.getRootPane().getLayeredPane());
        rectangle.setLocation(toolWindowBounds);
        Boolean dropToSide = $targetStripe.getDropToSide();
        if (dropToSide != null) {
            int half;
            int n = half = $targetStripe.getAnchor().isHorizontal() ? bounds.width / 2 : bounds.height / 2;
            if (!$targetStripe.getAnchor().isHorizontal()) {
                bounds.height -= half;
                if (dropToSide.booleanValue()) {
                    bounds.y += half;
                }
            } else {
                bounds.width -= half;
                if (dropToSide.booleanValue()) {
                    bounds.x += half;
                }
            }
        }
        this$0.dropTargetHighlightComponent.setBounds(bounds);
    }

    private static final AbstractDroppableStripe getTargetStripeByDropLocation$getTargetStripeForOtherPanes(ToolWindowDragHelper this$0, DevicePoint devicePoint, AbstractDroppableStripe preferredStripe) {
        block1: {
            Object object = this$0.getToolWindow();
            if (object == null || (object = ((ToolWindowImpl)object).toolWindowManager) == null || (object = ((ToolWindowManagerImpl)((Object)object)).getToolWindowPanes$intellij_platform_ide_impl()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ToolWindowPane pane2 = (ToolWindowPane)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)pane2, (Object)this$0.dragSourcePane)) continue;
                AbstractDroppableStripe abstractDroppableStripe = pane2.buttonManager.getStripeFor(devicePoint, preferredStripe, pane2);
                if (abstractDroppableStripe == null) continue;
                AbstractDroppableStripe it = abstractDroppableStripe;
                boolean bl2 = false;
                return it;
            }
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/toolWindow/ToolWindowDragHelper$Companion;", "", "<init>", "()V", "THUMB_OPACITY", "", "createThumbnailDragImage", "Ljava/awt/image/BufferedImage;", "component", "Ljavax/swing/JComponent;", "thumbSize", "", "createThumbnailDragImage$intellij_platform_ide_impl", "createDropTargetHighlightComponent", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "createDropTargetHighlightComponent$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BufferedImage createThumbnailDragImage$intellij_platform_ide_impl(@NotNull JComponent component2, int thumbSize) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)component2.getGraphicsConfiguration(), (int)component2.getWidth(), (int)component2.getHeight(), (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage image2 = bufferedImage;
            Graphics graphics = image2.getGraphics();
            graphics.setColor(UIUtil.getBgFillColor((Component)component2));
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            RectanglePainter.FILL.paint((Graphics2D)graphics, 0, 0, component2.getWidth(), component2.getHeight(), null);
            component2.paint(graphics);
            ((Graphics2D)graphics).dispose();
            double width = image2.getWidth(null);
            double height = image2.getHeight(null);
            if (thumbSize == -1 || width <= (double)thumbSize && height <= (double)thumbSize) {
                return image2;
            }
            double ratio = width > height ? (double)thumbSize / width : (double)thumbSize / height;
            Image image3 = ImageUtil.scaleImage((Image)image2, (int)((int)(width * ratio)), (int)((int)(height * ratio)));
            Intrinsics.checkNotNull((Object)image3, (String)"null cannot be cast to non-null type java.awt.image.BufferedImage");
            return (BufferedImage)image3;
        }

        public static /* synthetic */ BufferedImage createThumbnailDragImage$intellij_platform_ide_impl$default(Companion companion, JComponent jComponent, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = JBUI.scale((int)220);
            }
            return companion.createThumbnailDragImage$intellij_platform_ide_impl(jComponent, n);
        }

        @NotNull
        public final NonOpaquePanel createDropTargetHighlightComponent$intellij_platform_ide_impl() {
            return new NonOpaquePanel(){

                public void paint(Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    if (ExperimentalUI.Companion.isNewUI()) {
                        g.setColor(JBUI.CurrentTheme.ToolWindow.DragAndDrop.AREA_BACKGROUND);
                    } else {
                        g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
                    }
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/toolWindow/ToolWindowDragHelper$DragImageDialog;", "Ljavax/swing/JDialog;", "Lcom/intellij/ui/drag/DialogWithImage;", "owner", "Ljavax/swing/JComponent;", "helper", "Lcom/intellij/toolWindow/ToolWindowDragHelper;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/toolWindow/ToolWindowDragHelper;)V", "getHelper", "()Lcom/intellij/toolWindow/ToolWindowDragHelper;", "value", "Ljava/awt/Image;", "image", "getImage", "()Ljava/awt/Image;", "setImage", "(Ljava/awt/Image;)V", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nToolWindowDragHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowDragHelper.kt\ncom/intellij/toolWindow/ToolWindowDragHelper$DragImageDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,819:1\n1#2:820\n*E\n"})
    private static final class DragImageDialog
    extends JDialog
    implements DialogWithImage {
        @NotNull
        private final ToolWindowDragHelper helper;
        @Nullable
        private Image image;

        public DragImageDialog(@NotNull JComponent owner, @NotNull ToolWindowDragHelper helper) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)((Object)helper), (String)"helper");
            super(ComponentUtil.getWindow((Component)owner), null, Dialog.ModalityType.MODELESS);
            this.helper = helper;
            this.setType(Window.Type.POPUP);
            this.setFocusableWindowState(false);
            this.setUndecorated(true);
            try {
                this.setOpacity(0.85f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAlwaysOnTop(true);
            this.setContentPane(new JLabel());
            this.getContentPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.getHelper().mouseReleased(e);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.getHelper().relocate(e);
                }
            });
        }

        @NotNull
        public final ToolWindowDragHelper getHelper() {
            return this.helper;
        }

        @Override
        @Nullable
        public Image getImage() {
            return this.image;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setImage(@Nullable Image value) {
            JBImageIcon jBImageIcon;
            this.image = value;
            Container container = this.getContentPane();
            Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type javax.swing.JLabel");
            JLabel $this$_set_image__u24lambda_u240 = (JLabel)container;
            boolean bl = false;
            JLabel jLabel = $this$_set_image__u24lambda_u240;
            Image image2 = value;
            if (image2 != null) {
                void it;
                Image image3 = image2;
                JLabel jLabel2 = jLabel;
                boolean bl2 = false;
                jBImageIcon = IconUtil.createImageIcon((Image)it);
                jLabel = jLabel2;
            } else {
                jBImageIcon = null;
            }
            jLabel.setIcon((Icon)jBImageIcon);
            $this$_set_image__u24lambda_u240.revalidate();
            this.pack();
            $this$_set_image__u24lambda_u240.repaint();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/toolWindow/ToolWindowDragHelper$DragSession;", "", "view", "Lcom/intellij/ui/drag/DragImageView;", "stripeButtonImage", "Ljava/awt/image/BufferedImage;", "toolWindowThumbnailImage", "<init>", "(Lcom/intellij/ui/drag/DragImageView;Ljava/awt/image/BufferedImage;Ljava/awt/image/BufferedImage;)V", "getView", "()Lcom/intellij/ui/drag/DragImageView;", "dragOut", "", "Ljava/lang/Boolean;", "setDragOut", "", "start", "stop", "intellij.platform.ide.impl"})
    private static final class DragSession {
        @NotNull
        private final DragImageView view;
        @NotNull
        private final BufferedImage stripeButtonImage;
        @Nullable
        private final BufferedImage toolWindowThumbnailImage;
        @Nullable
        private Boolean dragOut;

        public DragSession(@NotNull DragImageView view2, @NotNull BufferedImage stripeButtonImage, @Nullable BufferedImage toolWindowThumbnailImage) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)stripeButtonImage, (String)"stripeButtonImage");
            this.view = view2;
            this.stripeButtonImage = stripeButtonImage;
            this.toolWindowThumbnailImage = toolWindowThumbnailImage;
            this.setDragOut(false);
        }

        @NotNull
        public final DragImageView getView() {
            return this.view;
        }

        public final void setDragOut(boolean dragOut) {
            if (Intrinsics.areEqual((Object)dragOut, (Object)this.dragOut)) {
                return;
            }
            this.dragOut = dragOut;
            BufferedImage image2 = dragOut && this.toolWindowThumbnailImage != null ? this.toolWindowThumbnailImage : this.stripeButtonImage;
            this.view.setImage(image2);
        }

        public final void start() {
            this.view.show();
        }

        public final void stop() {
            this.view.hide();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/toolWindow/ToolWindowDragHelper$ToolWindowProvider;", "", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "getToolWindow", "()Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "intellij.platform.ide.impl"})
    public static interface ToolWindowProvider {
        @Nullable
        public ToolWindowImpl getToolWindow();
    }
}

