/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow.xNext.toolbar.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.toolWindow.xNext.toolbar.data.XNextToolbarManager;
import com.intellij.ui.UIBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/toolWindow/xNext/toolbar/actions/PinAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "toolWindowId", "", "<init>", "(Ljava/lang/String;)V", "getToolWindowId", "()Ljava/lang/String;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.platform.ide.impl"})
public final class PinAction
extends DumbAwareToggleAction {
    @NotNull
    private final String toolWindowId;

    public PinAction(@NotNull String toolWindowId) {
        Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
        this.toolWindowId = toolWindowId;
        this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfPreferred);
    }

    @NotNull
    public final String getToolWindowId() {
        return this.toolWindowId;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        XNextToolbarManager mng = XNextToolbarManager.Companion.getInstance(project3);
        return mng.isPinned(this.toolWindowId);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        XNextToolbarManager mng = XNextToolbarManager.Companion.getInstance(project3);
        mng.setPinned(this.toolWindowId, state2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean pinned = this.isSelected(e);
        e.getPresentation().setDescription(pinned ? UIBundle.message((String)"xnext.action.unpin.tab.tooltip", (Object[])new Object[0]) : UIBundle.message((String)"xnext.action.pin.tab.tooltip", (Object[])new Object[0]));
        e.getPresentation().setIcon(!pinned ? null : AllIcons.General.PinSelected);
        e.getPresentation().setSelectedIcon(!pinned ? null : AllIcons.General.PinSelectedHovered);
        e.getPresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_INLINE_ACTION, (Object)pinned);
    }
}

