/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.ComboboxEditorTextField;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class EditorComboBox
extends ComboBox
implements DocumentListener {
    public static TextComponentAccessor<EditorComboBox> COMPONENT_ACCESSOR = new TextComponentAccessor<EditorComboBox>(){

        public String getText(EditorComboBox component2) {
            return component2.getText();
        }

        public void setText(EditorComboBox component2, @NotNull String text2) {
            if (text2 == null) {
                1.$$$reportNull$$$0(0);
            }
            component2.setText(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/EditorComboBox$1", "setText"));
        }
    };
    private Document myDocument;
    private final Project myProject;
    private EditorTextField myEditorField = null;
    private final List<DocumentListener> myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIsListenerInstalled = false;
    private boolean myInheritSwingFont = true;
    private final FileType myFileType;
    private final boolean myIsViewer;

    public EditorComboBox(String text2) {
        this(EditorFactory.getInstance().createDocument((CharSequence)text2), null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorComboBox(String text2, Project project2, FileType fileType2) {
        this(EditorFactory.getInstance().createDocument((CharSequence)text2), project2, fileType2, false);
    }

    public EditorComboBox(Document document2, Project project2, FileType fileType2) {
        this(document2, project2, fileType2, false);
    }

    public EditorComboBox(Document document2, Project project2, FileType fileType2, boolean isViewer) {
        this.myFileType = fileType2;
        this.myIsViewer = isViewer;
        this.setDocument(document2);
        this.myProject = project2;
        this.enableEvents(8L);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor editor2;
                Editor editor3 = editor2 = EditorComboBox.this.myEditorField != null ? EditorComboBox.this.myEditorField.getEditor() : null;
                if (editor2 != null) {
                    editor2.getSelectionModel().removeSelection();
                }
            }
        });
        this.setHistory(new String[]{""});
        this.setEditable(true);
    }

    public void setFontInheritedFromLAF(boolean b) {
        this.myInheritSwingFont = b;
        this.setDocument(this.myDocument);
    }

    public String getText() {
        return this.myDocument.getText();
    }

    public void addDocumentListener(DocumentListener listener2) {
        this.myDocumentListeners.add(listener2);
        this.installDocumentListener();
    }

    public void removeDocumentListener(DocumentListener listener2) {
        this.myDocumentListeners.remove(listener2);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorComboBox.$$$reportNull$$$0(0);
        }
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.beforeDocumentChange(event);
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorComboBox.$$$reportNull$$$0(1);
        }
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.documentChanged(event);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public void setDocument(Document document2) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document2;
        this.installDocumentListener();
        if (this.myEditorField == null) {
            return;
        }
        this.myEditorField.setDocument(document2);
    }

    private void installDocumentListener() {
        if (this.myDocument != null && !this.myDocumentListeners.isEmpty() && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.isEmpty())) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    public void setText(String text2) {
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
            this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)text2);
            if (this.myEditorField != null && this.myEditorField.getEditor() != null) {
                this.myEditorField.getCaretModel().moveToOffset(this.myDocument.getTextLength());
            }
        }, null, (Object)this.myDocument));
    }

    public void removeSelection() {
        Editor editor2;
        if (this.myEditorField != null && (editor2 = this.myEditorField.getEditor()) != null) {
            editor2.getSelectionModel().removeSelection();
        }
    }

    public CaretModel getCaretModel() {
        return this.myEditorField.getCaretModel();
    }

    public void setHistory(String[] history) {
        this.setModel(new DefaultComboBoxModel<String>(history));
    }

    public void prependItem(String item) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(item);
        int count = this.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object itemAt = this.getItemAt(i2);
            if (item.equals(itemAt)) continue;
            objects.add(itemAt);
        }
        this.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(objects)));
    }

    public void appendItem(String item) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int count = this.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            objects.add(this.getItemAt(i2));
        }
        if (!objects.contains(item)) {
            objects.add(item);
        }
        this.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(objects)));
    }

    public void addNotify() {
        this.releaseEditor();
        this.setEditor();
        super.addNotify();
        this.myEditorField.getFocusTarget().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorComboBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditorComboBox.this.repaint();
            }
        });
    }

    private void setEditor() {
        this.myEditorField = this.createEditorTextField(this.myDocument, this.myProject, this.myFileType, this.myIsViewer);
        MyEditor editor2 = new MyEditor();
        this.setEditor(editor2);
        this.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)editor2));
    }

    protected ComboboxEditorTextField createEditorTextField(Document document2, Project project2, FileType fileType2, boolean isViewer) {
        return new ComboboxEditorTextField(document2, project2, fileType2, isViewer);
    }

    public void removeNotify() {
        super.removeNotify();
        this.releaseEditor();
        this.myEditorField = null;
    }

    private void releaseEditor() {
        if (this.myEditorField != null) {
            this.myEditorField.releaseEditorLater();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditorField != null && this.myEditorField.getEditor() != null) {
            this.setupEditorFont((EditorEx)this.myEditorField.getEditor());
        }
    }

    private void setupEditorFont(EditorEx editor2) {
        if (this.myInheritSwingFont) {
            editor2.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor2.getColorsScheme().setEditorFontSize(this.getFont().getSize());
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    public void setEnabled(boolean enabled2) {
        super.setEnabled(enabled2);
        if (this.myEditorField == null) {
            return;
        }
        this.myEditorField.setEnabled(enabled2);
    }

    public Dimension getPreferredSize() {
        if (UIUtil.isUnderIntelliJLaF() || StartupUiUtil.isUnderDarcula()) {
            return super.getPreferredSize();
        }
        if (this.myEditorField != null) {
            Dimension preferredSize = new Dimension(this.myEditorField.getComponent().getPreferredSize());
            JBInsets.addTo((Dimension)preferredSize, (Insets)this.getInsets());
            return preferredSize;
        }
        return new Dimension(100, 20);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (!((EditorEx)this.myEditorField.getEditor()).processKeyTyped(e)) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    public EditorEx getEditorEx() {
        return this.myEditorField != null ? (EditorEx)this.myEditorField.getEditor() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/ui/EditorComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeDocumentChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyEditor
    implements ComboBoxEditor {
        private MyEditor() {
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return EditorComboBox.this.myEditorField;
        }

        @Override
        public Object getItem() {
            return EditorComboBox.this.myDocument.getText();
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public void selectAll() {
            Editor editor2;
            if (EditorComboBox.this.myEditorField != null && (editor2 = EditorComboBox.this.myEditorField.getEditor()) != null) {
                editor2.getSelectionModel().setSelection(0, EditorComboBox.this.myDocument.getTextLength());
            }
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                EditorComboBox.this.setText(anObject.toString());
            } else {
                EditorComboBox.this.setText("");
            }
        }
    }
}

