/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FinderRecursivePanel<T>
extends OnePixelSplitter
implements UiCompatibleDataProvider,
UserDataHolder,
Disposable {
    private static final Logger LOG = Logger.getInstance(FinderRecursivePanel.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myGroupId;
    @Nullable
    private final FinderRecursivePanel<?> myParent;
    @Nullable
    private JComponent myChild;
    private boolean myNonBlockingLoad;
    protected JBList<T> myList;
    protected final CollectionListModel<T> myListModel;
    private List<ListItemPresentation> myPresentations;
    private final MergingUpdateQueue myMergingUpdateQueue;
    private volatile boolean isMergeListItemsRunning;
    private final AtomicBoolean myUpdateSelectedPathModeActive;
    private final Object myUpdateCoalesceKey;
    private final CopyProvider myCopyProvider;
    private final UserDataHolderBase myUserDataHolder;
    private volatile boolean myDisposed;

    protected FinderRecursivePanel(@NotNull FinderRecursivePanel<?> parent) {
        if (parent == null) {
            FinderRecursivePanel.$$$reportNull$$$0(0);
        }
        this(parent.getProject(), parent, parent.getGroupId());
    }

    protected FinderRecursivePanel(@NotNull Project project2, @Nullable String groupId) {
        if (project2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(1);
        }
        this(project2, null, groupId);
    }

    protected FinderRecursivePanel(@NotNull Project project2, @Nullable FinderRecursivePanel<?> parent, @Nullable String groupId) {
        if (project2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(2);
        }
        super(false, 0.0f);
        this.myChild = null;
        this.myNonBlockingLoad = false;
        this.myListModel = new CollectionListModel(new Object[0]);
        this.myPresentations = Collections.emptyList();
        this.myMergingUpdateQueue = new MergingUpdateQueue("FinderRecursivePanel", 100, true, (JComponent)((Object)this), (Disposable)this);
        this.myUpdateSelectedPathModeActive = new AtomicBoolean();
        this.myUpdateCoalesceKey = new Object();
        this.myCopyProvider = new CopyProvider(){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void performCopy(@NotNull DataContext dataContext2) {
                Object value;
                if (dataContext2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((value = FinderRecursivePanel.this.getSelectedValue()) != null) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(FinderRecursivePanel.this.getItemText(value)));
                }
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return FinderRecursivePanel.this.getSelectedValue() != null;
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/FinderRecursivePanel$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "performCopy";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isCopyEnabled";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isCopyVisible";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
        this.myUserDataHolder = new UserDataHolderBase();
        this.myProject = project2;
        this.myParent = parent;
        this.myGroupId = groupId;
        if (this.myParent != null) {
            Disposer.register(this.myParent, (Disposable)this);
        }
    }

    protected boolean isNonBlockingLoad() {
        return this.myNonBlockingLoad;
    }

    protected void setNonBlockingLoad(boolean nonBlockingLoad) {
        this.myNonBlockingLoad = nonBlockingLoad;
    }

    public void initPanel() {
        this.initWithoutUpdatePanel();
        this.updatePanel();
    }

    private void initWithoutUpdatePanel() {
        this.setFirstComponent(this.createLeftComponent());
        this.setSecondComponent(this.createDefaultRightComponent());
        if (this.getGroupId() != null) {
            this.setAndLoadSplitterProportionKey(this.getGroupId() + "[" + this.getIndex() + "]");
        }
    }

    @NotNull
    protected abstract List<T> getListItems();

    @Nls
    protected String getListEmptyText() {
        return IdeBundle.message((String)"empty.text.no.entries", (Object[])new Object[0]);
    }

    @NotNull
    @Nls
    protected abstract String getItemText(@NotNull T var1);

    @Nullable
    protected Icon getItemIcon(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NlsContexts.Tooltip
    @Nullable
    protected String getItemTooltipText(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return null;
    }

    protected abstract boolean hasChildren(@NotNull T var1);

    @Nullable
    protected VirtualFile getContainingFile(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(5);
        }
        return null;
    }

    protected boolean isEditable() {
        return this.getSelectedValue() != null;
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(6);
        }
        return new JPanel();
    }

    @Nullable
    protected JComponent createDefaultRightComponent() {
        return new JBPanelWithEmptyText().withEmptyText(IdeBundle.message((String)"empty.text.nothing.selected", (Object[])new Object[0]));
    }

    protected JComponent createLeftComponent() {
        this.myList = this.createList();
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane(this.myList, (int)20, (int)31);
        return ListWithFilter.wrap(this.myList, (JScrollPane)pane2, o -> this.getItemText(o));
    }

    protected JBList<T> createList() {
        JBList list2 = new JBList(this.myListModel);
        list2.setSelectionMode(0);
        list2.setEmptyText(this.getListEmptyText());
        list2.setCellRenderer(this.createListCellRenderer());
        if (this.hasFixedSizeListElements()) {
            list2.setFixedCellHeight(JBUIScale.scale((int)20));
            list2.setFixedCellWidth(list2.getWidth());
        }
        this.installListActions(list2);
        list2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                if (FinderRecursivePanel.this.isMergeListItemsRunning()) {
                    return;
                }
                if (FinderRecursivePanel.this.myUpdateSelectedPathModeActive.get()) {
                    return;
                }
                FinderRecursivePanel.this.updateRightComponent(true);
            }
        });
        ScrollingUtil.installActions((JList)list2);
        this.installEditOnDoubleClick(list2);
        return list2;
    }

    private void handleGotoPrevious() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myList, true);
    }

    private void handleGotoNext() {
        if (!this.myList.isEmpty() && this.myList.getSelectedValue() == null) {
            this.myList.setSelectedIndex(0);
            this.updateRightComponent(true);
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myList, true);
    }

    private void installListActions(JBList<T> list2) {
        AnAction previousPanelAction = new AnAction(IdeBundle.messagePointer((String)"action.FinderRecursivePanel.text.previous", (Object[])new Object[0]), AllIcons.Actions.Back){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!FinderRecursivePanel.this.isRootPanel());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                assert (FinderRecursivePanel.this.myParent != null);
                FinderRecursivePanel.this.myParent.handleGotoPrevious();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/FinderRecursivePanel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        previousPanelAction.registerCustomShortcutSet(37, 0, list2);
        AnAction nextPanelAction = new AnAction(IdeBundle.messagePointer((String)"action.FinderRecursivePanel.text.next", (Object[])new Object[0]), AllIcons.Actions.Forward){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                Object value = FinderRecursivePanel.this.getSelectedValue();
                e.getPresentation().setEnabled(value != null && FinderRecursivePanel.this.hasChildren(value) && FinderRecursivePanel.this.getSecondComponent() instanceof FinderRecursivePanel);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(2);
                }
                FinderRecursivePanel finderRecursivePanel = (FinderRecursivePanel)((Object)FinderRecursivePanel.this.getSecondComponent());
                finderRecursivePanel.handleGotoNext();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/FinderRecursivePanel$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        nextPanelAction.registerCustomShortcutSet(39, 0, list2);
        AnAction editAction = new AnAction(IdeBundle.messagePointer((String)"action.FinderRecursivePanel.text.edit", (Object[])new Object[0]), AllIcons.Actions.Edit){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(FinderRecursivePanel.this.isEditable());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(2);
                }
                FinderRecursivePanel.this.performEditAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/FinderRecursivePanel$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        editAction.registerCustomShortcutSet(CommonShortcuts.ENTER, list2);
        Object[] actions = new AnAction[]{previousPanelAction, nextPanelAction, Separator.getInstance(), editAction};
        Object[] customActions = this.getCustomListActions();
        if (customActions.length > 0) {
            actions = (AnAction[])ArrayUtil.append((Object[])actions, (Object)Separator.getInstance());
            actions = (AnAction[])ArrayUtil.mergeArrays((Object[])actions, (Object[])customActions);
        }
        DefaultActionGroup contextActionGroup = new DefaultActionGroup((AnAction[])actions);
        PopupHandler.installPopupMenu(list2, (ActionGroup)contextActionGroup, (String)"FinderPopup");
    }

    protected AnAction[] getCustomListActions() {
        return AnAction.EMPTY_ARRAY;
    }

    private void installSpeedSearch(JBList<T> list2) {
        ListSpeedSearch<T> search = ListSpeedSearch.installOn(list2, o -> this.getItemText(o));
        search.setComparator(new SpeedSearchComparator(false));
    }

    private void installEditOnDoubleClick(JBList<T> list2) {
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                FinderRecursivePanel.this.performEditAction();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/FinderRecursivePanel$6", "onDoubleClick"));
            }
        }.installOn(list2);
    }

    protected boolean performEditAction() {
        Navigatable data2 = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(DataManager.getInstance().getDataContext(this.myList));
        if (data2 != null && data2.canNavigate()) {
            data2.navigate(true);
        }
        return false;
    }

    protected ListCellRenderer<T> createListCellRenderer() {
        return new MyListCellRenderer();
    }

    protected void doCustomizeCellRenderer(@NotNull SimpleColoredComponent comp, @NotNull JList list2, @NotNull T value, int index, boolean selected, boolean hasFocus) {
        if (comp == null) {
            FinderRecursivePanel.$$$reportNull$$$0(7);
        }
        if (list2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(8);
        }
        if (value == null) {
            FinderRecursivePanel.$$$reportNull$$$0(9);
        }
    }

    protected boolean hasFixedSizeListElements() {
        return true;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Module o;
        T selectedValue;
        if (sink == null) {
            FinderRecursivePanel.$$$reportNull$$$0(10);
        }
        if ((selectedValue = this.getSelectedValue()) == null) {
            return;
        }
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyProvider);
        if (selectedValue instanceof Module) {
            o = (Module)selectedValue;
            sink.set(PlatformCoreDataKeys.MODULE, (Object)o);
        }
        if (!(selectedValue instanceof ValidateableNode) || (o = (ValidateableNode)selectedValue).isValid()) {
            DataSink.uiDataSnapshot((DataSink)sink, selectedValue);
        }
        if (selectedValue instanceof PsiElement) {
            o = (PsiElement)selectedValue;
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> FinderRecursivePanel.lambda$uiDataSnapshot$2((PsiElement)o));
        }
        if (selectedValue instanceof Navigatable) {
            o = (Navigatable)selectedValue;
            sink.lazy(CommonDataKeys.NAVIGATABLE, () -> FinderRecursivePanel.lambda$uiDataSnapshot$3((Navigatable)o));
        }
    }

    @Nullable
    public <U> U getUserData(@NotNull Key<U> key) {
        if (key == null) {
            FinderRecursivePanel.$$$reportNull$$$0(11);
        }
        return (U)this.myUserDataHolder.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, @Nullable U value) {
        if (key == null) {
            FinderRecursivePanel.$$$reportNull$$$0(12);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    public void dispose() {
        super.dispose();
        this.myMergingUpdateQueue.cancelAllUpdates();
        this.myDisposed = true;
    }

    protected boolean isDisposed() {
        return this.myDisposed;
    }

    @Nullable
    public T getSelectedValue() {
        return (T)this.myList.getSelectedValue();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(13);
        }
        return project2;
    }

    @Nullable
    public FinderRecursivePanel<?> getParentPanel() {
        return this.myParent;
    }

    @Nullable
    protected String getGroupId() {
        return this.myGroupId;
    }

    public void updatePanel() {
        if (this.myUpdateSelectedPathModeActive.get()) {
            return;
        }
        this.myList.setPaintBusy(true);
        this.myMergingUpdateQueue.queue(Update.create((Object)"update", () -> {
            T oldValue = this.getSelectedValue();
            int oldIndex = this.myList.getSelectedIndex();
            if (this.myNonBlockingLoad) {
                this.scheduleUpdateNonBlocking(oldValue, oldIndex);
            } else {
                this.scheduleUpdateBlocking(oldValue, oldIndex);
            }
        }));
    }

    private void scheduleUpdateBlocking(T oldSelectedValue, int oldSelectedIndex) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            try {
                List<T> listItems = this.getListItems();
                List presentations = ContainerUtil.map(listItems, this::getPresentation);
                ApplicationManager.getApplication().invokeLater(() -> this.updateList(oldSelectedValue, oldSelectedIndex, listItems, presentations));
            }
            finally {
                this.myList.setPaintBusy(false);
            }
        }));
    }

    private void scheduleUpdateNonBlocking(T oldSelectedValue, int oldSelectedIndex) {
        ReadAction.nonBlocking(() -> {
            List<T> listItems = this.getListItems();
            List presentations = ContainerUtil.map(listItems, this::getPresentation);
            return Pair.create(listItems, (Object)presentations);
        }).finishOnUiThread(ModalityState.any(), items2 -> {
            try {
                this.updateList(oldSelectedValue, oldSelectedIndex, (List)items2.first, (List)items2.second);
            }
            finally {
                this.myList.setPaintBusy(false);
            }
        }).coalesceBy(new Object[]{this.myUpdateCoalesceKey}).expireWith((Disposable)this).inSmartMode(this.myProject).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private ListItemPresentation getPresentation(T item) {
        VirtualFile file2 = this.getContainingFile(item);
        Color bgColor = file2 == null ? null : VfsPresentationUtil.getFileBackgroundColor(this.myProject, file2);
        return new ListItemPresentation(this.getItemText(item), this.getItemIcon(item), bgColor);
    }

    private void updateList(T oldValue, int oldIndex, List<? extends T> listItems, List<ListItemPresentation> presentations) {
        this.myPresentations = presentations;
        this.mergeListItems(this.myListModel, (JList<? extends T>)this.myList, listItems);
        if (this.myList.isEmpty()) {
            this.createRightComponent();
        } else if (this.myList.getSelectedIndex() < 0) {
            this.myList.setSelectedIndex(this.myListModel.getSize() > oldIndex ? oldIndex : 0);
        } else {
            Object newValue = this.myList.getSelectedValue();
            this.updateRightComponent(oldValue == null || !oldValue.equals(newValue) || this.myList.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeListItems(@NotNull CollectionListModel<T> listModel, @NotNull JList<? extends T> list2, @NotNull List<? extends T> newItems) {
        if (listModel == null) {
            FinderRecursivePanel.$$$reportNull$$$0(14);
        }
        if (list2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(15);
        }
        if (newItems == null) {
            FinderRecursivePanel.$$$reportNull$$$0(16);
        }
        this.setMergeListItemsRunning(true);
        try {
            if (listModel.getSize() == 0) {
                listModel.add(newItems);
            } else if (newItems.isEmpty()) {
                listModel.removeAll();
            } else {
                int newSelectedIndex = -1;
                T selection = list2.getSelectedValue();
                if (selection != null) {
                    newSelectedIndex = newItems.indexOf(selection);
                }
                listModel.removeAll();
                listModel.add(newItems);
                list2.setSelectedIndex(newSelectedIndex);
            }
        }
        finally {
            this.setMergeListItemsRunning(false);
        }
    }

    public boolean isMergeListItemsRunning() {
        return this.isMergeListItemsRunning;
    }

    protected void setMergeListItemsRunning(boolean isListMergeRunning) {
        this.isMergeListItemsRunning = isListMergeRunning;
    }

    public void updateRightComponent(boolean force) {
        if (force) {
            this.createRightComponent();
        } else if (this.myChild instanceof FinderRecursivePanel) {
            ((FinderRecursivePanel)((Object)this.myChild)).updatePanel();
        }
    }

    private void createRightComponent() {
        T value;
        if (this.myChild instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myChild));
        }
        if ((value = this.getSelectedValue()) != null) {
            this.myChild = this.createRightComponent(value);
            JComponent jComponent = this.myChild;
            if (jComponent instanceof FinderRecursivePanel) {
                FinderRecursivePanel childPanel = (FinderRecursivePanel)((Object)jComponent);
                childPanel.initPanel();
            }
        } else {
            this.myChild = this.createDefaultRightComponent();
        }
        this.setSecondComponent(this.myChild);
    }

    private int getIndex() {
        int index = 0;
        for (FinderRecursivePanel<?> parent = this.myParent; parent != null; parent = parent.getParentPanel()) {
            ++index;
        }
        return index;
    }

    protected boolean isRootPanel() {
        return this.getParentPanel() == null;
    }

    public void doLayout() {
        if (this.myProportion == 0.0f) {
            int total = this.getOrientation() ? this.getHeight() : this.getWidth();
            float proportion = (float)this.getFirstComponentPreferredSize() / (float)(total - this.getDividerWidth());
            if (proportion > 0.0f && proportion < 1.0f) {
                this.setProportion(proportion);
            }
        }
        super.doLayout();
    }

    protected int getFirstComponentPreferredSize() {
        return 200;
    }

    private static /* synthetic */ Navigatable lambda$uiDataSnapshot$3(Navigatable o) {
        return o;
    }

    private static /* synthetic */ PsiElement lambda$uiDataSnapshot$2(PsiElement o) {
        return o;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/FinderRecursivePanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listModel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/FinderRecursivePanel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemTooltipText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeCellRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeListItems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    private final class MyListCellRenderer
    extends ColoredListCellRenderer<T> {
        @NonNls
        private static final String ITEM_PROPERTY = "FINDER_RECURSIVE_PANEL_ITEM_PROPERTY";

        private MyListCellRenderer() {
        }

        public String getToolTipText(MouseEvent event) {
            String toolTipText = super.getToolTipText(event);
            if (toolTipText != null) {
                return toolTipText;
            }
            Object value = this.getClientProperty(ITEM_PROPERTY);
            return FinderRecursivePanel.this.getItemTooltipText(value);
        }

        public Component getListCellRendererComponent(JList<? extends T> list2, T value, int index, boolean isSelected, boolean cellHasFocus) {
            this.mySelected = isSelected;
            this.myForeground = UIUtil.getTreeForeground();
            this.mySelectionForeground = cellHasFocus ? list2.getSelectionForeground() : UIUtil.getTreeForeground();
            this.clear();
            this.setFont(UIUtil.getListFont());
            this.putClientProperty(ITEM_PROPERTY, value);
            ListItemPresentation itemPresentation = null;
            try {
                itemPresentation = FinderRecursivePanel.this.myPresentations.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.error("No presentation for list item " + String.valueOf(value), (Throwable)e);
            }
            if (itemPresentation != null) {
                this.setIcon(itemPresentation.icon);
            }
            String itemText = itemPresentation != null ? itemPresentation.text : IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]);
            this.append(itemText);
            try {
                FinderRecursivePanel.this.doCustomizeCellRenderer((SimpleColoredComponent)this, list2, value, index, isSelected, cellHasFocus);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            Color bg = UIUtil.getTreeBackground((boolean)isSelected, (boolean)cellHasFocus);
            if (!isSelected) {
                Color bgColor = itemPresentation == null ? null : itemPresentation.backgroundColor;
                bg = bgColor == null ? bg : bgColor;
            }
            this.setBackground(bg);
            if (FinderRecursivePanel.this.hasChildren(value)) {
                MyListCellRenderer rendererComponent = this;
                JPanel result2 = new JPanel(new BorderLayout(), (JComponent)((Object)rendererComponent)){
                    final /* synthetic */ JComponent val$rendererComponent;
                    {
                        this.val$rendererComponent = jComponent;
                        super(arg0);
                    }

                    @Override
                    public String getToolTipText(MouseEvent event) {
                        return this.val$rendererComponent.getToolTipText(event);
                    }
                };
                result2.getAccessibleContext().setAccessibleName(itemText);
                JLabel childrenLabel = new JLabel();
                childrenLabel.setOpaque(true);
                childrenLabel.setVisible(true);
                childrenLabel.setBackground(bg);
                boolean isDark = ColorUtil.isDark((Color)UIUtil.getListSelectionBackground((boolean)true));
                childrenLabel.setIcon(isDark ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep);
                result2.add((Component)((Object)this), "Center");
                result2.add((Component)childrenLabel, "East");
                return result2;
            }
            return this;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/FinderRecursivePanel$MyListCellRenderer", "customizeCellRenderer"));
        }
    }

    private record ListItemPresentation(@NotNull @Nls String text, @Nullable Icon icon, @Nullable Color backgroundColor) {
        @NotNull
        @Nls
        private final String text;

        private ListItemPresentation(@NotNull @Nls String text2, @Nullable Icon icon2, @Nullable Color backgroundColor) {
            if (text2 == null) {
                ListItemPresentation.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        @Nls
        public String text() {
            String string = this.text;
            if (string == null) {
                ListItemPresentation.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/FinderRecursivePanel$ListItemPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$ListItemPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    protected static final class DisposablePanel
    extends JPanel
    implements Disposable {
        public DisposablePanel(LayoutManager layout2, @Nullable Disposable parent) {
            super(layout2);
            if (parent != null) {
                Disposer.register((Disposable)parent, (Disposable)this);
            }
        }

        public void dispose() {
        }
    }
}

