/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GotItComponentBuilderKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.InlineView;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use JBHtmlPane and <code> element instead")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0096\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ui/InlineCodeExtension;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "<init>", "()V", "invoke", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "defaultView", "Companion", "InlineCodeView", "intellij.platform.ide.impl"})
final class InlineCodeExtension
implements ExtendableHTMLViewFactory.Extension {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public View invoke(@NotNull Element elem, @NotNull View defaultView) {
        AttributeSet tagAttributes;
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)defaultView, (String)"defaultView");
        Object object = elem.getAttributes().getAttribute(HTML.Tag.SPAN);
        AttributeSet attributeSet = tagAttributes = object instanceof AttributeSet ? (AttributeSet)object : null;
        if (Intrinsics.areEqual((Object)(attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.CLASS) : null), (Object)"code")) {
            return new InlineCodeView(elem);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\r2\u000b\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\rJ\u001f\u0010\u000f\u001a\f0\u0005\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00112\u000b\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/InlineCodeExtension$Companion;", "", "<init>", "()V", "getStyles", "", "foreground", "Ljava/awt/Color;", "background", "borderColor", "font", "Ljava/awt/Font;", "patchCodeTags", "Lorg/jetbrains/annotations/Nls;", "htmlText", "codeSpan", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "text", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getStyles(@NotNull Color foreground, @NotNull Color background, @NotNull Color borderColor, @NotNull Font font) {
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            StringBuilder fontStyles = new StringBuilder();
            fontStyles.append(" font-family: ").append(font.getFamily()).append(";").append(" font-size: ").append(font.getSize()).append("pt;");
            if (font.isBold()) {
                fontStyles.append(" font-weight: 700;");
            }
            if (font.isItalic()) {
                fontStyles.append(" font-style: italic;");
            }
            return ".code { color: " + ColorUtil.toHtmlColor((Color)foreground) + "; background-color: " + ColorUtil.toHtmlColor((Color)background) + "; border-color: #" + ColorUtil.toHex((Color)borderColor, (boolean)true) + ";" + fontStyles + " }";
        }

        @NotNull
        public final String patchCodeTags(@NotNull String htmlText) {
            Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
            StringBuilder builder = new StringBuilder();
            int codeStartTagInd = StringsKt.indexOf$default((CharSequence)htmlText, (String)"<code>", (int)0, (boolean)false, (int)6, null);
            int tagLength = 6;
            int ind = 0;
            while (codeStartTagInd != -1) {
                String text2;
                String string = htmlText.substring(ind, codeStartTagInd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                builder.append(string);
                int codeEndTagInd = StringsKt.indexOf$default((CharSequence)htmlText, (String)"</code>", (int)codeStartTagInd, (boolean)false, (int)4, null);
                if (codeEndTagInd == -1) {
                    throw new IllegalStateException(("<code> tag opened but do not closed, html text:\n" + htmlText).toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)htmlText.substring(codeStartTagInd + tagLength, codeEndTagInd), (String)"substring(...)");
                String span = this.codeSpan(StringsKt.replace$default((String)text2, (String)" ", (String)"\u00a0", (boolean)false, (int)4, null));
                builder.append("\u00a0" + span + "\u00a0");
                ind = codeEndTagInd + tagLength + 1;
                codeStartTagInd = StringsKt.indexOf$default((CharSequence)htmlText, (String)"<code>", (int)ind, (boolean)false, (int)4, null);
            }
            String string = htmlText.substring(ind);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.append(string);
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private final String codeSpan(String text2) {
            String string = HtmlChunk.span().attr("class", "code").addText(text2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ui/InlineCodeExtension$InlineCodeView;", "Ljavax/swing/text/html/InlineView;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "horizontalIndent", "", "getHorizontalIndent", "()F", "verticalIndent", "getVerticalIndent", "borderColor", "Ljava/awt/Color;", "getBorderColor", "()Ljava/awt/Color;", "arcSize", "getArcSize", "paint", "", "g", "Ljava/awt/Graphics;", "a", "Ljava/awt/Shape;", "Companion", "intellij.platform.ide.impl"})
    private static final class InlineCodeView
    extends InlineView {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final float DEFAULT_HORIZONTAL_INDENT = 2.5f;
        private static final float DEFAULT_VERTICAL_INDENT = -0.5f;
        private static final float DEFAULT_ARC = 8.0f;

        public InlineCodeView(@NotNull Element elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            super(elem);
        }

        private final float getHorizontalIndent() {
            View view2 = this;
            CSS.Attribute attribute = CSS.Attribute.MARGIN_LEFT;
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"MARGIN_LEFT");
            return GotItComponentBuilderKt.access$getFloatAttribute(view2, attribute, 2.5f);
        }

        private final float getVerticalIndent() {
            View view2 = this;
            CSS.Attribute attribute = CSS.Attribute.MARGIN_TOP;
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"MARGIN_TOP");
            return GotItComponentBuilderKt.access$getFloatAttribute(view2, attribute, -0.5f);
        }

        private final Color getBorderColor() {
            return GotItComponentBuilderKt.access$getBorderColorAttr(this);
        }

        private final float getArcSize() {
            return JBUIScale.scale((float)8.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g, @NotNull Shape a) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            Color backgroundColor = this.getBackground();
            try {
                Rectangle2D baseRect = a.getBounds2D();
                float horIndent = this.getHorizontalIndent();
                float vertIndent = this.getVerticalIndent();
                RoundRectangle2D.Double rect = new RoundRectangle2D.Double(baseRect.getX() - (double)horIndent, baseRect.getY() - (double)vertIndent, baseRect.getWidth() + (double)((float)2 * horIndent), baseRect.getHeight() + (double)((float)2 * vertIndent), this.getArcSize(), this.getArcSize());
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(backgroundColor);
                g2d.fill(rect);
                Color borderBg = this.getBorderColor();
                if (borderBg != null) {
                    g2d.setColor(borderBg);
                    g2d.draw(rect);
                }
            }
            finally {
                g2d.dispose();
            }
            try {
                this.setBackground(null);
                super.paint(g, a);
            }
            finally {
                this.setBackground(backgroundColor);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/InlineCodeExtension$InlineCodeView$Companion;", "", "<init>", "()V", "DEFAULT_HORIZONTAL_INDENT", "", "DEFAULT_VERTICAL_INDENT", "DEFAULT_ARC", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

