/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Conditions;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeTableSpeedSearch
extends SpeedSearchBase<TreeTable> {
    private static final Convertor<TreePath, String> TO_STRING = object -> {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
        return node.toString();
    };
    private final Convertor<? super TreePath, String> myToStringConvertor;
    protected boolean myCanExpand;

    protected TreeTableSpeedSearch(TreeTable tree2, Void sig, Convertor<? super TreePath, String> toStringConvertor) {
        super(tree2, sig);
        this.myToStringConvertor = toStringConvertor;
    }

    protected TreeTableSpeedSearch(TreeTable tree2, Void sig) {
        this(tree2, sig, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING);
    }

    @NotNull
    public static TreeTableSpeedSearch installOn(TreeTable tree2, Convertor<? super TreePath, String> toStringConvertor) {
        TreeTableSpeedSearch search = new TreeTableSpeedSearch(tree2, null, toStringConvertor);
        search.setupListeners();
        TreeTableSpeedSearch treeTableSpeedSearch = search;
        if (treeTableSpeedSearch == null) {
            TreeTableSpeedSearch.$$$reportNull$$$0(0);
        }
        return treeTableSpeedSearch;
    }

    @NotNull
    public static TreeTableSpeedSearch installOn(TreeTable tree2) {
        return TreeTableSpeedSearch.installOn(tree2, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING);
    }

    @Deprecated
    public TreeTableSpeedSearch(TreeTable tree2, Convertor<? super TreePath, String> toStringConvertor) {
        super(tree2);
        this.myToStringConvertor = toStringConvertor;
    }

    @Deprecated(forRemoval=true)
    public TreeTableSpeedSearch(TreeTable tree2) {
        this(tree2, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING);
    }

    public void setCanExpand(boolean canExpand) {
        this.myCanExpand = canExpand;
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        return !((TreeTable)this.getComponent()).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        TreePath treePath = (TreePath)element;
        TreeTableTree tree2 = ((TreeTable)this.myComponent).getTree();
        if (this.myCanExpand) {
            tree2.expandPath(treePath.getParentPath());
        }
        int row2 = tree2.getRowForPath(treePath);
        TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{((TreeTable)this.myComponent).convertRowIndexToView(row2)});
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
    }

    @Override
    protected int getSelectedIndex() {
        if (this.myCanExpand) {
            return this.allPaths().indexOf(Conditions.equalTo((Object)((TreeTable)this.myComponent).getTree().getSelectionPath()));
        }
        int[] selectionRows = ((TreeTable)this.myComponent).getTree().getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    @NotNull
    protected final ListIterator<Object> getElementIterator(int startingViewIndex) {
        ListIterator<Object> listIterator = ((ArrayList)this.allPaths().addAllTo(new ArrayList())).listIterator(startingViewIndex);
        if (listIterator == null) {
            TreeTableSpeedSearch.$$$reportNull$$$0(1);
        }
        return listIterator;
    }

    @Override
    protected final int getElementCount() {
        return this.allPaths().size();
    }

    @NotNull
    protected JBIterable<TreePath> allPaths() {
        JBIterable<TreePath> jBIterable = TreeSpeedSearch.allPaths((JTree)((TreeTable)this.getComponent()).getTree(), this.myCanExpand);
        if (jBIterable == null) {
            TreeTableSpeedSearch.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @Override
    protected String getElementText(Object element) {
        TreePath path = (TreePath)element;
        String string = (String)this.myToStringConvertor.convert((Object)path);
        if (string == null) {
            return (String)TO_STRING.convert((Object)path);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/TreeTableSpeedSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "installOn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIterator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "allPaths";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

