/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.WindowDeactivationManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/WindowDeactivationManager;", "", "<init>", "()V", "addWindowDeactivationListener", "", "window", "Ljava/awt/Window;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "onWindowDeactivated", "Ljava/lang/Runnable;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class WindowDeactivationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void addWindowDeactivationListener(@NotNull Window window, @NotNull Project project2, @NotNull Disposable disposable, @NotNull Runnable onWindowDeactivated) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)onWindowDeactivated, (String)"onWindowDeactivated");
        WindowAdapter focusListener2 = new WindowAdapter(onWindowDeactivated){
            final /* synthetic */ Runnable $onWindowDeactivated;
            {
                this.$onWindowDeactivated = $onWindowDeactivated;
            }

            public void windowGainedFocus(WindowEvent e) {
                this.$onWindowDeactivated.run();
            }
        };
        window.addWindowListener(new WindowAdapter(project2, window, onWindowDeactivated, disposable, focusListener2){
            private boolean wasOpened;
            final /* synthetic */ Project $project;
            final /* synthetic */ Window $window;
            final /* synthetic */ Runnable $onWindowDeactivated;
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ addWindowDeactivationListener.focusListener.1 $focusListener;
            {
                this.$project = $project;
                this.$window = $window;
                this.$onWindowDeactivated = $onWindowDeactivated;
                this.$disposable = $disposable;
                this.$focusListener = $focusListener;
            }

            public final boolean getWasOpened() {
                return this.wasOpened;
            }

            public final void setWasOpened(boolean bl) {
                this.wasOpened = bl;
            }

            public void windowDeactivated(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.wasOpened) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> addWindowDeactivationListener.1.windowDeactivated$lambda$0(this.$project, this.$window, this.$onWindowDeactivated), ModalityState.current());
            }

            /*
             * WARNING - void declaration
             */
            public void windowOpened(WindowEvent e) {
                void $this$forEach$iv;
                this.wasOpened = true;
                Frame[] frameArray = Frame.getFrames();
                Intrinsics.checkNotNullExpressionValue((Object)frameArray, (String)"getFrames(...)");
                Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])frameArray), arg_0 -> addWindowDeactivationListener.1.windowOpened$lambda$1(this.$project, arg_0));
                Disposable disposable = this.$disposable;
                addWindowDeactivationListener.focusListener.1 var4_4 = this.$focusListener;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Frame it = (Frame)element$iv;
                    boolean bl = false;
                    if (!Disposer.tryRegister((Disposable)disposable, () -> addWindowDeactivationListener.1.windowOpened$lambda$2$0(it, var4_4))) continue;
                    it.addWindowFocusListener(var4_4);
                }
            }

            private static final void windowDeactivated$lambda$0(Project $project, Window $window, Runnable $onWindowDeactivated) {
                Component component2 = IdeFocusManager.getInstance((Project)$project).getFocusOwner();
                if (component2 == null) {
                    return;
                }
                Component focusOwner = component2;
                if (!SwingUtilities.isDescendingFrom(focusOwner, $window)) {
                    $onWindowDeactivated.run();
                }
            }

            private static final boolean windowOpened$lambda$1(Project $project, Frame it) {
                return it instanceof IdeFrame && ((IdeFrame)it).getProject() == $project;
            }

            private static final void windowOpened$lambda$2$0(Frame $it, addWindowDeactivationListener.focusListener.1 $focusListener) {
                $it.removeWindowFocusListener($focusListener);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final WindowDeactivationManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/WindowDeactivationManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ui/WindowDeactivationManager;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nWindowDeactivationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowDeactivationManager.kt\ncom/intellij/ui/WindowDeactivationManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,70:1\n42#2,3:71\n*S KotlinDebug\n*F\n+ 1 WindowDeactivationManager.kt\ncom/intellij/ui/WindowDeactivationManager$Companion\n*L\n24#1:71,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WindowDeactivationManager getInstance() {
            boolean $i$f$service = false;
            Class<WindowDeactivationManager> serviceClass$iv = WindowDeactivationManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (WindowDeactivationManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

