/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.JBR;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class WindowMouseListener
extends MouseAdapter
implements MouseInputListener {
    private static final boolean moveAfterMouseRelease = StartupUiUtil.isWaylandToolkit();
    protected final Component myContent;
    @JdkConstants.CursorType
    int myCursorType;
    private Point myLocation;
    private Rectangle viewBounds;
    private int mouseButton;
    private boolean wasDragged;
    private boolean leftMouseButtonOnly = false;

    WindowMouseListener(Component content2) {
        this.myContent = content2;
    }

    @JdkConstants.CursorType
    abstract int getCursorType(Component var1, Point var2);

    abstract void updateBounds(Rectangle var1, Component var2, int var3, int var4);

    public void setLeftMouseButtonOnly(boolean leftMouseButtonOnly) {
        this.leftMouseButtonOnly = leftMouseButtonOnly;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.update(event, false);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.update(event, true);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.process(event, true);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.process(event, false);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.process(event, false);
    }

    protected boolean isDisabled(Component view2) {
        if (view2 instanceof Frame) {
            int state2 = ((Frame)view2).getExtendedState();
            if (WindowMouseListener.isStateSet(1, state2)) {
                return true;
            }
            if (WindowMouseListener.isStateSet(6, state2) && !WindowMouseListener.jbrMoveSupported(view2)) {
                return true;
            }
        }
        return false;
    }

    private void update(MouseEvent event, boolean start2) {
        Component content2;
        Component view2;
        if (event.isConsumed() || start2 && this.leftMouseButtonOnly && !SwingUtilities.isLeftMouseButton(event)) {
            return;
        }
        if (start2) {
            this.wasDragged = false;
        }
        if (this.myLocation == null && (view2 = this.getView(content2 = this.getContent(event))) != null) {
            this.myCursorType = this.isDisabled(view2) ? -1 : this.getCursorType(view2, event.getLocationOnScreen());
            this.setCursor(content2, Cursor.getPredefinedCursor(this.myCursorType == -1 ? 0 : this.myCursorType));
            if (start2 && this.myCursorType != -1) {
                this.mouseButton = event.getButton();
                this.myLocation = event.getLocationOnScreen();
                this.viewBounds = view2.getBounds();
                event.consume();
            }
        }
    }

    private void process(MouseEvent event, boolean mouseMove) {
        if (event.isConsumed()) {
            return;
        }
        if (mouseMove) {
            this.wasDragged = true;
        }
        if (this.myLocation != null && this.viewBounds != null) {
            Component content2 = this.getContent(event);
            Component view2 = this.getView(content2);
            if (mouseMove && this.myCursorType == 0 && WindowMouseListener.jbrMoveSupported(view2)) {
                JBR.getWindowMove().startMovingTogetherWithMouse((Window)view2, this.mouseButton);
                this.myLocation = null;
                this.viewBounds = null;
                return;
            }
            if (view2 != null) {
                Rectangle bounds = new Rectangle(this.viewBounds);
                int dx = event.getXOnScreen() - this.myLocation.x;
                int dy = event.getYOnScreen() - this.myLocation.y;
                if (this.myCursorType == 0 && view2 instanceof Frame) {
                    int state2 = ((Frame)view2).getExtendedState();
                    if (WindowMouseListener.isStateSet(2, state2)) {
                        dx = 0;
                    }
                    if (WindowMouseListener.isStateSet(4, state2)) {
                        dy = 0;
                    }
                }
                this.updateBounds(bounds, view2, dx, dy);
                Rectangle viewBounds = view2.getBounds();
                if (!bounds.equals(viewBounds)) {
                    boolean reallyMoveWindow;
                    boolean moved = bounds.x != viewBounds.x || bounds.y != viewBounds.y;
                    boolean resized = bounds.width != viewBounds.width || bounds.height != viewBounds.height;
                    boolean bl = reallyMoveWindow = !moveAfterMouseRelease || !mouseMove;
                    if (moved && reallyMoveWindow || resized) {
                        view2.reshape(bounds.x, bounds.y, bounds.width, bounds.height);
                        view2.invalidate();
                        view2.validate();
                        view2.repaint();
                        if (moved) {
                            this.notifyMoved();
                        }
                        if (resized) {
                            this.notifyResized();
                        }
                    }
                }
            }
            if (!mouseMove) {
                this.setCursor(content2, Cursor.getPredefinedCursor(0));
                this.myLocation = null;
                if (this.wasDragged) {
                    this.viewBounds = null;
                }
            }
            event.consume();
        } else if (!mouseMove && this.viewBounds != null) {
            this.viewBounds = null;
            event.consume();
        }
    }

    protected Component getContent(MouseEvent event) {
        return this.myContent != null ? this.myContent : event.getComponent();
    }

    protected Component getView(Component component2) {
        return ComponentUtil.getWindow((Component)component2);
    }

    protected void setCursor(@NotNull Component content2, Cursor cursor) {
        if (content2 == null) {
            WindowMouseListener.$$$reportNull$$$0(0);
        }
        UIUtil.setCursor((Component)content2, (Cursor)cursor);
    }

    public boolean isBusy() {
        return this.myLocation != null;
    }

    protected void notifyMoved() {
    }

    protected void notifyResized() {
    }

    static boolean isStateSet(int mask, int state2) {
        return mask == (mask & state2);
    }

    private static boolean jbrMoveSupported(Component component2) {
        if (StartupUiUtil.isWaylandToolkit()) {
            Window window;
            return component2 instanceof Window && (window = (Window)component2).getType() != Window.Type.POPUP;
        }
        return (component2 instanceof Frame || component2 instanceof Dialog) && JBR.isWindowMoveSupported();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/WindowMouseListener", "setCursor"));
    }
}

