/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.laf.intellij.IdeaPopupMenuUI;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.PopupCornerType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.PopupBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.JBR;
import java.awt.Color;
import java.awt.Window;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindowRoundedCornersManager {
    public static void configure(@NotNull DialogWrapper dialog2) {
        if (dialog2 == null) {
            WindowRoundedCornersManager.$$$reportNull$$$0(0);
        }
        if (WindowRoundedCornersManager.isAvailable()) {
            if (SystemInfoRt.isMac && StartupUiUtil.INSTANCE.isDarkTheme() || SystemInfoRt.isWindows) {
                WindowRoundedCornersManager.setRoundedCorners(dialog2.getWindow(), JBUI.CurrentTheme.Popup.borderColor((boolean)true));
                dialog2.getRootPane().setBorder((Border)PopupBorder.Factory.createEmpty());
            } else {
                WindowRoundedCornersManager.setRoundedCorners(dialog2.getWindow());
            }
        }
    }

    public static boolean isAvailable() {
        if (!JBR.isRoundedCornersManagerSupported()) {
            return false;
        }
        if (!ExperimentalUI.isNewUI() || !Registry.is((String)"ide.popup.rounded.corners", (boolean)true)) {
            return false;
        }
        if (SystemInfoRt.isWindows) {
            Long buildNumber = SystemInfo.getWinBuildNumber();
            return buildNumber != null && buildNumber >= 22000L;
        }
        return true;
    }

    public static void setRoundedCorners(@NotNull Window window) {
        if (window == null) {
            WindowRoundedCornersManager.$$$reportNull$$$0(1);
        }
        WindowRoundedCornersManager.setRoundedCorners(window, null);
    }

    public static void setRoundedCorners(@NotNull Window window, @Nullable Object params) {
        block15: {
            block24: {
                PopupCornerType cornerType;
                Object[] values;
                block26: {
                    block25: {
                        Object object;
                        block23: {
                            block22: {
                                block21: {
                                    block13: {
                                        block18: {
                                            PopupCornerType cornerType2;
                                            Object[] values2;
                                            block20: {
                                                block19: {
                                                    Object object2;
                                                    block17: {
                                                        block16: {
                                                            block14: {
                                                                if (window == null) {
                                                                    WindowRoundedCornersManager.$$$reportNull$$$0(2);
                                                                }
                                                                if (!SystemInfoRt.isMac) break block13;
                                                                if (params != null) break block14;
                                                                params = Float.valueOf(IdeaPopupMenuUI.CORNER_RADIUS.getFloat());
                                                                break block15;
                                                            }
                                                            if (!(params instanceof PopupCornerType)) break block16;
                                                            PopupCornerType cornerType3 = (PopupCornerType)params;
                                                            if (cornerType3 == PopupCornerType.None) {
                                                                return;
                                                            }
                                                            JBValue radius = cornerType3 == PopupCornerType.RoundedTooltip ? JBUI.CurrentTheme.Tooltip.CORNER_RADIUS : IdeaPopupMenuUI.CORNER_RADIUS;
                                                            params = Float.valueOf(radius.getFloat());
                                                            break block15;
                                                        }
                                                        if (!(params instanceof Color)) break block17;
                                                        params = new Object[]{Float.valueOf(IdeaPopupMenuUI.CORNER_RADIUS.getFloat()), 1, params};
                                                        break block15;
                                                    }
                                                    if (!(params instanceof Object[])) break block18;
                                                    values2 = params;
                                                    if (values2.length != 2 || !((object2 = values2[0]) instanceof PopupCornerType)) break block19;
                                                    cornerType2 = (PopupCornerType)object2;
                                                    if (values2[1] instanceof Color) break block20;
                                                }
                                                return;
                                            }
                                            JBValue radius = cornerType2 == PopupCornerType.RoundedTooltip ? JBUI.CurrentTheme.Tooltip.CORNER_RADIUS : IdeaPopupMenuUI.CORNER_RADIUS;
                                            params = new Object[]{Float.valueOf(radius.getFloat()), 1, values2[1]};
                                            break block15;
                                        }
                                        if (!(params instanceof Float)) {
                                            return;
                                        }
                                        break block15;
                                    }
                                    if (!SystemInfo.isWindows && !StartupUiUtil.isWaylandToolkit()) break block15;
                                    if (params != null) break block21;
                                    params = WindowRoundedCornersManager.defaultCornerRadiusString();
                                    break block15;
                                }
                                if (!(params instanceof PopupCornerType)) break block22;
                                PopupCornerType cornerType4 = (PopupCornerType)params;
                                if (cornerType4 == PopupCornerType.None) {
                                    return;
                                }
                                params = cornerType4 == PopupCornerType.RoundedTooltip ? "small" : WindowRoundedCornersManager.defaultCornerRadiusString();
                                break block15;
                            }
                            if (!(params instanceof Color)) break block23;
                            params = new Object[]{WindowRoundedCornersManager.defaultCornerRadiusString(), params};
                            break block15;
                        }
                        if (!(params instanceof Object[])) break block24;
                        values = params;
                        if (values.length != 2 || !((object = values[0]) instanceof PopupCornerType)) break block25;
                        cornerType = (PopupCornerType)object;
                        if (values[1] instanceof Color) break block26;
                    }
                    return;
                }
                params = new Object[]{cornerType == PopupCornerType.RoundedTooltip ? "small" : WindowRoundedCornersManager.defaultCornerRadiusString(), values[1]};
                break block15;
            }
            if (!(params instanceof String)) {
                return;
            }
        }
        JBR.getRoundedCornersManager().setRoundedCorners(window, (Object)params);
    }

    @NotNull
    private static String defaultCornerRadiusString() {
        return StartupUiUtil.isWaylandToolkit() ? "small" : "full";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/WindowRoundedCornersManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setRoundedCorners";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

