/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.colorpicker.HexColorDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/colorpicker/ColorDocument;", "Ljavax/swing/text/PlainDocument;", "src", "Ljavax/swing/JTextField;", "<init>", "(Ljavax/swing/JTextField;)V", "getSrc$intellij_platform_ide_impl", "()Ljavax/swing/JTextField;", "insertString", "", "offs", "", "str", "", "a", "Ljavax/swing/text/AttributeSet;", "isLegalCharacter", "", "c", "", "isLegalValue", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nColorValuePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorValuePanel.kt\ncom/intellij/ui/colorpicker/ColorDocument\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,650:1\n3991#2:651\n4514#2,2:652\n1563#3:654\n1634#3,3:655\n*S KotlinDebug\n*F\n+ 1 ColorValuePanel.kt\ncom/intellij/ui/colorpicker/ColorDocument\n*L\n566#1:651\n566#1:652,2\n567#1:654\n567#1:655,3\n*E\n"})
abstract class ColorDocument
extends PlainDocument {
    @NotNull
    private final JTextField src;

    public ColorDocument(@NotNull JTextField src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.src = src;
    }

    @NotNull
    public final JTextField getSrc$intellij_platform_ide_impl() {
        return this.src;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void insertString(int offs, @NotNull String str, @Nullable AttributeSet a) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        char[] cArray = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] source = cArray;
        int selected = this.src.getSelectionEnd() - this.src.getSelectionStart();
        int newLen = this.src.getText().length() - selected + str.length();
        if (this instanceof HexColorDocument && selected == 0 && ColorUtil.fromHex((String)str, null) != null) {
            super.remove(0, this.src.getText().length());
            HexColorDocument hexColorDocument = (HexColorDocument)this;
            String string = StringUtil.trimStart((String)str, (String)"#");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStart(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            super.insertString(0, string3, a);
            return;
        }
        if (newLen > this.src.getColumns()) {
            return;
        }
        char[] cArray2 = source;
        boolean $i$f$filter = false;
        void var10_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (char element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!this.isLegalCharacter((char)it)) continue;
            destination$iv$iv.add(Character.valueOf(element$iv$iv));
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            char element$iv$iv;
            element$iv$iv = ((Character)item$iv$iv).charValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(Character.toUpperCase((char)it)));
        }
        String charsToInsert = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String string = new StringBuilder(this.src.getText()).insert(offs, charsToInsert).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String res = string;
        if (!this.isLegalValue(res)) {
            return;
        }
        super.insertString(offs, charsToInsert, a);
    }

    public abstract boolean isLegalCharacter(char var1);

    public abstract boolean isLegalValue(@NotNull String var1);
}

