/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.ColorValuePanelKt;
import com.intellij.ui.colorpicker.DigitColorDocument;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/colorpicker/ColorValueField;", "Ljavax/swing/JTextField;", "hex", "", "showAlpha", "<init>", "(ZZ)V", "increaseValue", "", "diff", "", "isFocusable", "colorValue", "getColorValue", "()I", "intellij.platform.ide.impl"})
public final class ColorValueField
extends JTextField {
    private final boolean hex;
    private final boolean showAlpha;

    public ColorValueField(boolean hex, boolean showAlpha) {
        super(ColorValuePanelKt.access$fieldLength(hex, showAlpha));
        this.hex = hex;
        this.showAlpha = showAlpha;
        this.setHorizontalAlignment(0);
        this.setEnabled(true);
        this.setEditable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                this.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                Document document2 = this.getDocument();
                if (document2 == null) {
                    return;
                }
                int size2 = document2.getLength();
                this.setSelectionStart(size2);
                this.setSelectionEnd(size2);
            }
        });
        this.addMouseWheelListener(arg_0 -> ColorValueField._init_$lambda$0(this, arg_0));
        if (!this.hex) {
            InputMap $this$_init__u24lambda_u241 = this.getInputMap(0);
            boolean bl = false;
            $this$_init__u24lambda_u241.put(KeyStroke.getKeyStroke(38, 0), "up");
            $this$_init__u24lambda_u241.put(KeyStroke.getKeyStroke(38, 64), "up_fast");
            $this$_init__u24lambda_u241.put(KeyStroke.getKeyStroke(40, 0), "down");
            $this$_init__u24lambda_u241.put(KeyStroke.getKeyStroke(40, 64), "down_fast");
            ActionMap $this$_init__u24lambda_u242 = this.getActionMap();
            boolean bl2 = false;
            $this$_init__u24lambda_u242.put("up", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, 1);
                }
            });
            $this$_init__u24lambda_u242.put("up_fast", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, 10);
                }
            });
            $this$_init__u24lambda_u242.put("down", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, -1);
                }
            });
            $this$_init__u24lambda_u242.put("down_fast", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, -10);
                }
            });
        }
    }

    public /* synthetic */ ColorValueField(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    private final void increaseValue(int diff) {
        boolean bl;
        boolean bl2 = bl = !this.hex;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Document document2 = this.getDocument();
        Intrinsics.checkNotNull((Object)document2, (String)"null cannot be cast to non-null type com.intellij.ui.colorpicker.DigitColorDocument");
        DigitColorDocument doc = (DigitColorDocument)document2;
        String string = doc.getText(0, doc.getLength());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int newValue = Integer.parseInt(string) + diff;
        int valueInRange = Math.max(doc.getValueRange().getStart(), Math.min(newValue, doc.getValueRange().getEndInclusive()));
        this.setText(String.valueOf(valueInRange));
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public final int getColorValue() {
        String rawText = this.getText();
        Intrinsics.checkNotNull((Object)rawText);
        return StringsKt.isBlank((CharSequence)rawText) ? 0 : Integer.parseInt(rawText, this.hex ? 16 : 10);
    }

    private static final void _init_$lambda$0(ColorValueField this$0, MouseWheelEvent e) {
        this$0.increaseValue((int)(-e.getPreciseWheelRotation()));
    }

    public ColorValueField() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ void access$increaseValue(ColorValueField $this, int diff) {
        $this.increaseValue(diff);
    }
}

