/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBViewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nullable;

public class GradientViewport
extends JBViewport {
    private final Insets myInsets;
    private final boolean myAlways;

    public GradientViewport(Component view2, Insets insets, boolean forScrollBars) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.myAlways = forScrollBars;
        this.setView(view2);
    }

    protected Component getHeader() {
        return null;
    }

    @Nullable
    protected Color getViewColor() {
        Component view2 = this.getView();
        return view2 == null ? null : view2.getBackground();
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintGradient(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintGradient(Graphics g) {
        g = g.create();
        try {
            Color background = this.getViewColor();
            Component header = this.getHeader();
            if (header != null) {
                header.setBounds(0, 0, this.getWidth(), header.getPreferredSize().height);
                if (background != null) {
                    g.setColor(background);
                    g.fillRect(header.getX(), header.getY(), header.getWidth(), header.getHeight());
                }
            }
            if (g instanceof Graphics2D && background != null && !Registry.is((String)"ui.no.bangs.and.whistles")) {
                this.paintGradient((Graphics2D)g, background, 0, header == null ? 0 : header.getHeight());
            }
            if (header != null) {
                header.paint(g);
            }
        }
        finally {
            g.dispose();
        }
    }

    public void scrollRectToVisible(Rectangle bounds) {
        int h;
        Component header = this.getHeader();
        if (header != null && bounds.y < (h = header.getPreferredSize().height)) {
            bounds = new Rectangle(bounds);
            bounds.y -= h;
            bounds.height += h;
        }
        super.scrollRectToVisible(bounds);
    }

    private void paintGradient(Graphics2D g2d, Color background, int x1, int y1) {
        Component view2 = this.getView();
        if (background != null && view2 != null) {
            Container parent;
            int y3;
            int x3;
            int x2 = x1;
            int x4 = x3 = this.getWidth() - x2;
            int y2 = y1;
            int y4 = y3 = this.getHeight() - y2;
            if (this.myInsets.left > 0 && view2.getX() < 0) {
                x2 += this.myInsets.left;
            }
            if (this.myInsets.top > 0 && view2.getY() < 0) {
                y2 += this.myInsets.top;
            }
            if (this.myInsets.right > 0 && view2.getX() > this.getWidth() - view2.getWidth()) {
                x3 -= this.myInsets.right;
            }
            if (this.myInsets.bottom > 0 && view2.getY() > this.getHeight() - view2.getHeight()) {
                y3 -= this.myInsets.bottom;
            }
            Container container = parent = this.myAlways ? null : this.getParent();
            if (parent instanceof JScrollPane) {
                JScrollBar hBar;
                JScrollPane pane2 = (JScrollPane)parent;
                JScrollBar vBar = pane2.getVerticalScrollBar();
                if (vBar != null && vBar.isVisible()) {
                    if (vBar.getX() < this.getX()) {
                        x2 = x1;
                    } else {
                        x3 = x4;
                    }
                }
                if ((hBar = pane2.getHorizontalScrollBar()) != null && hBar.isVisible()) {
                    if (hBar.getY() < this.getY()) {
                        y2 = y1;
                    } else {
                        y3 = y4;
                    }
                }
            }
            Color transparent = ColorUtil.toAlpha((Color)background, (int)0);
            if (x1 != x2) {
                g2d.setPaint(new GradientPaint(x1, y1, background, x2, y1, transparent));
                g2d.fillPolygon(new int[]{x1, x2, x2, x1}, new int[]{y1, y2, y3, y4}, 4);
            }
            if (x3 != x4) {
                g2d.setPaint(new GradientPaint(x3, y1, transparent, x4, y1, background));
                g2d.fillPolygon(new int[]{x4, x3, x3, x4}, new int[]{y1, y2, y3, y4}, 4);
            }
            if (y1 != y2) {
                g2d.setPaint(new GradientPaint(x1, y1, background, x1, y2, transparent));
                g2d.fillPolygon(new int[]{x1, x2, x3, x4}, new int[]{y1, y2, y2, y1}, 4);
            }
            if (y3 != y4) {
                g2d.setPaint(new GradientPaint(x1, y3, transparent, x1, y4, background));
                g2d.fillPolygon(new int[]{x1, x2, x3, x4}, new int[]{y4, y3, y3, y4}, 4);
            }
        }
    }
}

