/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.Gray;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class LegalNoticeDialog
extends DialogWrapper {
    private final Builder myBuilder;

    public static Builder build(@NlsContexts.DialogTitle @NotNull String title2, @NlsContexts.DialogMessage @NotNull String message) {
        if (title2 == null) {
            LegalNoticeDialog.$$$reportNull$$$0(0);
        }
        if (message == null) {
            LegalNoticeDialog.$$$reportNull$$$0(1);
        }
        return new Builder(title2, message);
    }

    private LegalNoticeDialog(Builder builder) {
        super(builder.project, builder.parent, true, DialogWrapper.IdeModalityType.PROJECT);
        this.myBuilder = builder;
        this.setTitle(builder.title);
        this.setOKButtonText(CommonBundle.message((String)"button.accept", (Object[])new Object[0]));
        this.setCancelButtonText(builder.cancelText != null ? builder.cancelText : CommonBundle.message((String)"button.decline", (Object[])new Object[0]));
        this.init();
        this.pack();
    }

    protected JComponent createCenterPanel() {
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.add((Component)new JBLabel(AllIcons.General.WarningDialog), "North");
        JEditorPane messageArea = new JEditorPane();
        messageArea.setEditorKit(HTMLEditorKitBuilder.simple());
        messageArea.setEditable(false);
        messageArea.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        messageArea.setBorder(new CompoundBorder(BorderFactory.createLineBorder((Color)Gray._200), JBUI.Borders.empty((int)3)));
        messageArea.setText(UIUtil.toHtml((String)this.myBuilder.message));
        JPanel panel2 = new JPanel(new BorderLayout(JBUIScale.scale((int)3), 0));
        panel2.add((Component)iconPanel, "West");
        panel2.add((Component)messageArea, "Center");
        return panel2;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        if (this.myBuilder.customAction != null) {
            actions.add((Action)new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, (String)this.myBuilder.customAction.first, ((Integer)this.myBuilder.customAction.second).intValue()));
        }
        actions.add(this.getCancelAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            LegalNoticeDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/LegalNoticeDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/LegalNoticeDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class Builder {
        @NlsContexts.DialogTitle
        private final String title;
        private final @NlsContexts.DialogMessage String message;
        private Project project;
        private Component parent;
        @NlsContexts.Button
        private String cancelText;
        private Pair<@Nls String, Integer> customAction;

        private Builder(@NlsContexts.DialogTitle String title2, @NlsContexts.DialogMessage String message) {
            this.title = title2;
            this.message = message;
        }

        public Builder withParent(Project project2) {
            this.project = project2;
            return this;
        }

        public Builder withParent(Component parent) {
            this.parent = parent;
            return this;
        }

        public Builder withCancelText(@NotNull @Nls String text2) {
            if (text2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.cancelText = text2;
            return this;
        }

        public Builder withCustomAction(@NotNull @Nls String text2, int exitCode2) {
            if (text2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            assert (exitCode2 >= 2);
            this.customAction = Pair.pair((Object)text2, (Object)exitCode2);
            return this;
        }

        public int show() {
            LegalNoticeDialog dialog2 = new LegalNoticeDialog(this);
            dialog2.show();
            return dialog2.getExitCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "text";
            objectArray2[1] = "com/intellij/ui/components/LegalNoticeDialog$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCancelText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCustomAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

