/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorCssFontResolver;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.components.impl.EditorColorsSchemeStyleSheet;
import com.intellij.ui.components.impl.JBHtmlPaneImageResolver;
import com.intellij.ui.components.impl.JBHtmlPaneInputTranspiler;
import com.intellij.ui.components.impl.JBHtmlPaneStyleSheetRulesProvider;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.html.UtilsKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.ComponentView;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneImplService;", "Lcom/intellij/ui/components/JBHtmlPane$ImplService;", "<init>", "()V", "transpileHtmlPaneInput", "", "Lorg/jetbrains/annotations/Nls;", "text", "jsoupCustomTagSet", "", "getJsoupCustomTagSet", "()Ljava/lang/Object;", "defaultEditorCssFontResolver", "Lcom/intellij/util/ui/CSSFontResolver;", "getDefaultStyleSheet", "Ljavax/swing/text/html/StyleSheet;", "paneBackgroundColor", "Ljava/awt/Color;", "scaleFactor", "", "baseFontSize", "", "configuration", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration;", "getEditorColorsSchemeStyleSheet", "editorColorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "createDefaultImageResolver", "Ljava/util/Dictionary;", "Ljava/net/URL;", "Ljava/awt/Image;", "pane", "Lcom/intellij/ui/components/JBHtmlPane;", "applyCssToView", "", "ensureEditableViewsAreNotFocusable", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nJBHtmlPaneImplService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBHtmlPaneImplService.kt\ncom/intellij/ui/components/impl/JBHtmlPaneImplService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,70:1\n30#2,2:71\n*S KotlinDebug\n*F\n+ 1 JBHtmlPaneImplService.kt\ncom/intellij/ui/components/impl/JBHtmlPaneImplService\n*L\n38#1:71,2\n*E\n"})
public final class JBHtmlPaneImplService
implements JBHtmlPane.ImplService {
    @NotNull
    public String transpileHtmlPaneInput(@Nls @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return JBHtmlPaneInputTranspiler.INSTANCE.transpileHtmlPaneInput(text2);
    }

    @NotNull
    public Object getJsoupCustomTagSet() {
        return JBHtmlPaneInputTranspiler.INSTANCE.getCustomTagSet$intellij_platform_ide_impl();
    }

    @NotNull
    public CSSFontResolver defaultEditorCssFontResolver() {
        EditorCssFontResolver editorCssFontResolver = EditorCssFontResolver.getGlobalInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorCssFontResolver, (String)"getGlobalInstance(...)");
        return editorCssFontResolver;
    }

    @NotNull
    public StyleSheet getDefaultStyleSheet(@NotNull Color paneBackgroundColor, float scaleFactor, int baseFontSize, @NotNull JBHtmlPaneStyleConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)paneBackgroundColor, (String)"paneBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<JBHtmlPaneStyleSheetRulesProvider> serviceClass$iv = JBHtmlPaneStyleSheetRulesProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((JBHtmlPaneStyleSheetRulesProvider)object).getStyleSheet(paneBackgroundColor, scaleFactor, baseFontSize, configuration);
    }

    @NotNull
    public StyleSheet getEditorColorsSchemeStyleSheet(@NotNull EditorColorsScheme editorColorsScheme) {
        Intrinsics.checkNotNullParameter((Object)editorColorsScheme, (String)"editorColorsScheme");
        return new EditorColorsSchemeStyleSheet(editorColorsScheme);
    }

    @NotNull
    public Dictionary<URL, Image> createDefaultImageResolver(@NotNull JBHtmlPane pane2) {
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        return new JBHtmlPaneImageResolver((Component)pane2, null);
    }

    public void applyCssToView(@NotNull JBHtmlPane pane2) {
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        View view2 = pane2.getUI().getRootView((JTextComponent)pane2);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        UtilsKt.reapplyCss((View)view2);
    }

    public void ensureEditableViewsAreNotFocusable(@NotNull JBHtmlPane pane2) {
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        View view2 = pane2.getUI().getRootView((JTextComponent)pane2);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        UtilsKt.visitViews((View)view2, JBHtmlPaneImplService::ensureEditableViewsAreNotFocusable$lambda$0);
    }

    private static final Unit ensureEditableViewsAreNotFocusable$lambda$0(View childView) {
        Intrinsics.checkNotNullParameter((Object)childView, (String)"childView");
        if (childView instanceof ComponentView) {
            Object[] it = childView.getClass().getName();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = StringsKt.startsWith$default((String)it, (String)"javax.swing.text.html.", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)it, (String)"html.EditableView", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"html.HiddenTagView", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"html.CommentView", (boolean)false, (int)2, null));
            if (bl2) {
                it = new Component[]{((ComponentView)childView).getComponent()};
                List components = CollectionsKt.mutableListOf((Object[])it);
                while (!((Collection)components).isEmpty()) {
                    Component component2;
                    Component component3 = component2 = (Component)components.removeLast();
                    if (component3 != null) {
                        component3.setFocusable(false);
                    }
                    if (!(component2 instanceof JComponent)) continue;
                    Collection collection = components;
                    Component[] componentArray = ((JComponent)component2).getComponents();
                    Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                    CollectionsKt.addAll((Collection)collection, (Object[])componentArray);
                }
            }
        }
        return Unit.INSTANCE;
    }
}

