/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.Nullable;

public final class ContentManagerUtil {
    private ContentManagerUtil() {
    }

    @Nullable
    public static ContentManager getContentManagerFromContext(DataContext dataContext2, boolean requiresVisibleToolWindow) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return null;
        }
        ToolWindow toolWindow2 = (ToolWindow)JBIterable.of((Object[])((ToolWindow[])PlatformDataKeys.LAST_ACTIVE_TOOL_WINDOWS.getData(dataContext2))).first();
        if (requiresVisibleToolWindow && (toolWindow2 == null || !toolWindow2.isVisible())) {
            return null;
        }
        ContentManager fromToolWindow = toolWindow2 != null ? toolWindow2.getContentManagerIfCreated() : null;
        ContentManager fromContext = (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData(dataContext2);
        return fromContext == null ? fromToolWindow : fromContext;
    }

    public static void cleanupContents(Content notToRemove, Project project2, String contentName) {
        MessageView messageView = MessageView.getInstance(project2);
        for (Content content2 : messageView.getContentManager().getContents()) {
            if (content2.isPinned() || !contentName.equals(content2.getDisplayName()) || content2 == notToRemove || !messageView.getContentManager().removeContent(content2, true)) continue;
            content2.release();
        }
    }
}

