/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.custom.options;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.custom.options.CustomContentLayoutOption;
import com.intellij.ui.content.custom.options.CustomContentLayoutOptions;
import com.intellij.ui.content.custom.options.PersistentContentCustomLayoutOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b'\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\u0006\u0010\u000f\u001a\u00020\rJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$J\b\u0010\u0013\u001a\u00020\u0005H$J\u0012\u0010\u0014\u001a\f0\u0005\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\u0015\u0010\u0018\u001a\u00020\t2\u000b\u0010\u0019\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001aH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0002J\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOptions;", "Lcom/intellij/ui/content/custom/options/CustomContentLayoutOptions;", "content", "Lcom/intellij/ui/content/Content;", "selectedOptionKey", "", "<init>", "(Lcom/intellij/ui/content/Content;Ljava/lang/String;)V", "select", "", "option", "Lcom/intellij/ui/content/custom/options/CustomContentLayoutOption;", "isSelected", "", "restore", "isContentVisible", "getCurrentOption", "Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOption;", "doSelect", "getDefaultOptionKey", "getCurrentOptionKey", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/annotations/NonNls;", "getDefaultOption", "saveOption", "optionKey", "Lcom/intellij/openapi/util/NlsSafe;", "getPersistentOptions", "", "onHide", "getDisplayName", "isHidden", "isHideOptionVisible", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPersistentContentCustomLayoutOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentContentCustomLayoutOptions.kt\ncom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,88:1\n230#2,2:89\n230#2,2:91\n4225#3,11:93\n*S KotlinDebug\n*F\n+ 1 PersistentContentCustomLayoutOptions.kt\ncom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOptions\n*L\n42#1:89,2\n50#1:91,2\n56#1:93,11\n*E\n"})
public abstract class PersistentContentCustomLayoutOptions
implements CustomContentLayoutOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Content content;
    @NotNull
    private final String selectedOptionKey;
    @NotNull
    public static final String HIDE_OPTION_KEY = "Hidden";

    public PersistentContentCustomLayoutOptions(@NotNull Content content2, @NotNull String selectedOptionKey) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)selectedOptionKey, (String)"selectedOptionKey");
        this.content = content2;
        this.selectedOptionKey = selectedOptionKey;
    }

    @Override
    public void select(@NotNull CustomContentLayoutOption option2) {
        Intrinsics.checkNotNullParameter((Object)option2, (String)"option");
        if ((option2 instanceof PersistentContentCustomLayoutOption ? (PersistentContentCustomLayoutOption)option2 : null) == null) {
            throw new IllegalStateException("Option is not a " + PersistentContentCustomLayoutOption.class.getName());
        }
        this.doSelect(option2);
        this.saveOption(((PersistentContentCustomLayoutOption)option2).getOptionKey());
    }

    @Override
    public boolean isSelected(@NotNull CustomContentLayoutOption option2) {
        Intrinsics.checkNotNullParameter((Object)option2, (String)"option");
        return option2.isSelected();
    }

    @Override
    public void restore() {
        PersistentContentCustomLayoutOption defaultOption = this.getDefaultOption();
        if (!defaultOption.isSelected()) {
            this.select(defaultOption);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isContentVisible() {
        if (!this.content.isValid()) return false;
        ContentManager contentManager = this.content.getManager();
        if (contentManager == null) return false;
        int n = contentManager.getIndexOfContent(this.content);
        if (n == -1) return false;
        return true;
    }

    @Nullable
    public final PersistentContentCustomLayoutOption getCurrentOption() {
        Object element$iv2;
        block2: {
            String currentOptionKey = this.getCurrentOptionKey();
            if (Intrinsics.areEqual((Object)currentOptionKey, (Object)HIDE_OPTION_KEY)) {
                return null;
            }
            Iterable $this$first$iv = this.getPersistentOptions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PersistentContentCustomLayoutOption it = (PersistentContentCustomLayoutOption)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOptionKey(), (Object)this.getCurrentOptionKey())) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (PersistentContentCustomLayoutOption)element$iv2;
    }

    protected abstract void doSelect(@NotNull CustomContentLayoutOption var1);

    @NotNull
    protected abstract String getDefaultOptionKey();

    private final String getCurrentOptionKey() {
        String string = PropertiesComponent.getInstance().getValue(this.selectedOptionKey);
        if (string == null) {
            string = this.getDefaultOptionKey();
        }
        return string;
    }

    private final PersistentContentCustomLayoutOption getDefaultOption() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.getPersistentOptions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PersistentContentCustomLayoutOption it = (PersistentContentCustomLayoutOption)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOptionKey(), (Object)this.getDefaultOptionKey())) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (PersistentContentCustomLayoutOption)element$iv2;
    }

    private final void saveOption(String optionKey) {
        PropertiesComponent.getInstance().setValue(this.selectedOptionKey, optionKey);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PersistentContentCustomLayoutOption> getPersistentOptions() {
        void $this$filterIsInstanceTo$iv$iv;
        CustomContentLayoutOption[] customContentLayoutOptionArray = this.getAvailableOptions();
        Intrinsics.checkNotNullExpressionValue((Object)customContentLayoutOptionArray, (String)"getAvailableOptions(...)");
        Object[] $this$filterIsInstance$iv = customContentLayoutOptionArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PersistentContentCustomLayoutOption)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void onHide() {
        this.saveOption(HIDE_OPTION_KEY);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.content.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    @Override
    public boolean isHidden() {
        return this.getCurrentOption() == null;
    }

    @Override
    public boolean isHideOptionVisible() {
        if (this.isHidden()) {
            return true;
        }
        ContentManager contentManager = this.content.getManager();
        if (contentManager == null) {
            return false;
        }
        ContentManager contentManager2 = contentManager;
        return contentManager2.getContents().length > 1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOptions$Companion;", "", "<init>", "()V", "HIDE_OPTION_KEY", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

