/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.impl;

import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.impl.CellImpl;
import com.intellij.ui.dsl.builder.impl.GroupBinding;
import com.intellij.ui.dsl.builder.impl.PanelImpl;
import com.intellij.ui.dsl.builder.impl.RowsRangeImpl;
import com.intellij.ui.layout.ComponentPredicate;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0013\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u001a\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0016J*\u0010\u001b\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 H\u0016J\"\u0010!\u001a\u00020\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\rJ\u0006\u0010%\u001a\u00020\"J\u0014\u0010&\u001a\u00020\"2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\b\u0010'\u001a\u00020\"H\u0002R$\u0010\t\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ui/dsl/builder/impl/ButtonsGroupImpl;", "Lcom/intellij/ui/dsl/builder/impl/RowsRangeImpl;", "Lcom/intellij/ui/dsl/builder/ButtonsGroup;", "panel", "Lcom/intellij/ui/dsl/builder/impl/PanelImpl;", "startIndex", "", "<init>", "(Lcom/intellij/ui/dsl/builder/impl/PanelImpl;I)V", "radioButtons", "", "Lcom/intellij/ui/dsl/builder/impl/CellImpl;", "Ljavax/swing/JRadioButton;", "", "groupBinding", "Lcom/intellij/ui/dsl/builder/impl/GroupBinding;", "visible", "isVisible", "", "visibleIf", "predicate", "Lcom/intellij/ui/layout/ComponentPredicate;", "property", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "enabled", "isEnabled", "enabledIf", "bind", "T", "prop", "Lcom/intellij/ui/dsl/builder/MutableProperty;", "type", "Ljava/lang/Class;", "add", "", "cell", "value", "postInit", "postInitBound", "postInitUnbound", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ButtonsGroupImpl
extends RowsRangeImpl
implements ButtonsGroup {
    @NotNull
    private final Map<CellImpl<? extends JRadioButton>, Object> radioButtons;
    @Nullable
    private GroupBinding<?> groupBinding;

    public ButtonsGroupImpl(@NotNull PanelImpl panel2, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        super(panel2, startIndex);
        this.radioButtons = new LinkedHashMap();
    }

    @NotNull
    public ButtonsGroup visible(boolean isVisible) {
        super.visible(isVisible);
        return this;
    }

    @NotNull
    public ButtonsGroup visibleIf(@NotNull ComponentPredicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        super.visibleIf(predicate);
        return this;
    }

    @NotNull
    public ButtonsGroup visibleIf(@NotNull ObservableProperty<Boolean> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.visibleIf(ComponentPredicate.Companion.fromObservableProperty$default((ComponentPredicate.Companion)ComponentPredicate.Companion, property, null, (int)2, null));
    }

    @NotNull
    public ButtonsGroup enabled(boolean isEnabled) {
        super.enabled(isEnabled);
        return this;
    }

    @NotNull
    public ButtonsGroup enabledIf(@NotNull ComponentPredicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        super.enabledIf(predicate);
        return this;
    }

    @NotNull
    public ButtonsGroup enabledIf(@NotNull ObservableProperty<Boolean> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.enabledIf(ComponentPredicate.Companion.fromObservableProperty$default((ComponentPredicate.Companion)ComponentPredicate.Companion, property, null, (int)2, null));
    }

    @NotNull
    public <T> ButtonsGroup bind(@NotNull MutableProperty<T> prop, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(prop, (String)"prop");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (this.groupBinding != null) {
            throw new UiDslException("The group is bound already", null, 2, null);
        }
        this.groupBinding = new GroupBinding<T>(prop, type);
        return this;
    }

    public final void add(@NotNull CellImpl<? extends JRadioButton> cell, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        this.radioButtons.put(cell, value);
    }

    public static /* synthetic */ void add$default(ButtonsGroupImpl buttonsGroupImpl, CellImpl cellImpl, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        buttonsGroupImpl.add(cellImpl, object);
    }

    public final void postInit() {
        if (this.groupBinding == null) {
            this.postInitUnbound();
        } else {
            GroupBinding<?> groupBinding = this.groupBinding;
            Intrinsics.checkNotNull(groupBinding);
            this.postInitBound(groupBinding);
        }
    }

    private final void postInitBound(GroupBinding<?> groupBinding) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Map.Entry<CellImpl<? extends JRadioButton>, Object> entry : this.radioButtons.entrySet()) {
            CellImpl<? extends JRadioButton> cell = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                throw new UiDslException("Radio button '" + ((AbstractButton)cell.getComponent()).getText() + "' is used without value for binding", null, 2, null);
            }
            groupBinding.validate(value);
            buttonGroup.add(cell.getComponent());
            cell.getOnChangeManager().applyBinding((Function0<Unit>)((Function0)() -> ButtonsGroupImpl.postInitBound$lambda$0(cell, groupBinding, value)));
            cell.onApply(() -> ButtonsGroupImpl.postInitBound$lambda$1(cell, groupBinding, value));
            cell.onReset(() -> ButtonsGroupImpl.postInitBound$lambda$2(cell, groupBinding, value));
            cell.onIsModified(() -> ButtonsGroupImpl.postInitBound$lambda$3(cell, groupBinding, value));
        }
    }

    private final void postInitUnbound() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Map.Entry<CellImpl<? extends JRadioButton>, Object> entry : this.radioButtons.entrySet()) {
            CellImpl<? extends JRadioButton> cell = entry.getKey();
            Object value = entry.getValue();
            if (value != null) {
                throw new UiDslException("Radio button '" + ((AbstractButton)cell.getComponent()).getText() + "' is used without ButtonsGroup.bind", null, 2, null);
            }
            buttonGroup.add(cell.getComponent());
        }
    }

    private static final Unit postInitBound$lambda$0(CellImpl $cell, GroupBinding $groupBinding, Object $value) {
        ((AbstractButton)$cell.getComponent()).setSelected(Intrinsics.areEqual((Object)$groupBinding.getProp().get(), (Object)$value));
        return Unit.INSTANCE;
    }

    private static final Unit postInitBound$lambda$1(CellImpl $cell, GroupBinding $groupBinding, Object $value) {
        if (((AbstractButton)$cell.getComponent()).isSelected()) {
            $groupBinding.set($value);
        }
        return Unit.INSTANCE;
    }

    private static final Unit postInitBound$lambda$2(CellImpl $cell, GroupBinding $groupBinding, Object $value) {
        $cell.getOnChangeManager().applyBinding((Function0<Unit>)((Function0)() -> ButtonsGroupImpl.postInitBound$lambda$2$0($cell, $groupBinding, $value)));
        return Unit.INSTANCE;
    }

    private static final Unit postInitBound$lambda$2$0(CellImpl $cell, GroupBinding $groupBinding, Object $value) {
        ((AbstractButton)$cell.getComponent()).setSelected(Intrinsics.areEqual((Object)$groupBinding.getProp().get(), (Object)$value));
        return Unit.INSTANCE;
    }

    private static final boolean postInitBound$lambda$3(CellImpl $cell, GroupBinding $groupBinding, Object $value) {
        return ((AbstractButton)$cell.getComponent()).isSelected() != Intrinsics.areEqual((Object)$groupBinding.getProp().get(), (Object)$value);
    }
}

