/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.filterField;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.filterField.FilterCompletionPopupType;
import com.intellij.ui.filterField.FilterSearchPopup;
import com.intellij.ui.filterField.FilterSearchTextField;
import com.intellij.ui.filterField.SearchPopupCallback;
import com.intellij.ui.filterField.SearchQueryParserBase;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.event.KeyEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H$J\u0018\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!2\b\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010#\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!2\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010*\u001a\u00020\u0016H%J\b\u0010+\u001a\u00020\u000fH\u0002J\u0006\u0010.\u001a\u00020\u000fJ\u001a\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\u001d2\u0006\u00102\u001a\u000203R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010,\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00065"}, d2={"Lcom/intellij/ui/filterField/SearchPopupControllerBase;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "searchTextField", "Lcom/intellij/ui/filterField/FilterSearchTextField;", "list", "Ljavax/swing/JList;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ui/filterField/FilterSearchTextField;Ljavax/swing/JList;)V", "searchPopup", "Lcom/intellij/ui/filterField/FilterSearchPopup;", "handleShowPopup", "", "caretPosition", "", "getCaretPosition", "()I", "getAttributes", "", "", "showAttributesPopup", "namePrefix", "handleShowAttributeValuesPopup", "name", "valuePrefix", "updatePopupOrCreate", "", "type", "Lcom/intellij/ui/filterField/FilterCompletionPopupType;", "model", "Lcom/intellij/ui/CollectionListModel;", "prefix", "createPopup", "createAndShow", "async", "callback", "Lcom/intellij/ui/filterField/SearchPopupCallback;", "noPrefixSearchValues", "getCompletionValues", "attribute", "handleShowPopupForQuery", "isPopupShow", "()Z", "hidePopup", "appendSearchText", "originalValue", "handleEnter", "event", "Ljava/awt/event/KeyEvent;", "handleUpDown", "intellij.platform.ide.impl"})
public abstract class SearchPopupControllerBase {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final FilterSearchTextField searchTextField;
    @NotNull
    private final JList<?> list;
    @Nullable
    private FilterSearchPopup searchPopup;

    public SearchPopupControllerBase(@NotNull Project project2, @NotNull CoroutineScope coroutineScope, @NotNull FilterSearchTextField searchTextField, @NotNull JList<?> list2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)((Object)searchTextField), (String)"searchTextField");
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.searchTextField = searchTextField;
        this.list = list2;
    }

    public final void handleShowPopup() {
        String query = this.searchTextField.getText();
        int length = query.length();
        int position = this.getCaretPosition();
        if (position < length && query.charAt(position) != ' ' && query.charAt(position) != ',') {
            this.handleShowPopupForQuery();
            return;
        }
        Intrinsics.checkNotNull((Object)query);
        SearchQueryParserBase.QueryCompletionPosition completionPosition = SearchQueryParserBase.Companion.parseAttributeInQuery(query, position);
        if (completionPosition.getAttributeValue() == null) {
            this.showAttributesPopup(completionPosition.getAttributeName(), completionPosition.getStartPosition());
        } else {
            this.handleShowAttributeValuesPopup(completionPosition.getAttributeName(), completionPosition.getAttributeValue(), completionPosition.getStartPosition());
        }
    }

    private final int getCaretPosition() {
        return this.searchTextField.getTextEditor().getCaretPosition();
    }

    @NotNull
    protected abstract List<String> getAttributes();

    public final void showAttributesPopup(@Nullable String namePrefix, int caretPosition) {
        boolean async2;
        CollectionListModel model2 = new CollectionListModel(this.getAttributes());
        if (this.noPrefixSearchValues((CollectionListModel<String>)model2, namePrefix)) {
            return;
        }
        boolean bl = async2 = this.searchPopup != null;
        if (this.updatePopupOrCreate(FilterCompletionPopupType.ATTRIBUTE_NAME, (CollectionListModel<String>)model2, namePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(async2, new SearchPopupCallback(namePrefix, this){
            final /* synthetic */ SearchPopupControllerBase this$0;
            {
                this.this$0 = $receiver;
                super($namePrefix);
            }

            public void accept(String value) {
                if (value == null) {
                    return;
                }
                SearchPopupControllerBase.access$appendSearchText(this.this$0, value, this.getPrefix());
                SearchPopupControllerBase.access$handleShowAttributeValuesPopup(this.this$0, value, null, SearchPopupControllerBase.access$getSearchTextField$p(this.this$0).getTextEditor().getCaretPosition());
            }
        });
    }

    private final void handleShowAttributeValuesPopup(String name2, String valuePrefix, int caretPosition) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, name2, valuePrefix, caretPosition, null){
            Object L$0;
            int label;
            final /* synthetic */ SearchPopupControllerBase this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $valuePrefix;
            final /* synthetic */ int $caretPosition;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$valuePrefix = $valuePrefix;
                this.$caretPosition = $caretPosition;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.smartReadAction((Project)SearchPopupControllerBase.access$getProject$p(this.this$0), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.ui.filterField.SearchPopupControllerBase java.lang.String ), ()Ljava/util/List;)((SearchPopupControllerBase)this.this$0, (String)this.$name), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        values = (List)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)values);
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<String>)values, this.this$0, this.$valuePrefix, this.$caretPosition, null){
                            int label;
                            final /* synthetic */ List<String> $values;
                            final /* synthetic */ SearchPopupControllerBase this$0;
                            final /* synthetic */ String $valuePrefix;
                            final /* synthetic */ int $caretPosition;
                            {
                                this.$values = $values;
                                this.this$0 = $receiver;
                                this.$valuePrefix = $valuePrefix;
                                this.$caretPosition = $caretPosition;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (this.$values.isEmpty()) {
                                            SearchPopupControllerBase.access$handleShowPopupForQuery(this.this$0);
                                            return Unit.INSTANCE;
                                        }
                                        CollectionListModel model2 = new CollectionListModel(this.$values);
                                        if (SearchPopupControllerBase.access$noPrefixSearchValues(this.this$0, model2, this.$valuePrefix)) {
                                            return Unit.INSTANCE;
                                        }
                                        if (SearchPopupControllerBase.access$updatePopupOrCreate(this.this$0, FilterCompletionPopupType.ATTRIBUTE_VALUE, model2, this.$valuePrefix, this.$caretPosition)) {
                                            return Unit.INSTANCE;
                                        }
                                        SearchPopupControllerBase.access$createAndShow(this.this$0, true, new SearchPopupCallback(this.$valuePrefix, this.this$0){
                                            final /* synthetic */ SearchPopupControllerBase this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super($valuePrefix);
                                            }

                                            public void accept(String value) {
                                                if (value == null) {
                                                    return;
                                                }
                                                SearchPopupControllerBase.access$appendSearchText(this.this$0, SearchQueryParserBase.Companion.wrapAttribute(value), this.getPrefix());
                                                SearchPopupControllerBase.access$handleShowPopupForQuery(this.this$0);
                                            }
                                        });
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        values = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final List invokeSuspend$lambda$0(SearchPopupControllerBase this$0, String $name) {
                return this$0.getCompletionValues($name);
            }
        }), (int)3, null);
    }

    private final boolean updatePopupOrCreate(FilterCompletionPopupType type, CollectionListModel<String> model2, String prefix, int caretPosition) {
        FilterSearchPopup currentPopup = this.searchPopup;
        if (currentPopup != null && currentPopup.getCompletionPlace() == type && currentPopup.isValid()) {
            SearchPopupCallback callback;
            currentPopup.getModel().replaceAll(model2.getItems());
            if (model2.getSize() > 0) {
                JList<String> jList = currentPopup.getList();
                if (jList != null) {
                    jList.setSelectedIndex(0);
                }
            }
            if ((callback = currentPopup.getCallback()) != null) {
                callback.setPrefix(prefix);
            }
            currentPopup.setCaretPosition(caretPosition);
            currentPopup.update();
            return true;
        }
        this.createPopup(type, model2, caretPosition);
        return false;
    }

    private final void createPopup(FilterCompletionPopupType type, CollectionListModel<String> model2, int caretPosition) {
        this.hidePopup();
        this.searchPopup = new FilterSearchPopup(this.searchTextField, new JBPopupListener(this){
            final /* synthetic */ SearchPopupControllerBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SearchPopupControllerBase.access$setSearchPopup$p(this.this$0, null);
            }
        }, type, model2, caretPosition);
    }

    private final void createAndShow(boolean async2, SearchPopupCallback callback) {
        block0: {
            FilterSearchPopup filterSearchPopup = this.searchPopup;
            if (filterSearchPopup == null) break block0;
            filterSearchPopup.createAndShow(callback, async2);
        }
    }

    private final boolean noPrefixSearchValues(CollectionListModel<String> model2, String prefix) {
        CharSequence charSequence = prefix;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        int index = 0;
        while (index < model2.getSize()) {
            String attribute = (String)model2.getElementAt(index);
            if (Intrinsics.areEqual((Object)attribute, (Object)prefix)) {
                this.hidePopup();
                return true;
            }
            if (StringUtil.startsWithIgnoreCase((String)attribute, (String)prefix)) {
                ++index;
                continue;
            }
            model2.remove(index);
        }
        if (model2.isEmpty()) {
            this.handleShowPopupForQuery();
            return true;
        }
        return false;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    protected abstract List<String> getCompletionValues(@NotNull String var1);

    private final void handleShowPopupForQuery() {
        this.hidePopup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPopupShow() {
        if (this.searchPopup == null) return false;
        FilterSearchPopup filterSearchPopup = this.searchPopup;
        Intrinsics.checkNotNull((Object)filterSearchPopup);
        if (!filterSearchPopup.isValid()) return false;
        return true;
    }

    public final void hidePopup() {
        FilterSearchPopup filterSearchPopup = this.searchPopup;
        if (filterSearchPopup != null) {
            filterSearchPopup.hide();
        }
        this.searchPopup = null;
    }

    private final void appendSearchText(String originalValue, String prefix) {
        int n;
        String string;
        Object value = originalValue;
        if (this.getAttributes().contains(value)) {
            value = (String)value + " ";
        }
        String text2 = this.searchTextField.getText();
        String suffix = "";
        int position = this.getCaretPosition();
        if (this.searchPopup != null) {
            FilterSearchPopup filterSearchPopup = this.searchPopup;
            Intrinsics.checkNotNull((Object)filterSearchPopup);
            filterSearchPopup.setSkipCaretEvent(true);
        }
        if (position < text2.length()) {
            string = text2;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string.substring(position);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            suffix = string2;
            string = text2;
            Intrinsics.checkNotNull((Object)string);
            n = 0;
            String string3 = string.substring(n, position);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            text2 = string3;
        }
        if (prefix == null) {
            this.searchTextField.setTextIgnoreEvents(text2 + (String)value + suffix);
        } else if (StringUtil.startsWithIgnoreCase((String)value, (String)prefix) || StringUtil.startsWithIgnoreCase((String)value, (String)("\"" + prefix))) {
            string = text2;
            Intrinsics.checkNotNull((Object)string);
            n = 0;
            int n2 = text2.length() - prefix.length();
            String string4 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            this.searchTextField.setTextIgnoreEvents(string4 + (String)value + suffix);
        } else {
            this.searchTextField.setTextIgnoreEvents(text2 + (String)value + suffix);
        }
        this.searchTextField.getTextEditor().setCaretPosition(this.searchTextField.getText().length() - suffix.length());
    }

    public final boolean handleEnter(@NotNull KeyEvent event) {
        JList<String> popupList;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FilterSearchPopup filterSearchPopup = this.searchPopup;
        JList<String> jList = popupList = filterSearchPopup != null ? filterSearchPopup.getList() : null;
        if (popupList != null && popupList.getSelectedIndex() != -1) {
            popupList.dispatchEvent(event);
            return true;
        }
        return false;
    }

    public final boolean handleUpDown(@NotNull KeyEvent event) {
        JList<String> popupList;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FilterSearchPopup filterSearchPopup = this.searchPopup;
        JList<String> jList = popupList = filterSearchPopup != null ? filterSearchPopup.getList() : null;
        if (popupList != null) {
            if (event.getKeyCode() == 40 && popupList.getSelectedIndex() == -1) {
                popupList.setSelectedIndex(0);
            } else {
                popupList.dispatchEvent(event);
            }
            return true;
        }
        this.list.dispatchEvent(event);
        return true;
    }

    public static final /* synthetic */ void access$appendSearchText(SearchPopupControllerBase $this, String originalValue, String prefix) {
        $this.appendSearchText(originalValue, prefix);
    }

    public static final /* synthetic */ void access$handleShowAttributeValuesPopup(SearchPopupControllerBase $this, String name2, String valuePrefix, int caretPosition) {
        $this.handleShowAttributeValuesPopup(name2, valuePrefix, caretPosition);
    }

    public static final /* synthetic */ FilterSearchTextField access$getSearchTextField$p(SearchPopupControllerBase $this) {
        return $this.searchTextField;
    }

    public static final /* synthetic */ Project access$getProject$p(SearchPopupControllerBase $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$handleShowPopupForQuery(SearchPopupControllerBase $this) {
        $this.handleShowPopupForQuery();
    }

    public static final /* synthetic */ boolean access$noPrefixSearchValues(SearchPopupControllerBase $this, CollectionListModel model2, String prefix) {
        return $this.noPrefixSearchValues((CollectionListModel<String>)model2, prefix);
    }

    public static final /* synthetic */ boolean access$updatePopupOrCreate(SearchPopupControllerBase $this, FilterCompletionPopupType type, CollectionListModel model2, String prefix, int caretPosition) {
        return $this.updatePopupOrCreate(type, (CollectionListModel<String>)model2, prefix, caretPosition);
    }

    public static final /* synthetic */ void access$createAndShow(SearchPopupControllerBase $this, boolean async2, SearchPopupCallback callback) {
        $this.createAndShow(async2, callback);
    }

    public static final /* synthetic */ void access$setSearchPopup$p(SearchPopupControllerBase $this, FilterSearchPopup filterSearchPopup) {
        $this.searchPopup = filterSearchPopup;
    }
}

