/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.layout.migLayout.patched;

import com.intellij.ide.ui.laf.VisualPaddingsProvider;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.layout.migLayout.patched.SwingComponentWrapperKt;
import com.intellij.ui.layout.migLayout.patched.SwingContainerWrapper;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.PlatformDefaults;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\rH\u0016J\b\u0010$\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020\tH\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J(\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020\tH\u0016J\n\u0010/\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\tH\u0016J\u0010\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\tH\u0016J\b\u00104\u001a\u00020\rH\u0016J\b\u00105\u001a\u00020\rH\u0016J\u0013\u00106\u001a\u00020\t2\b\u00107\u001a\u0004\u0018\u000108H\u0096\u0002J\b\u00109\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/ui/layout/migLayout/patched/SwingComponentWrapper;", "Lnet/miginfocom/layout/ComponentWrapper;", "c", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "hasBaseLine", "Lcom/intellij/util/ThreeState;", "isPrefCalled", "", "visualPaddings", "", "getBaseline", "", "width", "height", "getComponent", "getPixelUnitFactor", "", "isHor", "getX", "getY", "getHeight", "getWidth", "getScreenLocationX", "getScreenLocationY", "getMinimumHeight", "sz", "getMinimumWidth", "getPreferredHeight", "getPreferredWidth", "getMaximumHeight", "getMaximumWidth", "getParent", "Lnet/miginfocom/layout/ContainerWrapper;", "getHorizontalScreenDPI", "getVerticalScreenDPI", "getScreenWidth", "getScreenHeight", "hasBaseline", "getLinkId", "", "setBounds", "", "x", "y", "isVisible", "getVisualPadding", "paintDebugOutline", "showVisualPadding", "getComponentType", "disregardScrollPane", "getLayoutHashCode", "hashCode", "equals", "other", "", "getContentBias", "intellij.platform.ide.impl"})
public class SwingComponentWrapper
implements ComponentWrapper {
    @NotNull
    private final JComponent c;
    @NotNull
    private ThreeState hasBaseLine;
    private boolean isPrefCalled;
    @Nullable
    private int[] visualPaddings;

    public SwingComponentWrapper(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.c = c;
        this.hasBaseLine = ThreeState.UNSURE;
    }

    public int getBaseline(int width, int height) {
        int h = height;
        int[] visualPaddings = this.getVisualPadding();
        if (h < 0) {
            h = this.c.getHeight();
        } else if (visualPaddings != null) {
            h = height + visualPaddings[0] + visualPaddings[2];
        }
        int baseLine = this.c.getBaseline(width < 0 ? this.c.getWidth() : width, h);
        if (baseLine != -1 && visualPaddings != null) {
            baseLine -= visualPaddings[0];
        }
        return baseLine;
    }

    @NotNull
    public JComponent getComponent() {
        return this.c;
    }

    public float getPixelUnitFactor(boolean isHor) {
        throw new RuntimeException("Do not use LPX/LPY");
    }

    public int getX() {
        return this.c.getX();
    }

    public int getY() {
        return this.c.getY();
    }

    public int getHeight() {
        return this.c.getHeight();
    }

    public int getWidth() {
        return this.c.getWidth();
    }

    public int getScreenLocationX() {
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, this.c);
        return p.x;
    }

    public int getScreenLocationY() {
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, this.c);
        return p.y;
    }

    public int getMinimumHeight(int sz) {
        if (!this.isPrefCalled) {
            this.c.getPreferredSize();
            this.isPrefCalled = true;
        }
        return this.c.getMinimumSize().height;
    }

    public int getMinimumWidth(int sz) {
        if (!this.isPrefCalled) {
            this.c.getPreferredSize();
            this.isPrefCalled = true;
        }
        return this.c.getMinimumSize().width;
    }

    public int getPreferredHeight(int sz) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && sz != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), sz, 1);
        }
        return this.c.getPreferredSize().height;
    }

    public int getPreferredWidth(int sz) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && sz != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), 1, sz);
        }
        return this.c.getPreferredSize().width;
    }

    public int getMaximumHeight(int sz) {
        return this.c.isMaximumSizeSet() ? this.c.getMaximumSize().height : Integer.MAX_VALUE;
    }

    public int getMaximumWidth(int sz) {
        return this.c.isMaximumSizeSet() ? this.c.getMaximumSize().width : Integer.MAX_VALUE;
    }

    @Nullable
    public ContainerWrapper getParent() {
        Container container = this.c.getParent();
        JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
        if (jComponent == null) {
            return null;
        }
        JComponent p = jComponent;
        return new SwingContainerWrapper(p);
    }

    public int getHorizontalScreenDPI() {
        try {
            return this.c.getToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            return PlatformDefaults.getDefaultDPI();
        }
    }

    public int getVerticalScreenDPI() {
        try {
            return this.c.getToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            return PlatformDefaults.getDefaultDPI();
        }
    }

    public int getScreenWidth() {
        try {
            return this.c.getToolkit().getScreenSize().width;
        }
        catch (HeadlessException ignore) {
            return 1024;
        }
    }

    public int getScreenHeight() {
        try {
            return this.c.getToolkit().getScreenSize().height;
        }
        catch (HeadlessException ignore) {
            return 768;
        }
    }

    public boolean hasBaseline() {
        if (this.hasBaseLine == ThreeState.UNSURE) {
            try {
                this.hasBaseLine = ThreeState.Companion.fromBoolean(this.getBaseline(8192, 8192) > -1);
            }
            catch (Throwable ignore) {
                this.hasBaseLine = ThreeState.NO;
            }
        }
        return this.hasBaseLine.toBoolean();
    }

    @Nullable
    public String getLinkId() {
        return this.c.getName();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.c.setBounds(x, y, width, height);
    }

    public boolean isVisible() {
        return this.c.isVisible();
    }

    @Nullable
    public int[] getVisualPadding() {
        JComponent jComponent;
        int[] nArray = this.visualPaddings;
        if (nArray != null) {
            int[] it = nArray;
            boolean bl = false;
            return it;
        }
        if (this.c instanceof ComponentWithBrowseButton) {
            JComponent jComponent2 = ((ComponentWithBrowseButton)this.c).getChildComponent();
            jComponent = jComponent2;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getChildComponent(...)");
        } else {
            jComponent = this.c;
        }
        JComponent component2 = jComponent;
        Border border = component2.getBorder();
        if (border == null) {
            return null;
        }
        Border border2 = border;
        if (border2 instanceof LineBorder || border2 instanceof TitledBorder) {
            return null;
        }
        Insets insets = border2 instanceof VisualPaddingsProvider ? ((VisualPaddingsProvider)((Object)border2)).getVisualPaddings(this.c) : border2.getBorderInsets(component2);
        if (insets == null) {
            return null;
        }
        Insets paddings = insets;
        if (paddings.top == 0 && paddings.left == 0 && paddings.bottom == 0 && paddings.right == 0) {
            return null;
        }
        int[] nArray2 = new int[]{paddings.top, paddings.left, paddings.bottom, paddings.right};
        this.visualPaddings = nArray2;
        return this.visualPaddings;
    }

    public void paintDebugOutline(boolean showVisualPadding) {
        int[] padding;
        if (!this.c.isShowing()) {
            return;
        }
        Graphics graphics = GraphicsUtil.safelyGetGraphics((Component)this.c);
        Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g = graphics2D;
        g.setPaint(SwingComponentWrapperKt.access$getDB_COMP_OUTLINE$p());
        float[] fArray = new float[]{2.0f, 4.0f};
        g.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, fArray, 0.0f));
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (showVisualPadding && (padding = this.getVisualPadding()) != null) {
            g.setColor(Color.GREEN);
            g.drawRect(padding[1], padding[0], this.getWidth() - 1 - (padding[1] + padding[3]), this.getHeight() - 1 - (padding[0] + padding[2]));
        }
    }

    public int getComponentType(boolean disregardScrollPane) {
        throw new RuntimeException("Should be not called and used");
    }

    public int getLayoutHashCode() {
        int hash;
        block1: {
            Dimension d = this.c.getMaximumSize();
            hash = 0;
            hash = d.width + (d.height << 5);
            d = this.c.getPreferredSize();
            hash += (d.width << 10) + (d.height << 15);
            d = this.c.getMinimumSize();
            hash += (d.width << 20) + (d.height << 25);
            if (this.c.isVisible()) {
                hash += 1324511;
            }
            String string = this.getLinkId();
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            hash += it.hashCode();
        }
        return hash;
    }

    public int hashCode() {
        return this.getComponent().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ComponentWrapper && Intrinsics.areEqual((Object)this.c, (Object)((ComponentWrapper)other).getComponent());
    }

    public int getContentBias() {
        return this.c instanceof JTextArea || this.c instanceof JEditorPane || Intrinsics.areEqual((Object)true, (Object)this.c.getClientProperty("migLayout.dynamicAspectRatio")) ? 0 : -1;
    }
}

