/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.list;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.RoundedCellRenderer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.ui.list.TargetPresentationMainRenderer;
import com.intellij.ui.list.TargetPresentationRenderer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aD\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00020\nH\u0007\u001aN\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0016\u0010\u000b\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0002\u0012\u0006\b\u0001\u0012\u00020\b0\f2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00020\nH\u0007\u001aJ\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0016\u0010\u000b\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0002\u0012\u0006\b\u0001\u0012\u00020\b0\f2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00020\nH\u0007\u001aJ\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0016\u0010\u000b\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0002\u0012\u0006\b\u0001\u0012\u00020\b0\f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00020\u0011H\u0007\u001a*\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0013\"\u0004\b\u0000\u0010\u00022\u0016\u0010\u000b\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0002\u0012\u0006\b\u0001\u0012\u00020\b0\f\u001a\f\u0010\u0014\u001a\u00020\u0004*\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"createTargetPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "T", "title", "", "items", "", "presentations", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "processor", "Ljava/util/function/Consumer;", "presentationProvider", "Ljava/util/function/Function;", "buildTargetPopup", "Lcom/intellij/openapi/ui/popup/IPopupChooserBuilder;", "buildTargetPopupWithMultiSelect", "predicate", "Ljava/util/function/Predicate;", "createTargetPresentationRenderer", "Ljavax/swing/ListCellRenderer;", "speedSearchText", "intellij.platform.ide.impl"})
@JvmName(name="TargetPopup")
@SourceDebugExtension(value={"SMAP\ntargetPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 targetPopup.kt\ncom/intellij/ui/list/TargetPopup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1740#2,3:92\n*S KotlinDebug\n*F\n+ 1 targetPopup.kt\ncom/intellij/ui/list/TargetPopup\n*L\n74#1:92,3\n*E\n"})
public final class TargetPopup {
    @RequiresEdt
    @NotNull
    public static final <T> JBPopup createTargetPopup(@NlsContexts.PopupTitle @NotNull String title2, @NotNull List<? extends T> items2, @NotNull List<? extends TargetPresentation> presentations, @NotNull Consumer<? super T> processor2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(presentations, (String)"presentations");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        return TargetPopup.createTargetPopup(title2, CollectionsKt.zip((Iterable)items2, (Iterable)presentations), arg_0 -> TargetPopup.createTargetPopup$lambda$1(TargetPopup::createTargetPopup$lambda$0, arg_0), arg_0 -> TargetPopup.createTargetPopup$lambda$3(arg_0 -> TargetPopup.createTargetPopup$lambda$2(processor2, arg_0), arg_0));
    }

    @ApiStatus.Internal
    @RequiresEdt
    @NotNull
    public static final <T> JBPopup createTargetPopup(@NlsContexts.PopupTitle @NotNull String title2, @NotNull List<? extends T> items2, @NotNull Function<? super T, ? extends TargetPresentation> presentationProvider, @NotNull Consumer<? super T> processor2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(presentationProvider, (String)"presentationProvider");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        JBPopup jBPopup = TargetPopup.buildTargetPopup(items2, presentationProvider, processor2).setTitle(title2).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        return jBPopup;
    }

    @RequiresEdt
    @NotNull
    public static final <T> IPopupChooserBuilder<T> buildTargetPopup(@NotNull List<? extends T> items2, @NotNull Function<? super T, ? extends TargetPresentation> presentationProvider, @NotNull Consumer<? super T> processor2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(presentationProvider, (String)"presentationProvider");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (!(items2.size() > 1)) {
            boolean bl = false;
            String string = "Attempted to build a target popup with " + items2.size() + " elements";
            throw new IllegalArgumentException(string.toString());
        }
        return TargetPopup.buildTargetPopupWithMultiSelect(items2, presentationProvider, arg_0 -> TargetPopup.buildTargetPopup$lambda$1(processor2, arg_0));
    }

    @RequiresEdt
    @NotNull
    public static final <T> IPopupChooserBuilder<T> buildTargetPopupWithMultiSelect(@NotNull List<? extends T> items2, @NotNull Function<? super T, ? extends TargetPresentation> presentationProvider, @NotNull Predicate<? super T> predicate) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(presentationProvider, (String)"presentationProvider");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        IPopupChooserBuilder iPopupChooserBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder(items2).setRenderer((ListCellRenderer)new RoundedCellRenderer(TargetPopup.createTargetPresentationRenderer(presentationProvider), false, 2, null)).setFont(EditorUtil.getEditorFont()).withHintUpdateSupply().setNamerForFiltering(arg_0 -> TargetPopup.buildTargetPopupWithMultiSelect$lambda$1(arg_0 -> TargetPopup.buildTargetPopupWithMultiSelect$lambda$0(presentationProvider, arg_0), arg_0)).setItemsChosenCallback(arg_0 -> TargetPopup.buildTargetPopupWithMultiSelect$lambda$3(arg_0 -> TargetPopup.buildTargetPopupWithMultiSelect$lambda$2(predicate, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iPopupChooserBuilder, (String)"setItemsChosenCallback(...)");
        return iPopupChooserBuilder;
    }

    @NotNull
    public static final <T> ListCellRenderer<T> createTargetPresentationRenderer(@NotNull Function<? super T, ? extends TargetPresentation> presentationProvider) {
        Intrinsics.checkNotNullParameter(presentationProvider, (String)"presentationProvider");
        return UISettings.Companion.getInstance().getShowIconInQuickNavigation() ? (ListCellRenderer)new TargetPresentationRenderer<T>(presentationProvider) : (ListCellRenderer)((Object)new TargetPresentationMainRenderer<T>(presentationProvider));
    }

    private static final String speedSearchText(TargetPresentation $this$speedSearchText) {
        String containerText;
        String presentableText = $this$speedSearchText.getPresentableText();
        String string = containerText = $this$speedSearchText.getContainerText();
        return string == null ? presentableText : presentableText + " " + string;
    }

    private static final TargetPresentation createTargetPopup$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (TargetPresentation)it.getSecond();
    }

    private static final TargetPresentation createTargetPopup$lambda$1(Function1 $tmp0, Object p0) {
        return (TargetPresentation)$tmp0.invoke(p0);
    }

    private static final Unit createTargetPopup$lambda$2(Consumer $processor, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $processor.accept(it.getFirst());
        return Unit.INSTANCE;
    }

    private static final void createTargetPopup$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean buildTargetPopup$lambda$1(Consumer $processor, Object it) {
        $processor.accept(it);
        return false;
    }

    private static final String buildTargetPopupWithMultiSelect$lambda$0(Function $presentationProvider, Object item) {
        Object r = $presentationProvider.apply(item);
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        return TargetPopup.speedSearchText((TargetPresentation)r);
    }

    private static final String buildTargetPopupWithMultiSelect$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit buildTargetPopupWithMultiSelect$lambda$2(Predicate $predicate, Set set) {
        Intrinsics.checkNotNull((Object)set);
        Iterable $this$all$iv = set;
        boolean $i$f$all = false;
        if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) {
            Iterator iterator = $this$all$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if ($predicate.test(it)) continue;
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static final void buildTargetPopupWithMultiSelect$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

