/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.BorderPainterHolder;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.BorderPainter;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DefaultBorderPainter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DockableContentContainer;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.mac.MacWinTabsHandlerV2;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBDefaultTabPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.singleRow.WindowTabsLayout;
import com.intellij.ui.tabs.impl.themes.DefaultTabTheme;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class WindowTabsComponent
extends JBTabsImpl
implements BorderPainterHolder {
    private static final String TITLE_LISTENER_KEY = "TitleListener";
    public static final String CLOSE_TAB_KEY = "CloseTab";
    private static final int TAB_HEIGHT = 30;
    private static DockManagerImpl dockManager;
    private final IdeFrameImpl myNativeWindow;
    private final Disposable myParentDisposable;
    private final Map<IdeFrameImpl, Integer> myIndexes;
    private BorderPainter borderPainter;

    public WindowTabsComponent(@NotNull IdeFrameImpl nativeWindow, @Nullable Project project2, @NotNull Disposable parentDisposable) {
        if (nativeWindow == null) {
            WindowTabsComponent.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            WindowTabsComponent.$$$reportNull$$$0(1);
        }
        super(project2, parentDisposable);
        this.myIndexes = new HashMap<IdeFrameImpl, Integer>();
        this.borderPainter = new DefaultBorderPainter();
        this.myNativeWindow = nativeWindow;
        this.myParentDisposable = parentDisposable;
        this.setUiDecorator(new UiDecorator(){

            @NotNull
            public UiDecorator.UiDecoration getDecoration() {
                return new UiDecorator.UiDecoration((Font)JBFont.medium(), new Insets(-1, WindowTabsComponent.this.getDropInfo() == null ? 0 : -1, -1, -1), position -> WindowTabsComponent.getContentInsets());
            }
        });
        Disposer.register((Disposable)this.myParentDisposable, () -> {
            int count = this.getTabCount();
            for (int i2 = 0; i2 < count; ++i2) {
                WindowTabsComponent.removeTitleListener(this.getTabAt(i2));
            }
        });
        this.createTabActions();
        this.installDnD();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public BorderPainter getBorderPainter() {
        BorderPainter borderPainter = this.borderPainter;
        if (borderPainter == null) {
            WindowTabsComponent.$$$reportNull$$$0(2);
        }
        return borderPainter;
    }

    @Override
    @ApiStatus.Internal
    public void setBorderPainter(@NotNull BorderPainter painter) {
        if (painter == null) {
            WindowTabsComponent.$$$reportNull$$$0(3);
        }
        this.borderPainter = painter;
    }

    @NotNull
    private static Insets getContentInsets() {
        Insets insets;
        InternalUICustomization customization = InternalUICustomization.getInstance();
        if (customization != null && (insets = customization.getProjectTabContentInsets()) != null) {
            Insets insets2 = insets;
            if (insets2 == null) {
                WindowTabsComponent.$$$reportNull$$$0(4);
            }
            return insets2;
        }
        JBInsets jBInsets = JBUI.insets((int)0, (int)4);
        if (jBInsets == null) {
            WindowTabsComponent.$$$reportNull$$$0(5);
        }
        return jBInsets;
    }

    public void selfDispose() {
        Disposer.dispose((Disposable)this.myParentDisposable);
    }

    @NotNull
    protected TabLayout createRowLayout() {
        if (this.isSingleRow()) {
            return new WindowTabsLayout((JBTabsImpl)this);
        }
        TabLayout tabLayout = super.createRowLayout();
        if (tabLayout == null) {
            WindowTabsComponent.$$$reportNull$$$0(6);
        }
        return tabLayout;
    }

    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, JBUI.scale((int)30));
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.borderPainter.paintAfterChildren((JComponent)((Object)this), g);
    }

    @Nullable
    protected TabInfo getDraggedTabSelectionInfo() {
        TabInfo source = this.getDragHelper().getDragSource();
        return source != null ? source : super.getDraggedTabSelectionInfo();
    }

    private static boolean _isSelectionClick(@NotNull MouseEvent e) {
        if (e == null) {
            WindowTabsComponent.$$$reportNull$$$0(7);
        }
        return e.getClickCount() == 1 && !e.isPopupTrigger() && e.getButton() == 1 && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
    }

    @NotNull
    protected TabLabel createTabLabel(final @NotNull TabInfo info) {
        if (info == null) {
            WindowTabsComponent.$$$reportNull$$$0(8);
        }
        return new TabLabel(this, info){
            {
                super(arg0, arg1);
                for (MouseListener listener2 : this.getMouseListeners()) {
                    this.removeMouseListener(listener2);
                }
                final 2 label2 = this;
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (!UIUtil.isCloseClick((MouseEvent)e, (int)501) && !WindowTabsComponent._isSelectionClick(e)) {
                            this.handlePopup(e);
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.handlePopup(e);
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (WindowTabsComponent._isSelectionClick(e)) {
                            Component c = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY());
                            if (c instanceof InplaceButton) {
                                return;
                            }
                            tabs.select(info, true);
                            JBPopup container = PopupUtil.getPopupContainerFor((Component)label2);
                            if (container != null && ClientProperty.isTrue((Component)container.getContent(), MorePopupAware.class)) {
                                container.cancel();
                            }
                        } else if (e.getButton() == 2) {
                            WindowTabsComponent.closeTab((IdeFrameImpl)this.getInfo().getObject(), false);
                        } else {
                            this.handlePopup(e);
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        this.setHovered(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        this.setHovered(false);
                    }
                });
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, JBUI.scale((int)30));
            }

            public void setTabActions(ActionGroup group2) {
                super.setTabActions(group2);
                if (this.actionPanel != null) {
                    Container parent = this.actionPanel.getParent();
                    parent.remove((Component)this.actionPanel);
                    parent.add((Component)new Wrapper((JComponent)this.actionPanel){

                        public Dimension getPreferredSize() {
                            return actionPanel.getPreferredSize();
                        }
                    }, "West");
                    this.actionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
                    this.actionPanel.setVisible(!WindowTabsComponent.showCloseActionOnHover());
                }
            }

            protected void setHovered(boolean value) {
                super.setHovered(value);
                if (this.actionPanel != null) {
                    this.actionPanel.setVisible(!WindowTabsComponent.showCloseActionOnHover() || value || this.getInfo() == this.tabs.getPopupInfo());
                }
            }

            protected void handlePopup(MouseEvent e) {
                super.handlePopup(e);
                final JPopupMenu popup2 = this.tabs.getActivePopup();
                if (popup2 != null) {
                    popup2.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            this.handle();
                        }

                        public void popupMenuCanceled(PopupMenuEvent e) {
                            this.handle();
                        }

                        private void handle() {
                            popup2.removePopupMenuListener((PopupMenuListener)((Object)this));
                            actionPanel.setVisible(!WindowTabsComponent.showCloseActionOnHover() || this.isHovered());
                        }
                    });
                }
            }

            protected boolean isTabActionsOnTheRight() {
                return false;
            }

            protected boolean shouldPaintFadeout() {
                return false;
            }
        };
    }

    private static boolean showCloseActionOnHover() {
        return Registry.is((String)"ide.mac.os.wintabs.show.closeaction.on.hover", (boolean)true);
    }

    @NotNull
    protected TabPainterAdapter createTabPainterAdapter() {
        return new TabPainterAdapter(){
            private final JBTabPainter myTabPainter = new JBDefaultTabPainter((TabTheme)new DefaultTabTheme(this){

                public int getTopBorderThickness() {
                    return 0;
                }

                @Nullable
                public Color getInactiveColoredTabBackground() {
                    return null;
                }
            });

            @NotNull
            public JBTabPainter getTabPainter() {
                JBTabPainter jBTabPainter = this.myTabPainter;
                if (jBTabPainter == null) {
                    3.$$$reportNull$$$0(0);
                }
                return jBTabPainter;
            }

            public void paintBackground(@NotNull TabLabel label2, @NotNull Graphics g, @NotNull JBTabsImpl tabs) {
                if (label2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (g == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (tabs == null) {
                    3.$$$reportNull$$$0(3);
                }
                Rectangle rect = new Rectangle(0, 0, label2.getWidth(), label2.getHeight());
                TabInfo info = label2.getInfo();
                Graphics2D g2d = (Graphics2D)g;
                int index = tabs.getIndexOf(info);
                int lastIndex = tabs.getTabCount() - 1;
                int border = JBUI.scale((int)1);
                boolean selected = info.getObject() == WindowTabsComponent.this.myNativeWindow;
                InternalUICustomization customization = InternalUICustomization.getInstance();
                if (customization != null && customization.paintProjectTab(WindowTabsComponent.this.myNativeWindow, label2, g, tabs, selected, index, lastIndex)) {
                    return;
                }
                if (selected) {
                    Window window = ComponentUtil.getWindow((Component)((Object)WindowTabsComponent.this));
                    Color tabColor = JBUI.CurrentTheme.MainWindow.Tab.background((boolean)true, (window != null && !window.isActive() ? 1 : 0) != 0, (boolean)false);
                    this.myTabPainter.paintTab(tabs.getTabsPosition(), g2d, rect, tabs.getBorderThickness(), tabColor, true, false);
                    g.setColor(JBUI.CurrentTheme.MainWindow.Tab.BORDER);
                    LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)0.0, (double)rect.width, (double)0.0, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)border);
                    if (index > 0) {
                        LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)0.0, (double)0.0, (double)rect.height, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)border);
                    }
                    if (index < lastIndex) {
                        LinePainter2D.paint((Graphics2D)g2d, (double)(rect.width - border), (double)0.0, (double)(rect.width - border), (double)rect.height, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)border);
                    }
                } else {
                    Color tabColor = JBUI.CurrentTheme.MainWindow.Tab.background((boolean)false, (boolean)false, (boolean)label2.isHovered());
                    this.myTabPainter.paintTab(tabs.getTabsPosition(), g2d, rect, tabs.getBorderThickness(), tabColor, true, false);
                    if (lastIndex > 1 && index < lastIndex && tabs.getTabAt(index + 1) != tabs.getSelectedInfo()) {
                        g.setColor(JBUI.CurrentTheme.MainWindow.Tab.SEPARATOR);
                        LinePainter2D.paint((Graphics2D)g2d, (double)(rect.width - border), (double)0.0, (double)(rect.width - border), (double)rect.height, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)border);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/mac/WindowTabsComponent$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "label";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tabs";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTabPainter";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "paintBackground";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private boolean isSameGroup(@NotNull WindowTabsComponent anotherComponent) {
        if (anotherComponent == null) {
            WindowTabsComponent.$$$reportNull$$$0(9);
        }
        if (this == anotherComponent) {
            return true;
        }
        int count = this.getTabCount();
        if (count != anotherComponent.getTabCount()) {
            return false;
        }
        HashSet<Object> tabs = new HashSet<Object>();
        HashSet<Object> anotherTabs = new HashSet<Object>();
        for (int i2 = 0; i2 < count; ++i2) {
            tabs.add(this.getTabAt(i2).getObject());
            anotherTabs.add(anotherComponent.getTabAt(i2).getObject());
        }
        return tabs.equals(anotherTabs);
    }

    public void createTabsForFrame(IdeFrameImpl @NotNull [] tabFrames) {
        if (tabFrames == null) {
            WindowTabsComponent.$$$reportNull$$$0(10);
        }
        for (IdeFrameImpl tabFrame : tabFrames) {
            this.createTabItem(tabFrame, -1, tabFrame == this.myNativeWindow);
        }
        this.recalculateIndexes();
        this.setSelectionChangeHandler((info, requestFocus, doChangeSelection) -> {
            IdeFrameImpl tabFrame = (IdeFrameImpl)info.getObject();
            if (tabFrame == this.myNativeWindow) {
                TabInfo selectedInfo = this.getSelectedInfo();
                if (selectedInfo != null && selectedInfo.getObject() == this.myNativeWindow) {
                    return ActionCallback.REJECTED;
                }
                return doChangeSelection.run();
            }
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                ID window = MacUtil.getWindowFromJavaWindow((Window)((Window)info.getObject()));
                ID tabGroup = Foundation.invoke((ID)window, (String)"tabGroup", (Object[])new Object[0]);
                Foundation.invoke((ID)tabGroup, (String)"setSelectedWindow:", (Object[])new Object[]{window});
            });
            return ActionCallback.REJECTED;
        });
    }

    public void insertTabForFrame(@NotNull IdeFrameImpl tab, int index) {
        if (tab == null) {
            WindowTabsComponent.$$$reportNull$$$0(11);
        }
        this.createTabItem(tab, index, false);
        this.recalculateIndexes();
    }

    public boolean removeTabFromFrame(@NotNull IdeFrameImpl tab) {
        if (tab == null) {
            WindowTabsComponent.$$$reportNull$$$0(12);
        }
        int count = this.getTabCount();
        boolean removed = false;
        for (int i2 = 0; i2 < count; ++i2) {
            TabInfo info = this.getTabAt(i2);
            if (info.getObject() != tab) continue;
            WindowTabsComponent.removeTitleListener(info);
            this.removeTab(info);
            this.recalculateIndexes();
            removed = true;
            --count;
            break;
        }
        return removed && count == 1;
    }

    private void createTabItem(@NotNull IdeFrameImpl tabFrame, int index, boolean selection) {
        EventListener listener2;
        if (tabFrame == null) {
            WindowTabsComponent.$$$reportNull$$$0(13);
        }
        TabInfo info = new TabInfo((JComponent)new JLabel());
        info.setObject((Object)tabFrame).setText(tabFrame.getTitle()).setTooltipText(tabFrame.getTitle());
        info.setTabLabelActions((ActionGroup)WindowTabsComponent.createTabActions(tabFrame), "unknown");
        info.setDefaultForeground(JBUI.CurrentTheme.MainWindow.Tab.foreground((boolean)selection, (boolean)false));
        this.addTab(info, index);
        if (selection) {
            this.select(info, true);
            listener2 = new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    WindowTabsComponent.this.repaint();
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    WindowTabsComponent.this.repaint();
                }
            };
            tabFrame.addWindowListener((WindowListener)listener2);
            Disposer.register((Disposable)this.myParentDisposable, () -> WindowTabsComponent.lambda$createTabItem$3(tabFrame, (WindowAdapter)listener2));
        }
        listener2 = event -> info.setText((String)event.getNewValue()).setTooltipText((String)event.getNewValue());
        tabFrame.addPropertyChangeListener("title", (PropertyChangeListener)listener2);
        info.getComponent().putClientProperty(TITLE_LISTENER_KEY, listener2);
        this.installTabDnd(info);
    }

    private static void removeTitleListener(@NotNull TabInfo info) {
        if (info == null) {
            WindowTabsComponent.$$$reportNull$$$0(14);
        }
        PropertyChangeListener listener2 = (PropertyChangeListener)info.getComponent().getClientProperty(TITLE_LISTENER_KEY);
        ((IdeFrameImpl)info.getObject()).removePropertyChangeListener("title", listener2);
    }

    private void recalculateIndexes() {
        this.myIndexes.clear();
        int count = this.getTabCount();
        for (int i2 = 0; i2 < count; ++i2) {
            this.myIndexes.put((IdeFrameImpl)this.getTabAt(i2).getObject(), i2);
        }
    }

    private void reorderTabs(Map<IdeFrameImpl, Integer> indexes) {
        this.sortTabs(Comparator.comparingInt(info -> (Integer)indexes.get(info.getObject())));
        this.recalculateIndexes();
    }

    @NotNull
    private static DefaultActionGroup createTabActions(final @NotNull IdeFrameImpl tabFrame) {
        if (tabFrame == null) {
            WindowTabsComponent.$$$reportNull$$$0(15);
        }
        DumbAwareAction closeAction = new DumbAwareAction(IdeBundle.message((String)"mac.window.tabs.close.title", (Object[])new Object[0])){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                WindowTabsComponent.closeTab(tabFrame, (e.getModifiers() & 8) != 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/mac/WindowTabsComponent$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        Presentation presentation2 = closeAction.getTemplatePresentation();
        boolean isNewUiAndDark = ExperimentalUI.isNewUI() && (!JBColor.isBright() || ColorUtil.isDark((Color)JBColor.namedColor((String)"MainToolbar.background")));
        presentation2.setIcon(isNewUiAndDark ? IconManager.getInstance().getIcon("expui/general/closeSmall_dark.svg", AllIcons.class.getClassLoader()) : AllIcons.Actions.Close);
        presentation2.setHoveredIcon(isNewUiAndDark ? IconManager.getInstance().getIcon("expui/general/closeSmallHovered_dark.svg", AllIcons.class.getClassLoader()) : AllIcons.Actions.CloseHovered);
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)closeAction);
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            WindowTabsComponent.$$$reportNull$$$0(16);
        }
        return defaultActionGroup;
    }

    private void createTabActions() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new DumbAwareAction(this, IdeBundle.message((String)"mac.window.tabs.close.tab", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                WindowTabsComponent.closeTab(WindowTabsComponent.getPopupFrame(e), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/mac/WindowTabsComponent$6", "actionPerformed"));
            }
        });
        group2.add((AnAction)new DumbAwareAction(this, IdeBundle.message((String)"mac.window.tabs.close.other.tabs", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                WindowTabsComponent.closeTab(WindowTabsComponent.getPopupFrame(e), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/mac/WindowTabsComponent$7", "actionPerformed"));
            }
        });
        group2.add((AnAction)new DumbAwareAction(this, IdeBundle.message((String)"mac.window.tabs.move.tab", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                WindowTabsComponent.moveTabToNewWindow(WindowTabsComponent.getPopupFrame(e));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/mac/WindowTabsComponent$8", "actionPerformed"));
            }
        });
        group2.add((AnAction)new DumbAwareAction(this, IdeBundle.message((String)"mac.window.tabs.show.all.tabs", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                IdeFrameImpl tabFrame = WindowTabsComponent.getPopupFrame(e);
                Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                    ID window = MacUtil.getWindowFromJavaWindow((Window)tabFrame);
                    ID tabs = Foundation.invoke((ID)window, (String)"tabbedWindows", (Object[])new Object[0]);
                    int count = Foundation.invoke((ID)tabs, (String)"count", (Object[])new Object[0]).intValue();
                    for (int i2 = 0; i2 < count; ++i2) {
                        ID tab = Foundation.invoke((ID)tabs, (String)"objectAtIndex:", (Object[])new Object[]{i2});
                        Foundation.invoke((ID)tab, (String)"setTabOverviewVisible:", (Object[])new Object[]{1});
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/mac/WindowTabsComponent$9", "actionPerformed"));
            }
        });
        this.setPopupGroup((ActionGroup)group2, "popup", false);
    }

    @NotNull
    private static IdeFrameImpl getPopupFrame(@NotNull AnActionEvent e) {
        if (e == null) {
            WindowTabsComponent.$$$reportNull$$$0(17);
        }
        TabLabel label2 = (TabLabel)Objects.requireNonNull((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
        IdeFrameImpl ideFrameImpl = (IdeFrameImpl)label2.getInfo().getObject();
        if (ideFrameImpl == null) {
            WindowTabsComponent.$$$reportNull$$$0(18);
        }
        return ideFrameImpl;
    }

    private static void closeTab(@NotNull IdeFrameImpl tabFrame, boolean closeOthers) {
        if (tabFrame == null) {
            WindowTabsComponent.$$$reportNull$$$0(19);
        }
        tabFrame.getRootPane().putClientProperty(CLOSE_TAB_KEY, Boolean.TRUE);
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID window = MacUtil.getWindowFromJavaWindow((Window)tabFrame);
            Foundation.invoke((ID)window, (String)(closeOthers ? "performCloseOtherTabs:" : "performClose:"), (Object[])new Object[]{ID.NIL});
        });
    }

    private static void moveTabToNewWindow(@NotNull IdeFrameImpl tabFrame) {
        if (tabFrame == null) {
            WindowTabsComponent.$$$reportNull$$$0(20);
        }
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID window = MacUtil.getWindowFromJavaWindow((Window)tabFrame);
            ID tabGroup = Foundation.invoke((ID)window, (String)"tabGroup", (Object[])new Object[0]);
            Foundation.invoke((ID)tabGroup, (String)"setSelectedWindow:", (Object[])new Object[]{window});
            Foundation.invoke((ID)window, (String)"moveTabToNewWindow:", (Object[])new Object[]{ID.NIL});
            ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandlerV2.updateTabBarsAfterMove(tabFrame, null, -1));
        });
    }

    private static void moveTabToWindow(@NotNull IdeFrameImpl tabFrame, @NotNull IdeFrameImpl target) {
        if (tabFrame == null) {
            WindowTabsComponent.$$$reportNull$$$0(21);
        }
        if (target == null) {
            WindowTabsComponent.$$$reportNull$$$0(22);
        }
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID window = MacUtil.getWindowFromJavaWindow((Window)target);
            ID tabGroup = Foundation.invoke((ID)window, (String)"tabGroup", (Object[])new Object[0]);
            ID tab = MacUtil.getWindowFromJavaWindow((Window)tabFrame);
            Foundation.invoke((ID)tabGroup, (String)"addWindow:", (Object[])new Object[]{tab});
            Foundation.invoke((ID)tabGroup, (String)"setSelectedWindow:", (Object[])new Object[]{tab});
            ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandlerV2.updateTabBarsAfterMove(tabFrame, target, -1));
        });
    }

    private void moveTabToNewIndex(@NotNull TabInfo info) {
        if (info == null) {
            WindowTabsComponent.$$$reportNull$$$0(23);
        }
        IdeFrameImpl movedFrame = (IdeFrameImpl)info.getObject();
        int newIndex = this.getIndexOf(info);
        int oldIndex = this.myIndexes.get(movedFrame);
        if (oldIndex != newIndex) {
            this.recalculateIndexes();
            this.moveTabToNewIndex(movedFrame, newIndex);
        }
    }

    private void moveTabToNewIndex(@NotNull IdeFrameImpl movedFrame, int newIndex) {
        if (movedFrame == null) {
            WindowTabsComponent.$$$reportNull$$$0(24);
        }
        int count = this.getTabCount();
        for (int i2 = 0; i2 < count; ++i2) {
            IdeFrameImpl tabFrame = (IdeFrameImpl)this.getTabAt(i2).getObject();
            if (tabFrame == this.myNativeWindow) continue;
            WindowTabsComponent tabsComponent = Objects.requireNonNull(MacWinTabsHandlerV2.getTabsComponent(MacWinTabsHandlerV2.getTabsContainer(tabFrame)));
            tabsComponent.reorderTabs(this.myIndexes);
        }
        Runnable action2 = () -> Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID window = MacUtil.getWindowFromJavaWindow((Window)movedFrame);
            ID tabGroup = Foundation.invoke((ID)window, (String)"tabGroup", (Object[])new Object[0]);
            Foundation.invoke((ID)tabGroup, (String)"removeWindow:", (Object[])new Object[]{window});
            Foundation.invoke((ID)tabGroup, (String)"insertWindow:atIndex:", (Object[])new Object[]{window, newIndex});
            Foundation.invoke((ID)tabGroup, (String)"setSelectedWindow:", (Object[])new Object[]{window});
        });
        if (movedFrame == this.myNativeWindow) {
            action2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(action2);
        }
    }

    private void moveTabToNewIndexOrWindow(@NotNull TabInfo info, boolean movedFromOut) {
        if (info == null) {
            WindowTabsComponent.$$$reportNull$$$0(25);
        }
        IdeFrameImpl movedFrame = (IdeFrameImpl)info.getObject();
        int newIndex = this.getDropInfoIndex();
        assert (newIndex != -1) : "Wrong Reordering";
        if (movedFromOut) {
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                ID window = MacUtil.getWindowFromJavaWindow((Window)this.myNativeWindow);
                ID tabGroup = Foundation.invoke((ID)window, (String)"tabGroup", (Object[])new Object[0]);
                ID tab = MacUtil.getWindowFromJavaWindow((Window)movedFrame);
                Foundation.invoke((ID)tabGroup, (String)"insertWindow:atIndex:", (Object[])new Object[]{tab, newIndex});
                Foundation.invoke((ID)tabGroup, (String)"setSelectedWindow:", (Object[])new Object[]{tab});
                ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandlerV2.updateTabBarsAfterMove(movedFrame, this.myNativeWindow, newIndex));
            });
        } else {
            info.setHidden(false);
            int oldIndex = this.myIndexes.get(movedFrame);
            if (oldIndex != newIndex) {
                this.reorderTab(info, newIndex);
                this.recalculateIndexes();
                this.moveTabToNewIndex(movedFrame, newIndex);
            }
        }
    }

    private void installTabDnd(final @NotNull TabInfo info) {
        if (info == null) {
            WindowTabsComponent.$$$reportNull$$$0(26);
        }
        info.setDragOutDelegate(new TabInfo.DragOutDelegate(){
            private DragSession mySession;

            public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
                if (mouseEvent == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (info == null) {
                    10.$$$reportNull$$$0(1);
                }
                WindowFrameDockableContent content2 = new WindowFrameDockableContent(WindowTabsComponent.this, info, WindowTabsComponent.this.getTabLabel(info));
                info.setHidden(true);
                DockManagerImpl manager2 = WindowTabsComponent.getDockManager();
                WindowTabsComponent.updateDockContainers(manager2);
                this.mySession = manager2.createDragSession(mouseEvent, content2);
            }

            public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
                if (event == null) {
                    10.$$$reportNull$$$0(2);
                }
                if (source == null) {
                    10.$$$reportNull$$$0(3);
                }
                this.mySession.process(event);
            }

            public void dragOutFinished(@NotNull MouseEvent event, TabInfo source) {
                if (event == null) {
                    10.$$$reportNull$$$0(4);
                }
                this.mySession.process(event);
                this.mySession = null;
            }

            public void dragOutCancelled(TabInfo source) {
                this.mySession.cancel();
                this.mySession = null;
                source.setHidden(false);
                if (WindowTabsComponent.this.getIndexOf(source) != -1) {
                    WindowTabsComponent.this.moveTabToNewIndex(source);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mouseEvent";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dragOutStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDragOut";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dragOutFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        info.setDragDelegate(new TabInfo.DragDelegate(){

            public void dragStarted(@NotNull MouseEvent mouseEvent) {
                if (mouseEvent == null) {
                    11.$$$reportNull$$$0(0);
                }
                WindowTabsComponent.this.setComponentZOrder((Component)WindowTabsComponent.this.getTabLabel(info), 0);
            }

            public void dragFinishedOrCanceled() {
                WindowTabsComponent.this.setComponentZOrder((Component)WindowTabsComponent.this.getTabLabel(WindowTabsComponent.this.getSelectedInfo()), 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseEvent", "com/intellij/ui/mac/WindowTabsComponent$11", "dragStarted"));
            }
        });
    }

    private static void updateDockContainers(@NotNull DockManagerImpl manager2) {
        if (manager2 == null) {
            WindowTabsComponent.$$$reportNull$$$0(27);
        }
        for (DockContainer _container : manager2.getContainers()) {
            if (!(_container instanceof TabsDockContainer)) continue;
            TabsDockContainer container = (TabsDockContainer)_container;
            container.checkEnabled();
        }
    }

    @NotNull
    private static DockManagerImpl getDockManager() {
        if (dockManager == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            dockManager = new DockManagerImpl(project2, ((ComponentManagerEx)project2).getCoroutineScope());
        }
        DockManagerImpl dockManagerImpl = dockManager;
        if (dockManagerImpl == null) {
            WindowTabsComponent.$$$reportNull$$$0(28);
        }
        return dockManagerImpl;
    }

    private void installDnD() {
        this.setTabDraggingEnabled(true);
        this.addListener(new TabsListener(){

            public void tabsMoved() {
                WindowTabsComponent.this.moveTabToNewIndex(WindowTabsComponent.this.getDragHelper().getDragSource());
            }
        });
        WindowTabsComponent.getDockManager().register((DockContainer)new TabsDockContainer(), this.myParentDisposable);
    }

    static void registerFrameDockContainer(final @NotNull IdeFrameImpl frame, @NotNull CoroutineScope coroutineScope) {
        if (frame == null) {
            WindowTabsComponent.$$$reportNull$$$0(29);
        }
        if (coroutineScope == null) {
            WindowTabsComponent.$$$reportNull$$$0(30);
        }
        WindowTabsComponent.getDockManager().register(new DockContainer(){
            private Disposable myPaintDisposable;
            private AbstractPainter myDropPainter;

            @NotNull
            public RelativeRectangle getAcceptArea() {
                return new RelativeRectangle(frame.getComponent());
            }

            @NotNull
            public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent<?> _content, RelativePoint point) {
                WindowFrameDockableContent content2;
                if (_content == null) {
                    13.$$$reportNull$$$0(0);
                }
                DockContainer.ContentResponse contentResponse = _content instanceof WindowFrameDockableContent && !(content2 = (WindowFrameDockableContent)_content).isInFullScreen() && MacWinTabsHandlerV2.isTabsNotVisible(frame) && !frame.isInFullScreen() ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
                if (contentResponse == null) {
                    13.$$$reportNull$$$0(1);
                }
                return contentResponse;
            }

            @NotNull
            public JComponent getContainerComponent() {
                JComponent jComponent = frame.getComponent();
                if (jComponent == null) {
                    13.$$$reportNull$$$0(2);
                }
                return jComponent;
            }

            @Nullable
            public Image startDropOver(@NotNull DockableContent<?> content2, RelativePoint point) {
                if (content2 == null) {
                    13.$$$reportNull$$$0(3);
                }
                this.myPaintDisposable = Disposer.newDisposable((String)"GlassPaneListeners");
                this.myDropPainter = new WindowDropAreaPainter(frame);
                JComponent component2 = frame.getComponent();
                IdeGlassPaneUtil.find((Component)component2).addPainter((Component)component2, (Painter)this.myDropPainter, this.myPaintDisposable);
                return null;
            }

            public void resetDropOver(@NotNull DockableContent<?> content2) {
                if (content2 == null) {
                    13.$$$reportNull$$$0(4);
                }
                Disposer.dispose((Disposable)this.myPaintDisposable);
                this.myPaintDisposable = null;
                this.myDropPainter = null;
            }

            public void add(@NotNull DockableContent<?> content2, @Nullable RelativePoint dropTarget) {
                if (content2 == null) {
                    13.$$$reportNull$$$0(5);
                }
                WindowTabsComponent.moveTabToWindow(((WindowFrameDockableContent)content2).getKey(), frame);
            }

            public boolean isEmpty() {
                return false;
            }

            public boolean isDisposeWhenEmpty() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "_content";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/mac/WindowTabsComponent$13";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent$13";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentResponse";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContainerComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getContentResponse";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "startDropOver";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "resetDropOver";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "add";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }, coroutineScope);
    }

    private static /* synthetic */ void lambda$createTabItem$3(IdeFrameImpl tabFrame, WindowAdapter listener2) {
        tabFrame.removeWindowListener(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 16, 18, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/WindowTabsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 14: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabFrames";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabFrame";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFrame";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderPainter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentInsets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRowLayout";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabActions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupFrame";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBorderPainter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "_isSelectionClick";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTabLabel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSameGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTabsForFrame";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "insertTabForFrame";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeTabFromFrame";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTabItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeTitleListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTabActions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPopupFrame";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "closeTab";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveTabToNewWindow";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moveTabToWindow";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "moveTabToNewIndex";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveTabToNewIndexOrWindow";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "installTabDnd";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateDockContainers";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "registerFrameDockContainer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 16, 18, 28 -> new IllegalStateException(string);
        };
    }

    private final class TabsDockContainer
    implements DockContainer {
        boolean enabled;
        TabInfo myDropTab;
        Image myDropImage;

        private TabsDockContainer() {
        }

        void checkEnabled() {
            ID window = MacUtil.getWindowFromJavaWindow((Window)WindowTabsComponent.this.myNativeWindow);
            this.enabled = Foundation.invoke((ID)window, (String)"isNativeSelected", (Object[])new Object[0]).intValue() == 1;
        }

        @NotNull
        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle((JComponent)((Object)WindowTabsComponent.this));
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent<?> content2, RelativePoint point) {
            if (content2 == null) {
                TabsDockContainer.$$$reportNull$$$0(0);
            }
            DockContainer.ContentResponse contentResponse = this.enabled && content2 instanceof WindowFrameDockableContent ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                TabsDockContainer.$$$reportNull$$$0(1);
            }
            return contentResponse;
        }

        @NotNull
        public JComponent getContainerComponent() {
            WindowTabsComponent windowTabsComponent = WindowTabsComponent.this;
            if (windowTabsComponent == null) {
                TabsDockContainer.$$$reportNull$$$0(2);
            }
            return windowTabsComponent;
        }

        @NotNull
        public Image startDropOver(@NotNull DockableContent<?> content2, RelativePoint point) {
            if (content2 == null) {
                TabsDockContainer.$$$reportNull$$$0(3);
            }
            Presentation presentation2 = content2.getPresentation();
            this.myDropTab = new TabInfo((JComponent)new JLabel()).setText(presentation2.getText()).setDefaultForeground(JBUI.CurrentTheme.MainWindow.Tab.foreground((boolean)true, (boolean)false));
            this.myDropImage = WindowTabsComponent.this.startDropOver(this.myDropTab, point);
            if (this.myDropImage == null) {
                TabsDockContainer.$$$reportNull$$$0(4);
            }
            return this.myDropImage;
        }

        @Nullable
        public Image processDropOver(@NotNull DockableContent<?> content2, RelativePoint point) {
            if (content2 == null) {
                TabsDockContainer.$$$reportNull$$$0(5);
            }
            WindowTabsComponent.this.processDropOver(this.myDropTab, point);
            return this.myDropImage;
        }

        public void resetDropOver(@NotNull DockableContent<?> content2) {
            if (content2 == null) {
                TabsDockContainer.$$$reportNull$$$0(6);
            }
            WindowTabsComponent.this.resetDropOver(this.myDropTab);
            this.myDropTab = null;
            this.myDropImage = null;
        }

        public void add(@NotNull DockableContent<?> _content, @Nullable RelativePoint dropTarget) {
            if (_content == null) {
                TabsDockContainer.$$$reportNull$$$0(7);
            }
            WindowFrameDockableContent content2 = (WindowFrameDockableContent)_content;
            WindowTabsComponent.this.moveTabToNewIndexOrWindow(content2.myInfo, !WindowTabsComponent.this.isSameGroup(content2.myTabsComponent));
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/mac/WindowTabsComponent$TabsDockContainer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent$TabsDockContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentResponse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startDropOver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentResponse";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "startDropOver";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processDropOver";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "resetDropOver";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class WindowDropAreaPainter
    extends AbstractPainter {
        private final Shape myArea;

        WindowDropAreaPainter(@NotNull IdeFrameImpl frame) {
            if (frame == null) {
                WindowDropAreaPainter.$$$reportNull$$$0(0);
            }
            this.myArea = new Rectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight());
        }

        public boolean needsRepaint() {
            return true;
        }

        public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
            if (component2 == null) {
                WindowDropAreaPainter.$$$reportNull$$$0(1);
            }
            if (g == null) {
                WindowDropAreaPainter.$$$reportNull$$$0(2);
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
            g.fill(this.myArea);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent$WindowDropAreaPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executePaint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class WindowFrameDockableContent
    implements DockableContent<IdeFrameImpl>,
    DockableContentContainer {
        private final Dimension mySize;
        private final WindowTabsComponent myTabsComponent;
        private final TabInfo myInfo;
        private final Presentation myPresentation;
        private final BufferedImage myImage;

        private WindowFrameDockableContent(@NotNull WindowTabsComponent tabsComponent, @NotNull TabInfo info, @NotNull TabLabel label2) {
            if (tabsComponent == null) {
                WindowFrameDockableContent.$$$reportNull$$$0(0);
            }
            if (info == null) {
                WindowFrameDockableContent.$$$reportNull$$$0(1);
            }
            if (label2 == null) {
                WindowFrameDockableContent.$$$reportNull$$$0(2);
            }
            this.myTabsComponent = tabsComponent;
            this.myInfo = info;
            IdeFrameImpl frame = this.getKey();
            this.mySize = frame.getSize();
            this.myImage = UIUtil.createImage((Component)frame, (int)this.mySize.width, (int)this.mySize.height, (int)2);
            Graphics2D g = this.myImage.createGraphics();
            label2.paint((Graphics)g);
            this.myPresentation = new Presentation(info.getText());
        }

        @NotNull
        public IdeFrameImpl getKey() {
            IdeFrameImpl ideFrameImpl = (IdeFrameImpl)this.myInfo.getObject();
            if (ideFrameImpl == null) {
                WindowFrameDockableContent.$$$reportNull$$$0(3);
            }
            return ideFrameImpl;
        }

        public boolean isInFullScreen() {
            return this.getKey().isInFullScreen() || this.myTabsComponent.myNativeWindow.isInFullScreen();
        }

        public Image getPreviewImage() {
            return this.myImage;
        }

        public String getDockContainerType() {
            return null;
        }

        public Dimension getPreferredSize() {
            return this.mySize;
        }

        public void close() {
        }

        public Presentation getPresentation() {
            return this.myPresentation;
        }

        public void add(@Nullable RelativePoint dropTarget) {
            WindowTabsComponent.moveTabToNewWindow(this.getKey());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabsComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/mac/WindowTabsComponent$WindowFrameDockableContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/mac/WindowTabsComponent$WindowFrameDockableContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

