/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.FNKeyAction;
import com.intellij.ui.mac.touchbar.TBPanel;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionsLoader {
    private static final Logger LOG = Logger.getInstance(ActionsLoader.class);
    private static final boolean ENABLE_FN_MODE = Boolean.getBoolean("touchbar.fn.mode.enable");
    private static int FN_WIDTH = Integer.getInteger("touchbar.fn.width", 68);
    private static final boolean TOOLWINDOW_CROSS_ESC = !Boolean.getBoolean("touchbar.toolwindow.esc");
    private static final boolean TOOLWINDOW_EMULATE_ESC = Boolean.getBoolean("touchbar.toolwindow.emulateesc");
    private static final boolean TOOLWINDOW_PERSISTENT = !Boolean.getBoolean("touchbar.toolwindow.nonpersistent");
    private static final String SETTINS_AUTOCLOSE_KEY = "touchbar.toolwindow.autoclose";
    private static final String DEFAULT_ACTION_GROUP = "TouchBarDefault";
    private static final int RUN_CONFIG_POPOVER_WIDTH = 143;

    ActionsLoader() {
    }

    private static String[] getAutoCloseActions(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ActionsLoader.$$$reportNull$$$0(0);
        }
        if (toolWindowId.isEmpty()) {
            return null;
        }
        String propVal = System.getProperty("touchbar.toolwindow.autoclose." + toolWindowId);
        if (propVal == null || propVal.isEmpty()) {
            return ActionsLoader.getAutoCloseActionsDefault(toolWindowId);
        }
        String[] split = propVal.split(",");
        if (split.length == 0) {
            return null;
        }
        for (int c = 0; c < split.length; ++c) {
            split[c] = split[c].trim();
        }
        return split;
    }

    @Nullable
    static Pair<Map<Long, ActionGroup>, Customizer> getProjectDefaultActionGroup() {
        if (ENABLE_FN_MODE) {
            LOG.debug("use FN-actions group for default actions");
            return ActionsLoader.getFnActionGroup();
        }
        @Nullable Map<Long, ActionGroup> defaultGroup = ActionsLoader.getActionGroup(DEFAULT_ACTION_GROUP);
        if (defaultGroup == null) {
            return null;
        }
        Customizer customizer = new Customizer(null, null, (parentInfo, butt, presentation2) -> {
            boolean isOpenInTerminalAction;
            String actId = ActionManager.getInstance().getId(butt.getAnAction());
            boolean isRunConfigPopover = "RunConfiguration".equals(actId);
            boolean bl = isOpenInTerminalAction = "Terminal.OpenInTerminal".equals(actId) || "Terminal.OpenInReworkedTerminal".equals(actId);
            if (isRunConfigPopover || isOpenInTerminalAction) {
                butt.setText(presentation2.getText());
                butt.setIconFromPresentation(presentation2);
            } else {
                TouchbarActionCustomizations customizations = parentInfo == null ? null : parentInfo.getCustomizations();
                butt.setIconAndTextFromPresentation(presentation2, customizations);
            }
            if (isRunConfigPopover) {
                if (presentation2.getIcon() != AllIcons.General.Add) {
                    butt.setHasArrowIcon(true);
                    butt.setLayout(143, 0, 5, 8);
                } else {
                    butt.setHasArrowIcon(false);
                    butt.setLayout(0, 0, 5, 8);
                }
            } else if (butt.getAnAction() instanceof WelcomePopupAction) {
                butt.setHasArrowIcon(true);
            }
        });
        return Pair.create(defaultGroup, (Object)customizer);
    }

    @Nullable
    static Pair<Map<Long, ActionGroup>, Customizer> getToolWindowActionGroup(@NotNull String toolWindowId) {
        Map<Long, ActionGroup> actions;
        if (toolWindowId == null) {
            ActionsLoader.$$$reportNull$$$0(1);
        }
        if ("Services".equals(toolWindowId)) {
            LOG.debug("Services tool-window will use action-group from debug tool window");
            toolWindowId = "Debug";
        }
        if ((actions = ActionsLoader.getActionGroup("TouchBar" + toolWindowId)) == null || actions.get(0L) == null) {
            LOG.debug("null action group (or it doesn't contain main-layout) for tool window: %s", new Object[]{toolWindowId});
            return null;
        }
        Customizer customizer = new Customizer(TOOLWINDOW_CROSS_ESC ? new TBPanel.CrossEscInfo(TOOLWINDOW_EMULATE_ESC, TOOLWINDOW_PERSISTENT) : null, ActionsLoader.getAutoCloseActions(toolWindowId));
        return Pair.create(actions, (Object)customizer);
    }

    @Nullable
    static Map<Long, ActionGroup> getActionGroup(@NotNull String groupId) {
        if (groupId == null) {
            ActionsLoader.$$$reportNull$$$0(2);
        }
        Object fullGroupId = groupId.startsWith("TouchBar") ? groupId : "TouchBar" + groupId;
        ActionGroup allTouchbarActions = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("TouchBar");
        if (allTouchbarActions == null) {
            LOG.debug("can't create touchbar because ActionGroup isn't defined: %s", new Object[]{"TouchBar"});
            return null;
        }
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actionGroup = null;
        for (AnAction act : allTouchbarActions.getChildren(null)) {
            AnAction anAction;
            if (!(act instanceof ActionGroup)) continue;
            if (act instanceof CustomisedActionGroup) {
                CustomisedActionGroup o = (CustomisedActionGroup)act;
                anAction = o.getDelegate();
            } else {
                anAction = act;
            }
            String actId = actionManager.getId(anAction);
            if (actId == null || actId.isEmpty() || !actId.equals(fullGroupId)) continue;
            actionGroup = (ActionGroup)act;
            break;
        }
        if (actionGroup == null) {
            LOG.debug("group %s wasn't found in CustomActionsSchema, will obtain it directly from ActionManager", new Object[]{groupId});
            AnAction act = actionManager.getAction((String)fullGroupId);
            if (!(act instanceof ActionGroup)) {
                LOG.debug("can't create touchbar because corresponding ActionGroup isn't defined: %s", new Object[]{groupId});
                return null;
            }
            actionGroup = (ActionGroup)act;
        }
        HashMap<Long, ActionGroup> result2 = new HashMap<Long, ActionGroup>();
        DefaultActionGroup mainLayout = new DefaultActionGroup();
        mainLayout.getTemplatePresentation().copyFrom(actionGroup.getTemplatePresentation());
        result2.put(0L, (ActionGroup)mainLayout);
        for (AnAction act : actionGroup.getChildren(null)) {
            AnAction anAction;
            if (!(act instanceof ActionGroup)) {
                mainLayout.addAction(act);
                continue;
            }
            if (act instanceof CustomisedActionGroup) {
                CustomisedActionGroup o = (CustomisedActionGroup)act;
                anAction = o.getDelegate();
            } else {
                anAction = act;
            }
            String gid = actionManager.getId(anAction);
            if (gid.startsWith((String)fullGroupId + "_")) {
                long mask = ActionsLoader._str2mask(gid.substring(((String)fullGroupId).length() + 1));
                if (mask != 0L) {
                    result2.put(mask, (ActionGroup)act);
                    continue;
                }
                LOG.debug("zero mask for group: %s", new Object[]{fullGroupId});
                continue;
            }
            mainLayout.addAction(act);
        }
        return result2;
    }

    @NotNull
    static Pair<Map<Long, ActionGroup>, Customizer> getFnActionGroup() {
        DefaultActionGroup result2 = new DefaultActionGroup(IdeBundle.message((String)"action.fn.keys.text", (Object[])new Object[0]), false);
        for (int c = 1; c <= 12; ++c) {
            result2.add((AnAction)new FNKeyAction(c));
        }
        HashMap<Long, DefaultActionGroup> ret = new HashMap<Long, DefaultActionGroup>();
        ret.put(0L, result2);
        Customizer customizer = new Customizer(null, null, (parentInfo, butt, presentation2) -> {
            AnAction patt0$temp = butt.getAnAction();
            if (patt0$temp instanceof FNKeyAction) {
                FNKeyAction act = (FNKeyAction)patt0$temp;
                butt.setWidth(FN_WIDTH);
                butt.setIcon(null);
                String hint = presentation2.getText() == null || presentation2.getText().isEmpty() ? " " : presentation2.getText();
                butt.setText(String.format("F%d", act.getFN()), hint, act.isActionDisabled());
            }
        });
        Pair pair = Pair.create(ret, (Object)customizer);
        if (pair == null) {
            ActionsLoader.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private static long _str2mask(@NotNull String modifierId) {
        if (modifierId == null) {
            ActionsLoader.$$$reportNull$$$0(4);
        }
        if (!modifierId.contains(".")) {
            if (modifierId.equalsIgnoreCase("alt")) {
                return 512L;
            }
            if (modifierId.equalsIgnoreCase("cmd")) {
                return 256L;
            }
            if (modifierId.equalsIgnoreCase("ctrl")) {
                return 128L;
            }
            if (modifierId.equalsIgnoreCase("shift")) {
                return 64L;
            }
            return 0L;
        }
        String[] spl = modifierId.split("\\.");
        long mask = 0L;
        for (String sub : spl) {
            mask |= ActionsLoader._str2mask(sub);
        }
        return mask;
    }

    private static String[] getAutoCloseActionsDefault(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ActionsLoader.$$$reportNull$$$0(5);
        }
        if (toolWindowId.equals("Debug") || toolWindowId.equals("Run") || toolWindowId.equals("Services")) {
            return new String[]{"Stop"};
        }
        return null;
    }

    static {
        FN_WIDTH = Math.max(FN_WIDTH, 50);
        FN_WIDTH = Math.min(FN_WIDTH, 100);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/ActionsLoader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/ActionsLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFnActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCloseActions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActionGroup";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "_str2mask";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCloseActionsDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

