/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.mac.touchbar.ActionsLoader;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CtxToolWindows {
    private static final Logger LOG = Logger.getInstance(CtxToolWindows.class);
    private static MessageBusConnection ourConnection = null;
    private static final WeakList<MessageBusConnection> ourProjConnections = new WeakList();

    CtxToolWindows() {
    }

    static void initialize() {
        for (Project project2 : ProjectUtilCore.getOpenProjects()) {
            CtxToolWindows.subscribeToolWindowTopic(project2);
        }
        ourConnection = ApplicationManager.getApplication().getMessageBus().connect();
        ourConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                CtxToolWindows.subscribeToolWindowTopic(project2);
            }

            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                CtxToolWindows.forEachToolWindow(project2, tw -> {
                    if (tw != null) {
                        TouchBarsManager.unregister(tw.getComponent());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxToolWindows$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    static synchronized void disable() {
        if (ourConnection != null) {
            ourConnection.disconnect();
        }
        ourConnection = null;
        ourProjConnections.forEach(mbc -> mbc.disconnect());
        ourProjConnections.clear();
    }

    private static void forEachToolWindow(@NotNull Project project2, Consumer<? super ToolWindow> func) {
        if (project2 == null) {
            CtxToolWindows.$$$reportNull$$$0(0);
        }
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project2);
        for (ToolWindow window : toolWindowManager.getToolWindows()) {
            func.accept((ToolWindow)window);
        }
    }

    private static void subscribeToolWindowTopic(@NotNull Project project2) {
        if (project2 == null) {
            CtxToolWindows.$$$reportNull$$$0(1);
        }
        if (project2.isDisposed()) {
            return;
        }
        LOG.debug("subscribe for ToolWindow topic of project %s", new Object[]{project2});
        MessageBusConnection pbc = project2.getMessageBus().connect();
        pbc.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
                if (ids == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (toolWindowManager == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (String id2 : ids) {
                    @Nullable Pair<Map<Long, ActionGroup>, Customizer> actions = ActionsLoader.getToolWindowActionGroup(id2);
                    if (actions == null || ((Map)actions.first).get(0L) == null) {
                        LOG.debug("null action group (or it doesn't contain main-layout) for tool window: %s", new Object[]{id2});
                        continue;
                    }
                    ToolWindow toolWindow2 = toolWindowManager.getToolWindow(id2);
                    if (toolWindow2 == null) continue;
                    TouchBarsManager.register((Component)toolWindow2.getComponent(), (Map)actions.first, (Customizer)actions.second);
                    LOG.debug("register tool-window '%s' for component: %s", new Object[]{id2, toolWindow2.getComponent()});
                }
            }

            @Override
            public void toolWindowUnregistered(@NotNull String id2, @NotNull ToolWindow toolWindow2) {
                if (id2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (toolWindow2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                TouchBarsManager.unregister(toolWindow2.getComponent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ids";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "toolWindowManager";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "toolWindow";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxToolWindows$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolWindowsRegistered";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolWindowUnregistered";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ourProjConnections.add((Object)pbc);
    }

    static void reloadAllActions() {
        for (Project p : ProjectUtilCore.getOpenProjects()) {
            if (p.isDisposed()) continue;
            CtxToolWindows.forEachToolWindow(p, tw -> {
                if (tw == null) {
                    return;
                }
                @Nullable Pair<Map<Long, ActionGroup>, Customizer> actions = ActionsLoader.getToolWindowActionGroup(tw.getId());
                if (actions == null || ((Map)actions.first).get(0L) == null) {
                    LOG.debug("reloaded null action group (or it doesn't contain main-layout) for tool window: %s", new Object[]{tw.getId()});
                    return;
                }
                TouchBarsManager.register((Component)tw.getComponent(), (Map)actions.first, (Customizer)actions.second);
                LOG.debug("re-register tool-window '%s' for component: %s", new Object[]{tw.getId(), tw.getComponent()});
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxToolWindows";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachToolWindow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribeToolWindowTopic";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

