/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.CachedTreePresentationNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNodeVisitor<T>
implements TreeVisitor {
    protected static final Logger LOG = Logger.getInstance(AbstractTreeNodeVisitor.class);
    private final Supplier<? extends T> supplier;
    private final Predicate<? super TreePath> predicate;

    public AbstractTreeNodeVisitor(@NotNull Supplier<? extends T> supplier, @Nullable Predicate<? super TreePath> predicate) {
        if (supplier == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(0);
        }
        this.supplier = supplier;
        this.predicate = predicate;
    }

    @NotNull
    public TreeVisitor.VisitThread visitThread() {
        TreeVisitor.VisitThread visitThread = TreeVisitor.VisitThread.BGT;
        if (visitThread == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(1);
        }
        return visitThread;
    }

    @Nullable
    public final T getElement() {
        return this.supplier.get();
    }

    @RequiresBackgroundThread
    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        T element;
        if (path == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (LOG.isTraceEnabled()) {
            LOG.debug("process ", new Object[]{path});
        }
        if ((element = this.getElement()) == null) {
            TreeVisitor.Action action2 = TreeVisitor.Action.SKIP_SIBLINGS;
            if (action2 == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(3);
            }
            return action2;
        }
        Object object = TreeUtil.getLastUserObject((TreePath)path);
        if (object instanceof AbstractTreeNode) {
            TreeVisitor.Action action3 = this.visit(path, (AbstractTreeNode)object, element);
            if (action3 == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(4);
            }
            return action3;
        }
        if (object instanceof String) {
            LOG.debug("ignore children: ", new Object[]{object});
        } else {
            if (object instanceof CachedTreePresentationNode) {
                TreeVisitor.Action action4 = TreeVisitor.Action.SKIP_CHILDREN;
                if (action4 == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(5);
                }
                return action4;
            }
            LOG.warn((String)(object == null ? "no object" : "unexpected object " + String.valueOf(object.getClass())));
        }
        TreeVisitor.Action action5 = TreeVisitor.Action.SKIP_CHILDREN;
        if (action5 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(6);
        }
        return action5;
    }

    @NotNull
    protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull AbstractTreeNode node, @NotNull T element) {
        if (path == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(7);
        }
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(8);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(9);
        }
        if (this.matches(node, element)) {
            LOG.debug("found ", new Object[]{path});
            if (this.predicate == null) {
                TreeVisitor.Action action2 = TreeVisitor.Action.INTERRUPT;
                if (action2 == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(10);
                }
                return action2;
            }
            if (this.predicate.test(path)) {
                TreeVisitor.Action action3 = TreeVisitor.Action.CONTINUE;
                if (action3 == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(11);
                }
                return action3;
            }
        } else if (this.contains(node, element)) {
            LOG.debug("visit ", new Object[]{path});
            TreeVisitor.Action action4 = TreeVisitor.Action.CONTINUE;
            if (action4 == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(12);
            }
            return action4;
        }
        TreeVisitor.Action action5 = TreeVisitor.Action.SKIP_CHILDREN;
        if (action5 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(13);
        }
        return action5;
    }

    protected boolean matches(@NotNull AbstractTreeNode<?> node, @NotNull T element) {
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(14);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(15);
        }
        return node.canRepresent(element);
    }

    protected boolean contains(@NotNull AbstractTreeNode<?> node, @NotNull T element) {
        T content2;
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(16);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(17);
        }
        return (content2 = this.getContent(node)) != null && this.isAncestor(content2, element);
    }

    protected T getContent(@NotNull AbstractTreeNode node) {
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(18);
        }
        return null;
    }

    protected boolean isAncestor(@NotNull T content2, @NotNull T element) {
        if (content2 == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(19);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(20);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "visitThread";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "visit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

