/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TreeAction
extends AbstractAction
implements UIResource {
    private static final List<TreeAction> ACTIONS = Arrays.asList(new TreeAction(TreeAction::selectFirst, "selectFirst", KeyStroke.getKeyStroke(36, 0)), new TreeAction(TreeAction::selectFirstChangeLead, "selectFirstChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectFirstExtendSelection, "selectFirstExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectLast, "selectLast", KeyStroke.getKeyStroke(35, 0)), new TreeAction(TreeAction::selectLastChangeLead, "selectLastChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectLastExtendSelection, "selectLastExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectPrevious, "selectPrevious", KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(224, 0)), new TreeAction(TreeAction::selectPreviousChangeLead, "selectPreviousChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectPreviousExtendSelection, "selectPreviousExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectNext, "selectNext", KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(225, 0)), new TreeAction(TreeAction::selectNextChangeLead, "selectNextChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectNextExtendSelection, "selectNextExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectParentNoCollapse, "selectParentNoCollapse", new KeyStroke[0]), new TreeAction(TreeAction::selectParent, "selectParent", KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(226, 0)), new TreeAction(TreeAction::selectChild, "selectChild", KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(227, 0)), new TreeAction(TreeAction::scrollUpChangeSelection, "scrollUpChangeSelection", KeyStroke.getKeyStroke(33, 0)), new TreeAction(TreeAction::scrollUpChangeLead, "scrollUpChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::scrollUpExtendSelection, "scrollUpExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::scrollDownChangeSelection, "scrollDownChangeSelection", KeyStroke.getKeyStroke(34, 0)), new TreeAction(TreeAction::scrollDownChangeLead, "scrollDownChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::scrollDownExtendSelection, "scrollDownExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectNextSibling, "selectNextSibling", new KeyStroke[0]), new TreeAction(TreeAction::selectPreviousSibling, "selectPreviousSibling", new KeyStroke[0]));
    private final String name;
    @NotNull
    private final Consumer<? super JTree> action;
    private final List<KeyStroke> keys;

    private TreeAction(@NotNull Consumer<? super JTree> action2, @NotNull @NonNls String name2, KeyStroke ... keys) {
        if (action2 == null) {
            TreeAction.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            TreeAction.$$$reportNull$$$0(1);
        }
        if (keys == null) {
            TreeAction.$$$reportNull$$$0(2);
        }
        this.name = name2;
        this.action = action2;
        this.keys = Arrays.asList(keys);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree) {
            this.action.accept((JTree)source);
        }
    }

    static void installTo(@NotNull ActionMap map2) {
        Object[] keys;
        if (map2 == null) {
            TreeAction.$$$reportNull$$$0(3);
        }
        if ((keys = map2.keys()) != null && keys.length != 0) {
            return;
        }
        for (TreeAction action2 : ACTIONS) {
            map2.put(action2.name, action2);
        }
    }

    static void installTo(@NotNull InputMap map2) {
        KeyStroke[] keys;
        if (map2 == null) {
            TreeAction.$$$reportNull$$$0(4);
        }
        if ((keys = map2.keys()) != null && keys.length != 0) {
            return;
        }
        for (TreeAction action2 : ACTIONS) {
            for (KeyStroke key : action2.keys) {
                map2.put(key, action2.name);
            }
        }
    }

    private static boolean isCycleScrollingAllowed(@NotNull MoveType type) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(5);
        }
        return type != MoveType.ExtendSelection && TreeUtil.isCyclicScrollingAllowed();
    }

    private static boolean isLeaf(@NotNull JTree tree2, @NotNull TreePath path) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(6);
        }
        if (path == null) {
            TreeAction.$$$reportNull$$$0(7);
        }
        return tree2.getModel().isLeaf(path.getLastPathComponent());
    }

    private static void lineDown(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(8);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(9);
        }
        TreePath lead = tree2.getLeadSelectionPath();
        int row2 = tree2.getRowForPath(lead);
        if (lead == null || row2 < 0) {
            TreeAction.selectFirstExceptSeparator(type, tree2);
        } else {
            row2 = TreeAction.findRowExceptSeparator(tree2, row2, false);
            if (TreeAction.isCycleScrollingAllowed(type) && row2 == tree2.getRowCount()) {
                row2 = 0;
            }
            TreeAction.selectExceptSeparator(type, tree2, row2);
        }
    }

    private static void lineUp(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(10);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(11);
        }
        TreePath lead = tree2.getLeadSelectionPath();
        int row2 = tree2.getRowForPath(lead);
        if (lead == null || row2 < 0) {
            TreeAction.selectFirstExceptSeparator(type, tree2);
        } else {
            if (row2 == 0 && TreeAction.isCycleScrollingAllowed(type)) {
                row2 = tree2.getRowCount();
            }
            row2 = TreeAction.findRowExceptSeparator(tree2, row2, true);
            TreeAction.selectExceptSeparator(type, tree2, row2);
        }
    }

    private static int findRowExceptSeparator(@NotNull JTree tree2, int row2, boolean up) {
        TreePath curPath;
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(12);
        }
        int curRow = row2;
        do {
            if (up) {
                --curRow;
                continue;
            }
            ++curRow;
        } while ((curPath = tree2.getPathForRow(curRow)) != null && DefaultTreeUI.isSeparator(curPath));
        return curRow;
    }

    private static void pageDown(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(13);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(14);
        }
        TreePath lead = tree2.getLeadSelectionPath();
        Rectangle bounds = tree2.getPathBounds(lead);
        if (lead == null || bounds == null) {
            TreeAction.selectLast(type, tree2);
        } else {
            int height = Math.max(tree2.getVisibleRect().height - bounds.height * 4, 1);
            TreePath next = tree2.getClosestPathForLocation(bounds.x, bounds.y + bounds.height + height);
            if (next != null && !next.equals(lead)) {
                TreeAction.select(type, tree2, next);
            }
        }
    }

    private static void pageUp(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(15);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(16);
        }
        TreePath lead = tree2.getLeadSelectionPath();
        Rectangle bounds = tree2.getPathBounds(lead);
        if (lead == null || bounds == null) {
            TreeAction.selectFirst(type, tree2);
        } else {
            int height = Math.max(tree2.getVisibleRect().height - bounds.height * 4, 1);
            TreePath next = tree2.getClosestPathForLocation(bounds.x, bounds.y - height);
            if (next != null && !next.equals(lead)) {
                TreeAction.select(type, tree2, next);
            }
        }
    }

    private static void select(@NotNull MoveType type, @NotNull JTree tree2, int row2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(17);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(18);
        }
        TreeAction.select(type, tree2, tree2.getPathForRow(row2), row2);
    }

    private static void select(@NotNull MoveType type, @NotNull JTree tree2, @NotNull TreePath path) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(19);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(20);
        }
        if (path == null) {
            TreeAction.$$$reportNull$$$0(21);
        }
        TreeAction.select(type, tree2, path, tree2.getRowForPath(path));
    }

    private static void select(@NotNull MoveType type, @NotNull JTree tree2, @Nullable TreePath path, int row2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(22);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(23);
        }
        if (path == null || row2 < 0) {
            return;
        }
        if (type == MoveType.ExtendSelection) {
            int anchorRow;
            TreePath anchor = tree2.getAnchorSelectionPath();
            int n = anchorRow = anchor == null ? -1 : tree2.getRowForPath(anchor);
            if (anchorRow < 0) {
                tree2.setSelectionPath(path);
            } else {
                tree2.setSelectionInterval(row2, anchorRow);
                tree2.setAnchorSelectionPath(anchor);
                tree2.setLeadSelectionPath(path);
            }
        } else if (type == MoveType.ChangeLead && 4 == tree2.getSelectionModel().getSelectionMode()) {
            tree2.setLeadSelectionPath(path);
        } else {
            tree2.setSelectionPath(path);
        }
        TreeUtil.scrollToVisible((JTree)tree2, (TreePath)path, (boolean)false);
    }

    private static void selectChild(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(24);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(25);
        }
        TreePath lead = tree2.getLeadSelectionPath();
        int row2 = tree2.getRowForPath(lead);
        if (lead == null || row2 < 0) {
            TreeAction.selectFirst(type, tree2);
        } else if (tree2.isExpanded(lead) || TreeAction.isLeaf(tree2, lead)) {
            TreePath path = tree2.getPathForRow(row2 + 1);
            if (!TreeUtil.isLoadingPath((TreePath)path)) {
                TreeAction.select(type, tree2, path, row2 + 1);
            }
        } else {
            if (tree2 instanceof Tree) {
                ((Tree)tree2).startMeasuringExpandDuration(lead);
            }
            tree2.expandPath(lead);
        }
    }

    private static void selectFirst(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(26);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(27);
        }
        TreeAction.select(type, tree2, 0);
    }

    private static void selectFirstExceptSeparator(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(28);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(29);
        }
        TreeAction.selectExceptSeparator(type, tree2, 0);
    }

    private static void selectExceptSeparator(@NotNull MoveType type, @NotNull JTree tree2, int row2) {
        TreePath path;
        if (type == null) {
            TreeAction.$$$reportNull$$$0(30);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(31);
        }
        if (!DefaultTreeUI.isSeparator(path = tree2.getPathForRow(row2))) {
            TreeAction.select(type, tree2, path, row2);
        }
    }

    private static void selectLast(@NotNull MoveType type, @NotNull JTree tree2) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(32);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(33);
        }
        TreeAction.select(type, tree2, tree2.getRowCount() - 1);
    }

    private static void selectParent(@NotNull MoveType type, @NotNull JTree tree2, boolean canCollapse) {
        if (type == null) {
            TreeAction.$$$reportNull$$$0(34);
        }
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(35);
        }
        TreePath lead = tree2.getLeadSelectionPath();
        int row2 = tree2.getRowForPath(lead);
        if (lead == null || row2 < 0) {
            TreeAction.selectFirst(type, tree2);
        } else if (canCollapse && tree2.isExpanded(lead)) {
            tree2.collapsePath(lead);
        } else {
            TreePath parent = lead.getParentPath();
            if (parent != null) {
                if (tree2.isRootVisible() || null != parent.getParentPath()) {
                    TreeAction.select(type, tree2, parent);
                } else if (row2 > 0) {
                    TreePath path = TreeUtil.previousVisiblePath((JTree)tree2, (int)row2, (boolean)false, tree2::isExpanded);
                    TreeAction.select(type, tree2, path != null ? path : tree2.getPathForRow(0), path == null ? 0 : tree2.getRowForPath(path));
                }
            }
        }
    }

    private static void selectNextSibling(@NotNull JTree tree2) {
        TreePath sibling;
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(36);
        }
        if ((sibling = TreeUtil.nextVisibleSibling((JTree)tree2, (TreePath)tree2.getLeadSelectionPath())) == null) {
            return;
        }
        tree2.setSelectionPath(sibling);
        TreeUtil.scrollToVisible((JTree)tree2, (TreePath)sibling, (boolean)false);
    }

    private static void selectPreviousSibling(@NotNull JTree tree2) {
        TreePath sibling;
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(37);
        }
        if ((sibling = TreeUtil.previousVisibleSibling((JTree)tree2, (TreePath)tree2.getLeadSelectionPath())) == null) {
            return;
        }
        tree2.setSelectionPath(sibling);
        TreeUtil.scrollToVisible((JTree)tree2, (TreePath)sibling, (boolean)false);
    }

    private static void addToSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(38);
        }
    }

    private static void cancel(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(39);
        }
    }

    private static void clearSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(40);
        }
    }

    private static void collapse(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(41);
        }
    }

    private static void expand(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(42);
        }
    }

    private static void extendTo(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(43);
        }
    }

    private static void moveSelectionTo(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(44);
        }
    }

    private static void moveSelectionToParent(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(45);
        }
    }

    private static void scrollDownChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(46);
        }
        TreeAction.pageDown(MoveType.ChangeLead, tree2);
    }

    private static void scrollDownChangeSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(47);
        }
        TreeAction.pageDown(MoveType.ChangeSelection, tree2);
    }

    private static void scrollDownExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(48);
        }
        TreeAction.pageDown(MoveType.ExtendSelection, tree2);
    }

    private static void scrollLeft(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(49);
        }
    }

    private static void scrollLeftChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(50);
        }
    }

    private static void scrollLeftExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(51);
        }
    }

    private static void scrollRight(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(52);
        }
    }

    private static void scrollRightChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(53);
        }
    }

    private static void scrollRightExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(54);
        }
    }

    private static void scrollUpChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(55);
        }
        TreeAction.pageUp(MoveType.ChangeLead, tree2);
    }

    private static void scrollUpChangeSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(56);
        }
        TreeAction.pageUp(MoveType.ChangeSelection, tree2);
    }

    private static void scrollUpExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(57);
        }
        TreeAction.pageUp(MoveType.ExtendSelection, tree2);
    }

    private static void selectAll(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(58);
        }
    }

    private static void selectChild(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(59);
        }
        TreeAction.selectChild(MoveType.ChangeSelection, tree2);
    }

    private static void selectChildChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(60);
        }
        TreeAction.selectChild(MoveType.ChangeLead, tree2);
    }

    private static void selectChildExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(61);
        }
        TreeAction.selectChild(MoveType.ExtendSelection, tree2);
    }

    private static void selectFirst(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(62);
        }
        TreeAction.selectFirst(MoveType.ChangeSelection, tree2);
    }

    private static void selectFirstChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(63);
        }
        TreeAction.selectFirst(MoveType.ChangeLead, tree2);
    }

    private static void selectFirstExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(64);
        }
        TreeAction.selectFirst(MoveType.ExtendSelection, tree2);
    }

    private static void selectLast(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(65);
        }
        TreeAction.selectLast(MoveType.ChangeSelection, tree2);
    }

    private static void selectLastChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(66);
        }
        TreeAction.selectLast(MoveType.ChangeLead, tree2);
    }

    private static void selectLastExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(67);
        }
        TreeAction.selectLast(MoveType.ExtendSelection, tree2);
    }

    private static void selectNext(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(68);
        }
        TreeAction.lineDown(MoveType.ChangeSelection, tree2);
    }

    private static void selectNextChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(69);
        }
        TreeAction.lineDown(MoveType.ChangeLead, tree2);
    }

    private static void selectNextExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(70);
        }
        TreeAction.lineDown(MoveType.ExtendSelection, tree2);
    }

    private static void selectParent(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(71);
        }
        TreeAction.selectParent(MoveType.ChangeSelection, tree2, true);
    }

    private static void selectParentNoCollapse(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(72);
        }
        TreeAction.selectParent(MoveType.ChangeSelection, tree2, false);
    }

    private static void selectParentChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(73);
        }
        TreeAction.selectParent(MoveType.ChangeLead, tree2, false);
    }

    private static void selectParentExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(74);
        }
        TreeAction.selectParent(MoveType.ExtendSelection, tree2, false);
    }

    private static void selectPrevious(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(75);
        }
        TreeAction.lineUp(MoveType.ChangeSelection, tree2);
    }

    private static void selectPreviousChangeLead(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(76);
        }
        TreeAction.lineUp(MoveType.ChangeLead, tree2);
    }

    private static void selectPreviousExtendSelection(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(77);
        }
        TreeAction.lineUp(MoveType.ExtendSelection, tree2);
    }

    private static void startEditing(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(78);
        }
    }

    private static void toggle(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(79);
        }
    }

    private static void toggleAndAnchor(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeAction.$$$reportNull$$$0(80);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/ui/TreeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCycleScrollingAllowed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isLeaf";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lineDown";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lineUp";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findRowExceptSeparator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "pageDown";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "pageUp";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 24: 
            case 25: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[2] = "selectChild";
                break;
            }
            case 26: 
            case 27: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFirst";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFirstExceptSeparator";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "selectExceptSeparator";
                break;
            }
            case 32: 
            case 33: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[2] = "selectLast";
                break;
            }
            case 34: 
            case 35: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[2] = "selectParent";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "selectNextSibling";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPreviousSibling";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "addToSelection";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "cancel";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "clearSelection";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "collapse";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "expand";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "extendTo";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "moveSelectionTo";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "moveSelectionToParent";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollDownChangeLead";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollDownChangeSelection";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollDownExtendSelection";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollLeft";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollLeftChangeLead";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollLeftExtendSelection";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollRight";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollRightChangeLead";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollRightExtendSelection";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollUpChangeLead";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollUpChangeSelection";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollUpExtendSelection";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[2] = "selectAll";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[2] = "selectChildChangeLead";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[2] = "selectChildExtendSelection";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFirstChangeLead";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFirstExtendSelection";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[2] = "selectLastChangeLead";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[2] = "selectLastExtendSelection";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[2] = "selectNext";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[2] = "selectNextChangeLead";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[2] = "selectNextExtendSelection";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[2] = "selectParentNoCollapse";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[2] = "selectParentChangeLead";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[2] = "selectParentExtendSelection";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPrevious";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPreviousChangeLead";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPreviousExtendSelection";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[2] = "startEditing";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[2] = "toggle";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleAndAnchor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum MoveType {
        ChangeLead,
        ChangeSelection,
        ExtendSelection;

    }
}

