/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u001c\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/util/NetworkUtils;", "", "<init>", "()V", "FIND_PORT_ATTEMPTS_COUNT", "", "isPortFree", "", "port", "findFreePort", "bannedPorts", "", "intellij.platform.ide.impl"})
public final class NetworkUtils {
    @NotNull
    public static final NetworkUtils INSTANCE = new NetworkUtils();
    private static final int FIND_PORT_ATTEMPTS_COUNT = 5;

    private NetworkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isPortFree(int port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, 0, InetAddress.getByName("127.0.0.1"));
            socket.setReuseAddress(true);
            boolean bl = true;
            socket.close();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            block5: {
                ServerSocket serverSocket = socket;
                if (serverSocket == null) break block5;
                serverSocket.close();
            }
        }
    }

    public final int findFreePort() {
        return this.findFreePort(0);
    }

    public final int findFreePort(int port) {
        if (port > 0 && this.isPortFree(port)) {
            return port;
        }
        ServerSocket socket1 = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
        int result2 = socket1.getLocalPort();
        socket1.setReuseAddress(true);
        socket1.close();
        return result2;
    }

    public final int findFreePort(int port, @NotNull Set<Integer> bannedPorts) {
        Intrinsics.checkNotNullParameter(bannedPorts, (String)"bannedPorts");
        if (port > 0 && this.isPortFree(port) && !bannedPorts.contains(port)) {
            return port;
        }
        for (int attempt = 0; attempt < 5; ++attempt) {
            ServerSocket socket1 = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            int result2 = socket1.getLocalPort();
            socket1.setReuseAddress(true);
            socket1.close();
            if (bannedPorts.contains(result2)) continue;
            return result2;
        }
        throw new IllegalStateException("Failed to find free ports (base port " + port + ") using 5 attempts");
    }
}

