/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.tree.TreeUtil;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class CertificateTreeBuilder
implements Disposable {
    private static final SimpleTextAttributes STRIKEOUT_ATTRIBUTES = new SimpleTextAttributes(4, null);
    private static final RootDescriptor ROOT_DESCRIPTOR = new RootDescriptor();
    private final MultiMap<String, CertificateWrapper> myCertificates;
    private final StructureTreeModel<MyTreeStructure> myStructureTreeModel;
    private final Tree myTree;
    private static final Comparator<NodeDescriptor<?>> NODE_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof OrganizationDescriptor && o2 instanceof OrganizationDescriptor) {
            return ((String)o1.getElement()).compareTo((String)o2.getElement());
        }
        if (o1 instanceof CertificateDescriptor && o2 instanceof CertificateDescriptor) {
            String cn1 = ((CertificateWrapper)((CertificateDescriptor)((Object)o1)).getElement()).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
            String cn2 = ((CertificateWrapper)((CertificateDescriptor)((Object)o2)).getElement()).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
            return cn1.compareTo(cn2);
        }
        return 0;
    };

    public CertificateTreeBuilder(@NotNull Tree tree2) {
        if (tree2 == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(0);
        }
        this.myCertificates = new MultiMap();
        this.myTree = tree2;
        MyTreeStructure treeStructure = new MyTreeStructure();
        this.myStructureTreeModel = new StructureTreeModel<MyTreeStructure>(treeStructure, NODE_COMPARATOR, this);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myStructureTreeModel), this);
        tree2.setModel((TreeModel)((Object)asyncTreeModel));
    }

    public void reset(@NotNull Collection<? extends X509Certificate> certificates) {
        if (certificates == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(1);
        }
        this.myCertificates.clear();
        for (X509Certificate x509Certificate : certificates) {
            this.addCertificate(x509Certificate);
        }
        this.myStructureTreeModel.invalidateAsync();
        TreeUtil.expandAll((JTree)this.myTree);
    }

    public void addCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(2);
        }
        CertificateWrapper wrapper2 = new CertificateWrapper(certificate);
        this.myCertificates.putValue((Object)wrapper2.getSubjectField(CertificateWrapper.CommonField.ORGANIZATION), (Object)wrapper2);
        this.myStructureTreeModel.invalidateAsync();
    }

    public void removeCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(3);
        }
        CertificateWrapper wrapper2 = new CertificateWrapper(certificate);
        this.myCertificates.remove((Object)wrapper2.getSubjectField(CertificateWrapper.CommonField.ORGANIZATION), (Object)wrapper2);
        this.myStructureTreeModel.invalidateAsync();
    }

    public @Unmodifiable List<X509Certificate> getCertificates() {
        return ContainerUtil.map((Collection)this.myCertificates.values(), wrapper2 -> wrapper2.getCertificate());
    }

    public boolean isEmpty() {
        return this.myCertificates.isEmpty();
    }

    public void selectCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(4);
        }
        this.myStructureTreeModel.select(new CertificateWrapper(certificate), (JTree)this.myTree, path -> {});
    }

    public void selectFirstCertificate() {
        TreeUtil.promiseSelectFirstLeaf((JTree)this.myTree);
    }

    @NotNull
    public Set<X509Certificate> getSelectedCertificates(boolean addFromOrganization) {
        HashSet<X509Certificate> selected = new HashSet<X509Certificate>();
        TreeUtil.collectSelectedUserObjects((JTree)this.myTree).forEach(o -> {
            if (o instanceof CertificateDescriptor) {
                selected.add(((CertificateWrapper)((CertificateDescriptor)((Object)((Object)o))).getElement()).getCertificate());
            } else if (o instanceof OrganizationDescriptor) {
                if (addFromOrganization) {
                    selected.addAll(this.getCertificatesByOrganization((String)((OrganizationDescriptor)((Object)((Object)o))).getElement()));
                }
            } else if (!(o instanceof RootDescriptor)) {
                Logger.getInstance(this.getClass()).error("Unknown tree node object of type: " + o.getClass().getName());
            }
        });
        HashSet<X509Certificate> hashSet = selected;
        if (hashSet == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Nullable
    public X509Certificate getFirstSelectedCertificate(boolean addFromOrganization) {
        Set<X509Certificate> certificates = this.getSelectedCertificates(addFromOrganization);
        return certificates.isEmpty() ? null : certificates.iterator().next();
    }

    public @Unmodifiable @NotNull List<X509Certificate> getCertificatesByOrganization(@NotNull String organizationName) {
        if (organizationName == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(6);
        }
        Collection wrappers = this.myCertificates.get((Object)organizationName);
        List<X509Certificate> list2 = CertificateTreeBuilder.extract(wrappers);
        if (list2 == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public void dispose() {
    }

    private static @Unmodifiable List<X509Certificate> extract(Collection<CertificateWrapper> wrappers) {
        return ContainerUtil.map(wrappers, wrapper2 -> wrapper2.getCertificate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificates";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateTreeBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "organizationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCertificates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCertificatesByOrganization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCertificate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeCertificate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectCertificate";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCertificatesByOrganization";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }

    final class MyTreeStructure
    extends AbstractTreeStructure {
        MyTreeStructure() {
        }

        @NotNull
        public Object getRootElement() {
            Object object = RootDescriptor.ROOT;
            if (object == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            return object;
        }

        public Object @NotNull [] getChildElements(@NotNull Object element) {
            if (element == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            if (element == RootDescriptor.ROOT) {
                Object[] objectArray = ArrayUtilRt.toStringArray((Collection)CertificateTreeBuilder.this.myCertificates.keySet());
                if (objectArray == null) {
                    MyTreeStructure.$$$reportNull$$$0(2);
                }
                return objectArray;
            }
            if (element instanceof String) {
                Object[] objectArray = ArrayUtil.toObjectArray((Collection)CertificateTreeBuilder.this.myCertificates.get((Object)((String)element)));
                if (objectArray == null) {
                    MyTreeStructure.$$$reportNull$$$0(3);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                MyTreeStructure.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Nullable
        public Object getParentElement(@NotNull Object element) {
            if (element == null) {
                MyTreeStructure.$$$reportNull$$$0(5);
            }
            if (element == RootDescriptor.ROOT) {
                return null;
            }
            if (element instanceof String) {
                return RootDescriptor.ROOT;
            }
            return ((CertificateWrapper)element).getSubjectField(CertificateWrapper.CommonField.ORGANIZATION);
        }

        @NotNull
        public NodeDescriptor<?> createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
            if (element == null) {
                MyTreeStructure.$$$reportNull$$$0(6);
            }
            if (element == RootDescriptor.ROOT) {
                RootDescriptor rootDescriptor = ROOT_DESCRIPTOR;
                if (rootDescriptor == null) {
                    MyTreeStructure.$$$reportNull$$$0(7);
                }
                return rootDescriptor;
            }
            if (element instanceof String) {
                return new OrganizationDescriptor(parentDescriptor, (String)element);
            }
            return new CertificateDescriptor(parentDescriptor, (CertificateWrapper)element);
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/net/ssl/CertificateTreeBuilder$MyTreeStructure";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootElement";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder$MyTreeStructure";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildElements";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildElements";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class CertificateDescriptor
    extends MyNodeDescriptor<CertificateWrapper> {
        private CertificateDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull CertificateWrapper object) {
            if (object == null) {
                CertificateDescriptor.$$$reportNull$$$0(0);
            }
            super(parentDescriptor, object);
        }

        protected void update(@NotNull PresentationData presentation2) {
            CertificateWrapper wrapper2;
            if (presentation2 == null) {
                CertificateDescriptor.$$$reportNull$$$0(1);
            }
            SimpleTextAttributes attr = (wrapper2 = (CertificateWrapper)this.getElement()).isValid() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : STRIKEOUT_ATTRIBUTES;
            presentation2.addText(wrapper2.getSubjectField(CertificateWrapper.CommonField.COMMON_NAME), attr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder$CertificateDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class OrganizationDescriptor
    extends MyNodeDescriptor<String> {
        private OrganizationDescriptor(@Nullable NodeDescriptor parentDescriptor, @Nls @NotNull String object) {
            if (object == null) {
                OrganizationDescriptor.$$$reportNull$$$0(0);
            }
            super(parentDescriptor, object);
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                OrganizationDescriptor.$$$reportNull$$$0(1);
            }
            presentation2.addText((String)this.getElement(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder$OrganizationDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class RootDescriptor
    extends MyNodeDescriptor<Object> {
        public static final Object ROOT = new Object();

        private RootDescriptor() {
            super(null, ROOT);
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                RootDescriptor.$$$reportNull$$$0(0);
            }
            presentation2.addText(IdeBundle.message((String)"label.certificate.root", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/util/net/ssl/CertificateTreeBuilder$RootDescriptor", "update"));
        }
    }

    static abstract class MyNodeDescriptor<T>
    extends PresentableNodeDescriptor<T> {
        private final T myObject;

        MyNodeDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull T object) {
            if (object == null) {
                MyNodeDescriptor.$$$reportNull$$$0(0);
            }
            super(null, parentDescriptor);
            this.myObject = object;
        }

        public T getElement() {
            return this.myObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/net/ssl/CertificateTreeBuilder$MyNodeDescriptor", "<init>"));
        }
    }
}

