/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class OwnerOptional {
    @Nullable
    public static Window findOwner(@Nullable Component parent) {
        Dialog ownerDialog;
        Window owner;
        if (parent == null && (parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null) {
            parent = Window.getWindows()[0];
        }
        Window window = owner = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (!(!IdeEventQueue.getInstance().getPopupManager().isPopupWindow(owner) || owner.isFocused() && SystemInfo.isJetBrainsJvm)) {
            while (UIUtil.isSimpleWindow((Window)(owner = owner.getOwner()))) {
            }
        }
        if (owner instanceof Dialog && !(ownerDialog = (Dialog)owner).isModal() && !UIUtil.isPossibleOwner((Dialog)ownerDialog)) {
            Dialog ownerDialog2;
            while (owner instanceof Dialog && !(ownerDialog2 = (Dialog)owner).isModal()) {
                owner = owner.getOwner();
            }
        }
        while (owner != null && !owner.isShowing()) {
            owner = owner.getOwner();
        }
        if (UIUtil.isSimpleWindow((Window)owner)) {
            owner = null;
        }
        return owner;
    }

    public static <T> T create(@Nullable Component parent, Function<Dialog, T> forDialog, Function<@Nullable Frame, T> forFrame) {
        Window owner = OwnerOptional.findOwner(parent);
        if (owner instanceof Dialog) {
            Dialog dialog2 = (Dialog)owner;
            return forDialog.apply(dialog2);
        }
        if (owner instanceof IdeFrame.Child) {
            IdeFrame.Child childFrame = (IdeFrame.Child)owner;
            owner = WindowManager.getInstance().getFrame(childFrame.getProject());
        }
        return forFrame.apply((Frame)owner);
    }
}

