/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelCache;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelSerializerHook;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.impl.ConsistencyCheckerKt;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImplKt;
import com.intellij.platform.workspace.storage.instrumentation.EntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.url.UrlRelativizer;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.ide.impl.JpsMetricsKt;
import com.intellij.workspaceModel.ide.impl.JpsProjectUrlRelativizersKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheSerializer;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheSerializerKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelFusLogger;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 72\u00020\u0001:\u00017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010'\u001a\u00020\u0014H\u0002J\b\u0010(\u001a\u00020\u0010H\u0017J\b\u0010)\u001a\u00020\u0010H\u0007J\b\u0010*\u001a\u00020\u0010H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00100\u001a\u00020\u0014H\u0007J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\n\u00103\u001a\u0004\u0018\u000102H\u0016J\u0010\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0012H\u0016J\b\u00106\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R#\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0018\u001a\u0004\b\u001b\u0010\u0016R#\u0010\u001d\u001a\n \u001a*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b\u001e\u0010\u0016R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0018\u001a\u0004\b$\u0010%\u00a8\u00068"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelCache;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "enabled", "", "getEnabled", "()Z", "isCacheSaved", "Ljava/util/concurrent/atomic/AtomicBoolean;", "saveRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "cacheFile", "Ljava/nio/file/Path;", "getCacheFile", "()Ljava/nio/file/Path;", "cacheFile$delegate", "Lkotlin/Lazy;", "unloadedEntitiesCacheFile", "kotlin.jvm.PlatformType", "getUnloadedEntitiesCacheFile", "unloadedEntitiesCacheFile$delegate", "invalidateProjectCacheMarkerFile", "getInvalidateProjectCacheMarkerFile", "invalidateProjectCacheMarkerFile$delegate", "urlRelativizer", "Lcom/intellij/platform/workspace/storage/url/UrlRelativizer;", "cacheSerializer", "Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer;", "getCacheSerializer", "()Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheSerializer;", "cacheSerializer$delegate", "initCacheFile", "saveCacheNow", "doCacheSavingOnProjectClose", "doCacheSaving", "prepareStorage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "prepareUnloadedStorage", "getUnloadedEntitiesCacheFilePath", "loadCache", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "loadUnloadedEntitiesCache", "setVirtualFileUrlManager", "vfuManager", "invalidateProjectCache", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWorkspaceModelCacheImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelCacheImpl.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,231:1\n44#2,2:232\n46#2:241\n29#3,2:234\n31#3:240\n24#4:236\n63#4,3:237\n95#4:242\n135#4,3:243\n13#5:246\n*S KotlinDebug\n*F\n+ 1 WorkspaceModelCacheImpl.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl\n*L\n117#1:232,2\n117#1:241\n117#1:234,2\n117#1:240\n130#1:236\n130#1:237,3\n169#1:242\n169#1:243,3\n192#1:246\n*E\n"})
public final class WorkspaceModelCacheImpl
implements WorkspaceModelCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean isCacheSaved;
    @NotNull
    private final MutableSharedFlow<Unit> saveRequests;
    private VirtualFileUrlManager virtualFileUrlManager;
    @NotNull
    private final Lazy cacheFile$delegate;
    @NotNull
    private final Lazy unloadedEntitiesCacheFile$delegate;
    @NotNull
    private final Lazy invalidateProjectCacheMarkerFile$delegate;
    @Nullable
    private final UrlRelativizer urlRelativizer;
    @NotNull
    private final Lazy cacheSerializer$delegate;
    @NotNull
    private static final ExtensionPointName<WorkspaceModelSerializerHook> SERIALIZER_HOOKS = new ExtensionPointName("com.intellij.workspaceModel.serializerHook");
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String DATA_DIR_NAME = "project-model-cache";
    private static boolean forceEnableCaching;
    @TestOnly
    @Nullable
    private static Path testCacheFile;
    @NotNull
    private static final AtomicBoolean cachesInvalidated;
    @NotNull
    private static final Path invalidateCachesMarkerFile;
    @NotNull
    private static final AtomicLong saveWorkspaceModelCachesTimeMs;

    public WorkspaceModelCacheImpl(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.isCacheSaved = new AtomicBoolean(true);
        this.saveRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.cacheFile$delegate = LazyKt.lazy(() -> WorkspaceModelCacheImpl.cacheFile_delegate$lambda$0(this));
        this.unloadedEntitiesCacheFile$delegate = LazyKt.lazy(() -> WorkspaceModelCacheImpl.unloadedEntitiesCacheFile_delegate$lambda$0(this));
        this.invalidateProjectCacheMarkerFile$delegate = LazyKt.lazy(() -> WorkspaceModelCacheImpl.invalidateProjectCacheMarkerFile_delegate$lambda$0(this));
        this.urlRelativizer = Registry.Companion.is("ide.workspace.model.store.relative.paths.in.cache", false) ? JpsProjectUrlRelativizersKt.createJpsProjectUrlRelativizer(this.project) : null;
        this.cacheSerializer$delegate = LazyKt.lazy(() -> WorkspaceModelCacheImpl.cacheSerializer_delegate$lambda$0(this));
        if (this.getEnabled()) {
            LOG.debug("Project Model Cache at " + this.getCacheFile());
            this.project.getMessageBus().connect(coroutineScope).subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

                public void changed(VersionedStorageChange event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    LOG.debug("Schedule cache update");
                    if (!saveRequests.tryEmit((Object)Unit.INSTANCE)) {
                        throw new IllegalStateException("Check failed.");
                    }
                    isCacheSaved.set(false);
                }
            });
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WorkspaceModelCacheImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.saveRequests), (long)DurationKt.toDuration((int)1000, (DurationUnit)DurationUnit.MILLISECONDS)).collect(new FlowCollector(){

                                public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                    Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                                        int label;
                                        final /* synthetic */ WorkspaceModelCacheImpl this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.this$0.doCacheSaving();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public boolean getEnabled() {
        return forceEnableCaching || !ApplicationManager.getApplication().isUnitTestMode();
    }

    @NotNull
    public Path getCacheFile() {
        Lazy lazy = this.cacheFile$delegate;
        return (Path)lazy.getValue();
    }

    private final Path getUnloadedEntitiesCacheFile() {
        Lazy lazy = this.unloadedEntitiesCacheFile$delegate;
        return (Path)lazy.getValue();
    }

    private final Path getInvalidateProjectCacheMarkerFile() {
        Lazy lazy = this.invalidateProjectCacheMarkerFile$delegate;
        return (Path)lazy.getValue();
    }

    private final WorkspaceModelCacheSerializer getCacheSerializer() {
        Lazy lazy = this.cacheSerializer$delegate;
        return (WorkspaceModelCacheSerializer)lazy.getValue();
    }

    private final Path initCacheFile() {
        if (ApplicationManager.getApplication().isUnitTestMode() && testCacheFile != null) {
            Path path = testCacheFile;
            Intrinsics.checkNotNull((Object)path);
            Path testFile = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(testFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new IllegalStateException("Test cache file defined, but doesn't exist".toString());
            }
            return testFile;
        }
        Path path = ProjectUtil.getProjectDataPath((Project)this.project, (String)DATA_DIR_NAME).resolve("cache.data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @TestOnly
    public void saveCacheNow() {
        this.doCacheSaving();
    }

    @ApiStatus.Internal
    public final void doCacheSavingOnProjectClose() {
        if (this.isCacheSaved.get()) {
            return;
        }
        this.doCacheSaving();
    }

    private final void doCacheSaving() {
        AtomicLong atomicLong = saveWorkspaceModelCachesTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        this.isCacheSaved.set(true);
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        ImmutableEntityStorage storage = this.prepareStorage(workspaceModel);
        ImmutableEntityStorage unloadedStorage = this.prepareUnloadedStorage(workspaceModel);
        if (!ImmutableEntityStorageImplKt.isConsistent((EntityStorage)((EntityStorage)storage)) || !ImmutableEntityStorageImplKt.isConsistent((EntityStorage)((EntityStorage)unloadedStorage))) {
            this.invalidateProjectCache();
        }
        if (!cachesInvalidated.get()) {
            LOG.debug("Saving project model cache to " + this.getCacheFile());
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl4 = false;
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)storage));
            long assertConsistencyDuration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            WorkspaceModelCacheSerializer.SaveInfo saveInfo = this.getCacheSerializer().saveCacheToFile$intellij_platform_ide_impl(storage, this.getCacheFile());
            long timeMs = saveInfo.component1();
            Long size2 = saveInfo.component2();
            Long l = size2;
            WorkspaceModelFusLogger.INSTANCE.logCacheSave(timeMs + Duration.getInWholeMilliseconds-impl((long)assertConsistencyDuration), l != null ? l : -1L);
            Intrinsics.checkNotNull((Object)unloadedStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.EntityStorageInstrumentation");
            if (!((EntityStorageInstrumentation)unloadedStorage).isEmpty()) {
                LOG.debug("Saving project model cache to " + this.getUnloadedEntitiesCacheFile());
                ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)unloadedStorage));
                WorkspaceModelCacheSerializer workspaceModelCacheSerializer = this.getCacheSerializer();
                Path path = this.getUnloadedEntitiesCacheFile();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-unloadedEntitiesCacheFile>(...)");
                v3 = workspaceModelCacheSerializer.saveCacheToFile$intellij_platform_ide_impl(unloadedStorage, path);
            } else {
                v3 = Files.deleteIfExists(this.getUnloadedEntitiesCacheFile());
            }
        } else {
            Files.deleteIfExists(this.getCacheFile());
            v3 = Files.deleteIfExists(this.getUnloadedEntitiesCacheFile());
        }
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final ImmutableEntityStorage prepareStorage(WorkspaceModel workspaceModel) {
        Ref.ObjectRef current = new Ref.ObjectRef();
        current.element = workspaceModel.getCurrentSnapshot();
        SERIALIZER_HOOKS.forEachExtensionSafe(arg_0 -> WorkspaceModelCacheImpl.prepareStorage$lambda$1(arg_0 -> WorkspaceModelCacheImpl.prepareStorage$lambda$0(current, arg_0), arg_0));
        return (ImmutableEntityStorage)current.element;
    }

    private final ImmutableEntityStorage prepareUnloadedStorage(WorkspaceModel workspaceModel) {
        Ref.ObjectRef current = new Ref.ObjectRef();
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
        current.element = ((WorkspaceModelInternal)workspaceModel).getCurrentSnapshotOfUnloadedEntities();
        SERIALIZER_HOOKS.forEachExtensionSafe(arg_0 -> WorkspaceModelCacheImpl.prepareUnloadedStorage$lambda$1(arg_0 -> WorkspaceModelCacheImpl.prepareUnloadedStorage$lambda$0(current, arg_0), arg_0));
        return (ImmutableEntityStorage)current.element;
    }

    @TestOnly
    @NotNull
    public final Path getUnloadedEntitiesCacheFilePath() {
        Path path = this.getUnloadedEntitiesCacheFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-unloadedEntitiesCacheFile>(...)");
        return path;
    }

    @Nullable
    public MutableEntityStorage loadCache() {
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        WorkspaceModelCacheSerializer workspaceModelCacheSerializer = this.getCacheSerializer();
        Path path = this.getCacheFile();
        Path path2 = this.getInvalidateProjectCacheMarkerFile();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"<get-invalidateProjectCacheMarkerFile>(...)");
        MutableEntityStorage result$iv$iv = workspaceModelCacheSerializer.loadCacheFromFile$intellij_platform_ide_impl(path, invalidateCachesMarkerFile, path2);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        MutableEntityStorage cache = (MutableEntityStorage)timedValue.component1();
        long time = timedValue.component2-UwyO8pc();
        WorkspaceModelFusLogger.INSTANCE.logCacheLoading(cache != null ? Duration.getInWholeMilliseconds-impl((long)time) : -1L);
        return cache;
    }

    @Nullable
    public MutableEntityStorage loadUnloadedEntitiesCache() {
        WorkspaceModelCacheSerializer workspaceModelCacheSerializer = this.getCacheSerializer();
        Path path = this.getUnloadedEntitiesCacheFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-unloadedEntitiesCacheFile>(...)");
        Path path2 = this.getInvalidateProjectCacheMarkerFile();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"<get-invalidateProjectCacheMarkerFile>(...)");
        return workspaceModelCacheSerializer.loadCacheFromFile$intellij_platform_ide_impl(path, invalidateCachesMarkerFile, path2);
    }

    public void setVirtualFileUrlManager(@NotNull VirtualFileUrlManager vfuManager) {
        Intrinsics.checkNotNullParameter((Object)vfuManager, (String)"vfuManager");
        this.virtualFileUrlManager = vfuManager;
    }

    private final void invalidateProjectCache() {
        LOG.info("Invalidating project model cache by creating " + this.getInvalidateProjectCacheMarkerFile());
        Path path = this.getInvalidateProjectCacheMarkerFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-invalidateProjectCacheMarkerFile>(...)");
        WorkspaceModelCacheSerializerKt.invalidateCaches(cachesInvalidated, path);
    }

    private static final Path cacheFile_delegate$lambda$0(WorkspaceModelCacheImpl this$0) {
        return this$0.initCacheFile();
    }

    private static final Path unloadedEntitiesCacheFile_delegate$lambda$0(WorkspaceModelCacheImpl this$0) {
        return ProjectUtil.getProjectDataPath((Project)this$0.project, (String)DATA_DIR_NAME).resolve("unloaded-entities-cache.data");
    }

    private static final Path invalidateProjectCacheMarkerFile_delegate$lambda$0(WorkspaceModelCacheImpl this$0) {
        return ProjectUtil.getProjectDataPath((Project)this$0.project, (String)DATA_DIR_NAME).resolve(".invalidate");
    }

    private static final WorkspaceModelCacheSerializer cacheSerializer_delegate$lambda$0(WorkspaceModelCacheImpl this$0) {
        if (this$0.virtualFileUrlManager == null) {
            throw new UninitializedPropertyAccessException("VirtualFileUrlManager was not initialized. Please call `WorkspaceModelCache.setVirtualFileUrlManager` before any other methods.");
        }
        VirtualFileUrlManager virtualFileUrlManager = this$0.virtualFileUrlManager;
        if (virtualFileUrlManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualFileUrlManager");
            virtualFileUrlManager = null;
        }
        return new WorkspaceModelCacheSerializer(virtualFileUrlManager, this$0.urlRelativizer);
    }

    private static final Unit prepareStorage$lambda$0(Ref.ObjectRef $current, WorkspaceModelSerializerHook it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $current.element = it.beforeSerialization((ImmutableEntityStorage)$current.element);
        return Unit.INSTANCE;
    }

    private static final void prepareStorage$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit prepareUnloadedStorage$lambda$0(Ref.ObjectRef $current, WorkspaceModelSerializerHook it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $current.element = it.beforeUnloadedSerialization((ImmutableEntityStorage)$current.element);
        return Unit.INSTANCE;
    }

    private static final void prepareUnloadedStorage$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void forceEnableCaching(@NotNull Disposable disposable) {
        Companion.forceEnableCaching(disposable);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelCacheImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        cachesInvalidated = new AtomicBoolean(false);
        Path path = ProjectUtil.getProjectsDataDir().resolve(".invalidate");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        invalidateCachesMarkerFile = path;
        saveWorkspaceModelCachesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        Meter meter = JpsMetricsKt.getJpsMetrics().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        WorkspaceModelCacheImpl.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u000b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl$Companion;", "", "<init>", "()V", "SERIALIZER_HOOKS", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelSerializerHook;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DATA_DIR_NAME", "", "forceEnableCaching", "", "testCacheFile", "Ljava/nio/file/Path;", "getTestCacheFile", "()Ljava/nio/file/Path;", "setTestCacheFile", "(Ljava/nio/file/Path;)V", "cachesInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "invalidateCachesMarkerFile", "getInvalidateCachesMarkerFile$intellij_platform_ide_impl", "invalidateCaches", "", "disposable", "Lcom/intellij/openapi/Disposable;", "saveWorkspaceModelCachesTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "setupOpenTelemetryReporting", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path getTestCacheFile() {
            return testCacheFile;
        }

        public final void setTestCacheFile(@Nullable Path path) {
            testCacheFile = path;
        }

        @NotNull
        public final Path getInvalidateCachesMarkerFile$intellij_platform_ide_impl() {
            return invalidateCachesMarkerFile;
        }

        public final void invalidateCaches() {
            LOG.info("Invalidating caches by creating " + this.getInvalidateCachesMarkerFile$intellij_platform_ide_impl());
            WorkspaceModelCacheSerializerKt.invalidateCaches(cachesInvalidated, this.getInvalidateCachesMarkerFile$intellij_platform_ide_impl());
        }

        @JvmStatic
        public final void forceEnableCaching(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            forceEnableCaching = true;
            Disposer.register((Disposable)disposable, Companion::forceEnableCaching$lambda$0);
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement saveWorkspaceModelCachesTimeCounter = meter.counterBuilder("workspaceModel.do.save.caches.ms").buildObserver();
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(saveWorkspaceModelCachesTimeCounter), (ObservableMeasurement)saveWorkspaceModelCachesTimeCounter, new ObservableMeasurement[0]);
        }

        private static final void forceEnableCaching$lambda$0() {
            forceEnableCaching = false;
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $saveWorkspaceModelCachesTimeCounter) {
            $saveWorkspaceModelCachesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)saveWorkspaceModelCachesTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

