/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import com.intellij.util.text.CharArrayCharSequence;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.io.InputStream;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bJ \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\"\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/netty/buffer/ByteBufUtf8Writer;", "Ljava/io/Writer;", "buffer", "Lio/netty/buffer/ByteBuf;", "<init>", "(Lio/netty/buffer/ByteBuf;)V", "write", "", "inputStream", "Ljava/io/InputStream;", "length", "", "ensureWritable", "minWritableBytes", "chars", "", "off", "len", "str", "", "append", "csq", "", "start", "end", "flush", "close", "intellij.platform.ide.impl"})
public final class ByteBufUtf8Writer
extends Writer {
    @NotNull
    private final ByteBuf buffer;

    public ByteBufUtf8Writer(@NotNull ByteBuf buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        this.buffer = buffer2;
    }

    public final void write(@NotNull InputStream inputStream, int length) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.buffer.writeBytes(inputStream, length);
    }

    public final void ensureWritable(int minWritableBytes) {
        this.buffer.ensureWritable(minWritableBytes);
    }

    @Override
    public void write(@NotNull char[] chars, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)((CharSequence)new CharArrayCharSequence(chars, off, off + len)));
    }

    @Override
    public void write(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)str);
    }

    @Override
    public void write(@NotNull String str, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ByteBufUtilEx.writeUtf8(this.buffer, str, off, off + len);
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq) {
        int n = csq == null ? ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)"null") : ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)csq);
        return this;
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq, int start2, int end) {
        ByteBufUtilEx.writeUtf8(this.buffer, csq, start2, end);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

