/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.mandatory;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import org.jetbrains.io.mandatory.JsonMandatoryException;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;

public final class NullCheckingFactory
implements TypeAdapterFactory {
    public static final NullCheckingFactory INSTANCE = new NullCheckingFactory();

    public <T> TypeAdapter<T> create(Gson gson, final TypeToken<T> type) {
        if (type.getRawType().getAnnotation(RestModel.class) == null) {
            return null;
        }
        final TypeAdapter defaultAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(this){

            public void write(JsonWriter out2, T value) throws IOException {
                defaultAdapter.write(out2, value);
            }

            public T read(JsonReader in) throws IOException {
                Object stub = defaultAdapter.read(in);
                if (stub == null) {
                    return null;
                }
                for (Field field : ReflectionUtil.collectFields((Class)type.getRawType())) {
                    if (field.getAnnotation(Mandatory.class) == null) continue;
                    try {
                        field.setAccessible(true);
                        if (field.get(stub) != null) continue;
                        throw new JsonMandatoryException(String.format("Field '%s' is mandatory, but missing in response", field.getName()));
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                return stub;
            }
        };
    }
}

