/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class ColorSettingsUtil {
    private ColorSettingsUtil() {
    }

    public static Map<TextAttributesKey, String> keyToDisplayTextMap(ColorSettingsPage page) {
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)page);
        HashMap<TextAttributesKey, String> displayText = new HashMap<TextAttributesKey, String>();
        for (AttributesDescriptor attributeDescriptor : attributeDescriptors) {
            TextAttributesKey key = attributeDescriptor.getKey();
            displayText.put(key, attributeDescriptor.getDisplayName());
        }
        return displayText;
    }

    public static List<AttributesDescriptor> getAllAttributeDescriptors(@NotNull ColorAndFontDescriptorsProvider provider) {
        if (provider == null) {
            ColorSettingsUtil.$$$reportNull$$$0(0);
        }
        ArrayList<AttributesDescriptor> result2 = new ArrayList<AttributesDescriptor>();
        Collections.addAll(result2, provider.getAttributeDescriptors());
        if (ColorSettingsUtil.isInspectionColorsPage(provider)) {
            ColorSettingsUtil.addInspectionSeverityAttributes(result2);
        }
        return result2;
    }

    public static List<ColorDescriptor> getAllColorDescriptors(@NotNull ColorAndFontDescriptorsProvider provider) {
        if (provider == null) {
            ColorSettingsUtil.$$$reportNull$$$0(1);
        }
        ArrayList<ColorDescriptor> result2 = new ArrayList<ColorDescriptor>();
        Collections.addAll(result2, provider.getColorDescriptors());
        return result2;
    }

    private static boolean isInspectionColorsPage(ColorAndFontDescriptorsProvider provider) {
        ColorSettingsPage settingsPage;
        if (!(provider instanceof InspectionColorSettingsPage)) {
            return false;
        }
        Iterator iterator = ColorSettingsPage.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (settingsPage = (ColorSettingsPage)iterator.next()) != provider) {
            if (!(settingsPage instanceof InspectionColorSettingsPage)) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static @NotNull @Unmodifiable List<@NotNull Pair<TextAttributesKey, @Nls String>> getErrorTextAttributes() {
        ArrayList<@Nls Pair> attributes = new ArrayList<Pair>(List.of(new Pair((Object)CodeInsightColors.ERRORS_ATTRIBUTES, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.error", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.unknown.symbol", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.WARNINGS_ATTRIBUTES, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.warning", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.WEAK_WARNING_ATTRIBUTES, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.weak.warning", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.unused.symbol", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.DEPRECATED_ATTRIBUTES, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.deprecated.symbol", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.marked.for.removal.symbol", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.DUPLICATE_FROM_SERVER, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.server.duplicate", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.server.problems", (Object[])new Object[0])), new Pair((Object)CodeInsightColors.RUNTIME_ERROR, (Object)OptionsBundle.message((String)"options.java.attribute.descriptor.runtime", (Object[])new Object[0]))));
        attributes.add(new Pair((Object)TextAttributesKey.find((String)"REASSIGNED_LOCAL_VARIABLE_ATTRIBUTES"), (Object)OptionsBundle.message((String)"options.language.defaults.reassigned.local.variable", (Object[])new Object[0])));
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                TextAttributesKey attributesKey = highlightInfoType.getAttributesKey();
                attributes.add(new Pair((Object)attributesKey, (Object)ColorSettingsUtil.toDisplayName(attributesKey)));
            }
        }
        List<Pair<TextAttributesKey, String>> list2 = List.copyOf(attributes);
        if (list2 == null) {
            ColorSettingsUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static void addInspectionSeverityAttributes(List<? super AttributesDescriptor> descriptors2) {
        for (Pair<TextAttributesKey, String> pair : ColorSettingsUtil.getErrorTextAttributes()) {
            descriptors2.add((AttributesDescriptor)new AttributesDescriptor((String)pair.second, (TextAttributesKey)pair.first));
        }
    }

    @NlsContexts.AttributeDescriptor
    @NotNull
    private static String toDisplayName(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            ColorSettingsUtil.$$$reportNull$$$0(3);
        }
        String string = OptionsBundle.message((String)"options.java.attribute.descriptor.errors.group", (Object[])new Object[]{StringUtil.capitalize((String)StringUtil.toLowerCase((String)attributesKey.getExternalName()).replaceAll("_", " "))});
        if (string == null) {
            ColorSettingsUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/ColorSettingsUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/ColorSettingsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTextAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllAttributeDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllColorDescriptors";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toDisplayName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

