/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.editor.fonts.AppFontOptionsPanel;
import com.intellij.application.options.editor.fonts.AppFontPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppFontOptions;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class AppFontConfigurable
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll {
    private final NotNullLazyValue<AppFontPanel> myFontPanelInstance = NotNullLazyValue.lazy(() -> new AppFontPanel(new AppFontPanel.FontOptionsPanelFactory(){

        @Override
        @NotNull
        public AppFontOptionsPanel create(@NotNull EditorColorsScheme previewScheme) {
            if (previewScheme == null) {
                1.$$$reportNull$$$0(0);
            }
            AppFontOptionsPanel appFontOptionsPanel = AppFontConfigurable.this.createFontOptionsPanel(previewScheme);
            if (appFontOptionsPanel == null) {
                1.$$$reportNull$$$0(1);
            }
            return appFontOptionsPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewScheme";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/fonts/AppFontConfigurable$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/fonts/AppFontConfigurable$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }));

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.getFontPanel().getComponent();
        if (jPanel == null) {
            AppFontConfigurable.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified() {
        this.getFontPanel().updateWarning();
        return !this.getStoredPreferences().equals(this.getUIFontPreferences());
    }

    public final void apply() {
        this.applyFontPreferences();
        EditorFontCache.getInstance().reset();
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        EditorFactory.getInstance().refreshAllEditors();
    }

    protected void applyFontPreferences() {
        this.getFontOptions().update(this.getUIFontPreferences());
    }

    @NotNull
    private FontPreferences getUIFontPreferences() {
        FontPreferences fontPreferences = this.getFontPanel().getOptionsPanel().getFontPreferences();
        if (fontPreferences == null) {
            AppFontConfigurable.$$$reportNull$$$0(1);
        }
        return fontPreferences;
    }

    public void reset() {
        this.getStoredPreferences().copyTo(this.getUIFontPreferences());
        this.getFontPanel().getOptionsPanel().updateOnChangedFont();
    }

    @NotNull
    private FontPreferences getStoredPreferences() {
        FontPreferences fontPreferences = this.getFontOptions().getFontPreferences();
        if (fontPreferences == null) {
            AppFontConfigurable.$$$reportNull$$$0(2);
        }
        return fontPreferences;
    }

    @NotNull
    protected abstract AppFontOptions<?> getFontOptions();

    @NotNull
    private AppFontPanel getFontPanel() {
        AppFontPanel appFontPanel = (AppFontPanel)this.myFontPanelInstance.getValue();
        if (appFontPanel == null) {
            AppFontConfigurable.$$$reportNull$$$0(3);
        }
        return appFontPanel;
    }

    public void disposeUIResources() {
        if (this.myFontPanelInstance.isComputed()) {
            Disposer.dispose((Disposable)this.getFontPanel());
        }
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.colors";
    }

    @NotNull
    protected abstract AppFontOptionsPanel createFontOptionsPanel(@NotNull EditorColorsScheme var1);

    protected static AppFontConfigurable findConfigurable(JComponent component2, Class<? extends AppFontConfigurable> confClass) {
        Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)component2));
        return allSettings != null ? allSettings.find(confClass) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/application/options/editor/fonts/AppFontConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIFontPreferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredPreferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

