/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.editor.fonts.AppFontOptionsPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AppFontPanel
implements Disposable {
    @NotNull
    private final AppFontOptionsPanel myOptionsPanel;
    @NotNull
    private final FontEditorPreview myPreview;
    @NotNull
    private final EditorColorsScheme myPreviewScheme;
    @NotNull
    private final JPanel myTopPanel;
    private JLabel myEditorFontLabel;
    @NotNull
    private final JPanel myWarningPanel;

    public AppFontPanel(@NotNull FontOptionsPanelFactory fontOptionsPanelFactory) {
        if (fontOptionsPanelFactory == null) {
            AppFontPanel.$$$reportNull$$$0(0);
        }
        this.myTopPanel = new JPanel(new BorderLayout());
        this.myWarningPanel = this.createMessagePanel();
        this.myTopPanel.add((Component)this.myWarningPanel, "North");
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        JBSplitter splitter2 = new JBSplitter(false, 0.3f);
        this.myPreviewScheme = AppFontPanel.createPreviewScheme();
        this.myOptionsPanel = fontOptionsPanelFactory.create(this.myPreviewScheme);
        this.myOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myPreview = new FontEditorPreview(this, () -> this.myPreviewScheme, true){

            @Override
            protected Border getBorder() {
                return JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)1);
            }
        };
        splitter2.setFirstComponent((JComponent)this.myOptionsPanel);
        splitter2.setSecondComponent(this.myPreview.getPanel());
        innerPanel.add((Component)splitter2, "Center");
        this.myOptionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                AppFontPanel.this.updatePreview();
                AppFontPanel.this.updateWarning();
            }
        });
        this.myTopPanel.add((Component)innerPanel, "Center");
    }

    private JPanel createMessagePanel() {
        JPanel messagePanel = new JPanel(new FlowLayout(0));
        messagePanel.add(new JLabel(AllIcons.General.BalloonWarning));
        this.myEditorFontLabel = this.createHyperlinkLabel();
        messagePanel.add(this.myEditorFontLabel);
        JLabel commentLabel = new JLabel(ApplicationBundle.message((String)"settings.editor.font.defined.in.color.scheme.message", (Object[])new Object[0]));
        commentLabel.setForeground((Color)JBColor.GRAY);
        messagePanel.add(commentLabel);
        return messagePanel;
    }

    @NotNull
    private JLabel createHyperlinkLabel() {
        HoverHyperlinkLabel label2 = new HoverHyperlinkLabel("");
        label2.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    AppFontPanel.this.navigateToColorSchemeFontConfigurable();
                }
            }
        });
        HoverHyperlinkLabel hoverHyperlinkLabel = label2;
        if (hoverHyperlinkLabel == null) {
            AppFontPanel.$$$reportNull$$$0(1);
        }
        return hoverHyperlinkLabel;
    }

    private void navigateToColorSchemeFontConfigurable() {
        SearchableConfigurable fontOptions;
        Configurable colorSchemeConfigurable;
        Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myTopPanel));
        if (allSettings != null && (colorSchemeConfigurable = allSettings.find("reference.settingsdialog.IDE.editor.colors")) instanceof ColorAndFontOptions && (fontOptions = ((ColorAndFontOptions)colorSchemeConfigurable).findSubConfigurable(ColorAndFontOptions.getFontConfigurableName())) != null) {
            allSettings.select((Configurable)fontOptions);
        }
    }

    public void updateWarning() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (!scheme.isUseAppFontPreferencesInEditor()) {
            this.myEditorFontLabel.setText(ApplicationBundle.message((String)"settings.editor.font.overridden.message", (Object[])new Object[]{scheme.getEditorFontName(), scheme.getEditorFontSize()}));
            this.myWarningPanel.setVisible(true);
        } else {
            this.myWarningPanel.setVisible(false);
        }
    }

    public void updatePreview() {
        if (this.myPreviewScheme instanceof EditorFontCache) {
            ((EditorFontCache)this.myPreviewScheme).reset();
        }
        this.myPreview.updateView();
    }

    public void dispose() {
        this.myPreview.disposeUIResources();
    }

    @NotNull
    private static EditorColorsScheme createPreviewScheme() {
        EditorColorsScheme scheme = (EditorColorsScheme)EditorColorsManager.getInstance().getSchemeForCurrentUITheme().clone();
        scheme.setFontPreferences((FontPreferences)new FontPreferencesImpl());
        EditorColorsScheme editorColorsScheme = scheme;
        if (editorColorsScheme == null) {
            AppFontPanel.$$$reportNull$$$0(2);
        }
        return editorColorsScheme;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myTopPanel;
        if (jPanel == null) {
            AppFontPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    public AppFontOptionsPanel getOptionsPanel() {
        AppFontOptionsPanel appFontOptionsPanel = this.myOptionsPanel;
        if (appFontOptionsPanel == null) {
            AppFontPanel.$$$reportNull$$$0(4);
        }
        return appFontOptionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontOptionsPanelFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/editor/fonts/AppFontPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/editor/fonts/AppFontPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlinkLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    protected static interface FontOptionsPanelFactory {
        @NotNull
        public AppFontOptionsPanel create(@NotNull EditorColorsScheme var1);
    }
}

