/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.application.options.pathMacros.PathMacroListEditorUI;
import com.intellij.application.options.pathMacros.PathMacroTable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;

public final class PathMacroListEditor {
    private final PathMacroListEditorUI ui;
    private final PathMacroTable myPathMacroTable;

    public PathMacroListEditor() {
        this(null);
    }

    public PathMacroListEditor(Collection<String> undefinedMacroNames) {
        this.myPathMacroTable = undefinedMacroNames != null ? new PathMacroTable(undefinedMacroNames) : new PathMacroTable();
        this.ui = new PathMacroListEditorUI(ToolbarDecorator.createDecorator((JTable)((Object)this.myPathMacroTable)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PathMacroListEditor.this.myPathMacroTable.addMacro();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PathMacroListEditor.this.myPathMacroTable.removeSelectedMacros();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PathMacroListEditor.this.myPathMacroTable.editMacro();
            }
        }).disableUpDownActions().createPanel());
        this.fillIgnoredVariables();
    }

    private void fillIgnoredVariables() {
        Collection ignored = PathMacros.getInstance().getIgnoredMacroNames();
        this.ui.ignoredVariables.setText(StringUtil.join((Collection)ignored, (String)";"));
    }

    private boolean isIgnoredModified() {
        Collection ignored = PathMacros.getInstance().getIgnoredMacroNames();
        return !this.parseIgnoredVariables().equals(ignored);
    }

    private Collection<String> parseIgnoredVariables() {
        String s = this.ui.ignoredVariables.getText();
        ArrayList<String> ignored = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreElements()) {
            ignored.add(st.nextElement().trim());
        }
        return ignored;
    }

    public void commit() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myPathMacroTable.commit();
            Collection<String> ignored = this.parseIgnoredVariables();
            PathMacros instance = PathMacros.getInstance();
            instance.setIgnoredMacroNames(ignored);
        });
    }

    public JComponent getPanel() {
        return this.ui.getContent();
    }

    public void reset() {
        this.myPathMacroTable.reset();
        this.fillIgnoredVariables();
    }

    public boolean isModified() {
        return this.myPathMacroTable.isModified() || this.isIgnoredModified();
    }

    private void createUIComponents() {
    }
}

